﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

namespace nispi.controlclass
{
    class ToolStripTextBoxParts
    {
        public ToolStripTextBox control;

        public ToolStripTextBoxParts()
        {
            this.control = new ToolStripTextBox();
            this.control.BorderStyle = BorderStyle.FixedSingle;
            //this.control.MouseEnter += new EventHandler(control_MouseEnter);
        }
        public void control_MouseEnter(object sender, EventArgs e)
        {
            this.control.Focus();
        }
        
        public string Name
        {
            set
            {
                this.control.Name = value;
            }
            get
            {
                return this.control.Name;
            }
        }
        public string Text
        {
            set
            {
                this.control.Text = value;
            }
            get
            {
                return this.control.Text;
            }
        }
        public Size Size
        {
            set
            {
                this.control.Size = value;
            }
            get
            {
                return this.control.Size;
            }
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class ToolStripTextBoxPartsManager
    {
        public static Stack<ToolStripTextBoxParts> tabPageStack = new Stack<ToolStripTextBoxParts>();
        public static Mutex mutex = new Mutex(false, "ToolStripTextBoxPartsManager");

        public static ToolStripTextBoxParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new ToolStripTextBoxParts());

            ToolStripTextBoxParts tabPage = tabPageStack.Pop();
            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(ToolStripTextBoxParts tabPage)
        {
            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }
    }
}
