﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

using nispi;

namespace nispi.OptionControl
{
    partial class OutWardBrowser : CommonInEvent
    {
        //ブラウザーのフォント
        private string browserFontName;
        private float browserFontSize;
        //ブラウザーのオリジナルフォント
        private string browserOriginalFontName;
        private string browserOriginalFontPath;
        private float browserOriginalFontSize;
        //インストール済みフォントか、オリジナルフォントか
        private string browserFontType;

        //ブラウザの文字色
        private byte browserForeColorRed;
        private byte browserForeColorGreen;
        private byte browserForeColorBlue;
        //背景色
        private byte browserBackColorRed;
        private byte browserBackColorGreen;
        private byte browserBackColorBlue;
        //リンクの色
        private byte browserLinkColorRed;
        private byte browserLinkColorGreen;
        private byte browserLinkColorBlue;
        //既リンクの色
        private byte browserLinkedColorRed;
        private byte browserLinkedColorGreen;
        private byte browserLinkedColorBlue;

        private string browserType;
        
        private Mutex mutex = new Mutex(false, "OutWardBrowserData");

        //ブラウザーのフォント
        public string tempBrowserFontName;
        public float tempBrowserFontSize;
        //ブラウザの文字色
        public byte tempBrowserForeColorRed;
        public byte tempBrowserForeColorGreen;
        public byte tempBrowserForeColorBlue;
        //背景色
        public byte tempBrowserBackColorRed;
        public byte tempBrowserBackColorGreen;
        public byte tempBrowserBackColorBlue;
        //リンクの色
        public byte tempBrowserLinkColorRed;
        public byte tempBrowserLinkColorGreen;
        public byte tempBrowserLinkColorBlue;
        //既リンクの色
        public byte tempBrowserLinkedColorRed;
        public byte tempBrowserLinkedColorGreen;
        public byte tempBrowserLinkedColorBlue;

        public string tempBrowserType;

        public string ResetXML()
        {
            mutex.WaitOne();

            XNamespace ns = "OutWard_Browser";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "BrowserFontName", "ＭＳ Ｐゴシック"),
                new XElement(ns + "BrowserFontSize", "12.0"),
                
                new XElement(ns + "LVOriginalFontName", "None"),
                new XElement(ns + "LVOriginalFontPath", "None"),
                new XElement(ns + "LVOriginalFontSize", "12.0"),
                new XElement(ns + "LVFontType", "installed"),

                new XElement(ns + "BrowserForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "BrowserForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "BrowserForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "BrowserBackColorRed", SystemColors.Window.R.ToString()),
                new XElement(ns + "BrowserBackColorGreen", SystemColors.Window.G.ToString()),
                new XElement(ns + "BrowserBackColorBlue", SystemColors.Window.B.ToString()),

                new XElement(ns + "BrowserLinkColorRed", 0),
                new XElement(ns + "BrowserLinkColorGreen", 0),
                new XElement(ns + "BrowserLinkColorBlue", 255),

                new XElement(ns + "BrowserLinkedColorRed", 128),
                new XElement(ns + "BrowserLinkedColorGreen", 0),
                new XElement(ns + "BrowserLinkedColorBlue", 128),
                new XElement(ns + "BrowserType", "ageon"));

            FileIO.SaveShiftJis("setting", "outward_browser.xml", doc.ToString());

            mutex.ReleaseMutex();

            return doc.ToString();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "outward_browser.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "OutWard_Browser";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                BrowserFontName = doc2.Element(ns + "BrowserFontName").Value;
                BrowserFontSize = float.Parse(doc2.Element(ns + "BrowserFontSize").Value);
                
                //以前のバージョン設定を使っている人向け
                try
                {
                    BrowserOriginalFontName = doc2.Element(ns + "BrowserOriginalFontName").Value;
                    BrowserOriginalFontPath = doc2.Element(ns + "BrowserOriginalFontPath").Value;
                    BrowserOriginalFontSize = float.Parse(doc2.Element(ns + "BrowserOriginalFontSize").Value);
                    BrowserFontType = doc2.Element(ns + "BrowserFontType").Value;

                    if (BrowserFontType.Equals("original") == true)
                    {
                        System.Drawing.Text.PrivateFontCollection pfc = new System.Drawing.Text.PrivateFontCollection();
                        //オリジナルフォントを設定
                        pfc.AddFontFile(BrowserOriginalFontPath);
                        //this.LVOriginalFont = new Font(this.pfc.Families[0], this.LVOriginalFontSize);
                    }
                }
                catch
                {
                    BrowserOriginalFontName = "None";
                    BrowserOriginalFontPath = "None";
                    BrowserOriginalFontSize = 12.0f;
                    BrowserFontType = "installed";
                }
                BrowserForeColorRed = Byte.Parse(doc2.Element(ns + "BrowserForeColorRed").Value);
                BrowserForeColorGreen = Byte.Parse(doc2.Element(ns + "BrowserForeColorGreen").Value);
                BrowserForeColorBlue = Byte.Parse(doc2.Element(ns + "BrowserForeColorBlue").Value);

                BrowserBackColorRed = Byte.Parse(doc2.Element(ns + "BrowserBackColorRed").Value);
                BrowserBackColorGreen = Byte.Parse(doc2.Element(ns + "BrowserBackColorGreen").Value);
                BrowserBackColorBlue = Byte.Parse(doc2.Element(ns + "BrowserBackColorBlue").Value);

                BrowserLinkColorRed = Byte.Parse(doc2.Element(ns + "BrowserLinkColorRed").Value);
                BrowserLinkColorGreen = Byte.Parse(doc2.Element(ns + "BrowserLinkColorGreen").Value);
                BrowserLinkColorBlue = Byte.Parse(doc2.Element(ns + "BrowserLinkColorBlue").Value);

                BrowserLinkedColorRed = Byte.Parse(doc2.Element(ns + "BrowserLinkedColorRed").Value);
                BrowserLinkedColorGreen = Byte.Parse(doc2.Element(ns + "BrowserLinkedColorGreen").Value);
                BrowserLinkedColorBlue = Byte.Parse(doc2.Element(ns + "BrowserLinkedColorBlue").Value);
                BrowserType = doc2.Element(ns + "BrowserType").Value;
                //
                tempBrowserFontName = BrowserFontName;
                tempBrowserFontSize = BrowserFontSize;

                tempBrowserForeColorRed = BrowserForeColorRed;
                tempBrowserForeColorGreen = BrowserForeColorGreen;
                tempBrowserForeColorBlue = BrowserForeColorBlue;

                tempBrowserBackColorRed = BrowserBackColorRed;
                tempBrowserBackColorGreen = BrowserBackColorGreen;
                tempBrowserBackColorBlue = BrowserBackColorBlue;

                tempBrowserLinkColorRed = BrowserLinkColorRed;
                tempBrowserLinkColorGreen = BrowserLinkColorGreen;
                tempBrowserLinkColorBlue = BrowserLinkColorBlue;

                tempBrowserLinkedColorRed = BrowserLinkedColorRed;
                tempBrowserLinkedColorGreen = BrowserLinkedColorGreen;
                tempBrowserLinkedColorBlue = BrowserLinkedColorBlue;

                tempBrowserType = BrowserType;
            }
            catch { ;}

            mutex.ReleaseMutex();
        }

        public void SaveBrowserToFile()
        {

            mutex.WaitOne();

            XNamespace ns = "OutWard_Browser";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "BrowserFontName", BrowserFontName),
                new XElement(ns + "BrowserFontSize", BrowserFontSize.ToString()),
                
                new XElement(ns + "BrowserOriginalFontName", BrowserOriginalFontName),
                new XElement(ns + "BrowserOriginalFontPath", BrowserOriginalFontPath),
                new XElement(ns + "BrowserOriginalFontSize", BrowserOriginalFontSize.ToString()),
                new XElement(ns + "BrowserFontType", BrowserFontType),

                new XElement(ns + "BrowserForeColorRed", BrowserForeColorRed.ToString()),
                new XElement(ns + "BrowserForeColorGreen", BrowserForeColorGreen.ToString()),
                new XElement(ns + "BrowserForeColorBlue", BrowserForeColorBlue.ToString()),

                new XElement(ns + "BrowserBackColorRed", BrowserBackColorRed.ToString()),
                new XElement(ns + "BrowserBackColorGreen", BrowserBackColorGreen.ToString()),
                new XElement(ns + "BrowserBackColorBlue", BrowserBackColorBlue.ToString()),

                new XElement(ns + "BrowserLinkColorRed", BrowserLinkColorRed.ToString()),
                new XElement(ns + "BrowserLinkColorGreen", BrowserLinkColorGreen.ToString()),
                new XElement(ns + "BrowserLinkColorBlue", BrowserLinkColorBlue.ToString()),

                new XElement(ns + "BrowserLinkedColorRed", BrowserLinkedColorRed.ToString()),
                new XElement(ns + "BrowserLinkedColorGreen", BrowserLinkedColorGreen.ToString()),
                new XElement(ns + "BrowserLinkedColorBlue", BrowserLinkedColorBlue.ToString()),
                new XElement(ns + "BrowserType", this.BrowserType));

            FileIO.SaveShiftJis("setting", "outward_browser.xml", doc.ToString());

            mutex.ReleaseMutex();
        }
        public String BrowserType
        {
            set
            {
                mutex.WaitOne();
                this.browserType = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.browserType);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public String BrowserFontName
        {
            set
            {
                mutex.WaitOne();
                this.browserFontName = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.browserFontName);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public float BrowserFontSize
        {
            set
            {
                mutex.WaitOne();
                this.browserFontSize = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                float data = this.browserFontSize;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //////////////////////////////////
        //オリジナルフォント
        public String BrowserOriginalFontName
        {
            set
            {
                mutex.WaitOne();
                this.browserOriginalFontName = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.browserOriginalFontName);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public String BrowserOriginalFontPath
        {
            set
            {
                mutex.WaitOne();
                this.browserOriginalFontPath = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.browserOriginalFontPath);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public float BrowserOriginalFontSize
        {
            set
            {
                mutex.WaitOne();
                this.browserOriginalFontSize = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                float data = this.browserOriginalFontSize;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string BrowserFontType
        {
            set
            {
                mutex.WaitOne();
                this.browserFontType = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = this.browserFontType.ToString();
                mutex.ReleaseMutex();
                return data;
            }
        }
        //////////////////////////////////
        public string BrowserForeColor
        {
            get
            {
                string foreColor = Convert.ToString(this.BrowserForeColorRed, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserForeColorGreen, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserForeColorBlue, 16).PadLeft(2, '0');

                return foreColor;
            }
        }
        public string BrowserBackColor
        {
            get
            {
                string backColor = Convert.ToString(this.BrowserBackColorRed, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserBackColorGreen, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserBackColorBlue, 16).PadLeft(2, '0');

                return backColor;
            }
        }
        public string BrowserLinkColor
        {
            get
            {
                string linkColor = Convert.ToString(this.BrowserLinkColorRed, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserLinkColorGreen, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserLinkColorBlue, 16).PadLeft(2, '0');

                return linkColor;
            }
        }
        public string BrowserLinkedColor
        {
            get
            {
                string linkedColor = Convert.ToString(this.BrowserLinkedColorRed, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserLinkedColorGreen, 16).PadLeft(2, '0') +
                    Convert.ToString(this.BrowserLinkedColorBlue, 16).PadLeft(2, '0');

                return linkedColor;
            }
        }
        public byte BrowserForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        /////////////////////////////////
        public byte BrowserBackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserBackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserBackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserBackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserBackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserBackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserBackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserBackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserBackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //////////////////////////////////
        /////////////////////////////////
        public byte BrowserLinkColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserLinkColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserLinkColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserLinkColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserLinkColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserLinkColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserLinkColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserLinkColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserLinkColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        /////////////////////////////////
        public byte BrowserLinkedColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserLinkedColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserLinkedColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserLinkedColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserLinkedColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserLinkedColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte BrowserLinkedColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.browserLinkedColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.browserLinkedColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
    }
}
