﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.IO;
//using System.Threading.Tasks;

//メインフォームを閉じるときに保存、
////BoardIndexViewにてRead()を行っている
namespace nispi.SaveBoardAndThread
{
    class SaveThread
    {
        public SaveThread()
        {
        }

        public void Save(List<ThreadViewCommon> list)
        {
            string ns = "SaveThreadList";

            XmlDocument doc = new XmlDocument();
            XmlElement saveBoardList = doc.CreateElement("SaveThreadList", ns);
            doc.AppendChild(saveBoardList);

            foreach (ThreadViewCommon threadView in list)
            {
                if (threadView.datUrl == null) break;

                //エレメントを作成
                XmlElement threadAddress = doc.CreateElement("ThreadAddress", ns);
                //内部にAddressを作成
                threadAddress.SetAttribute("Address", threadView.datUrl);
                //スレッドの名前を<>と</>に囲われた中身に設定
                threadAddress.InnerText = threadView.threadName;
                //SaveThreadListの下位に加える
                saveBoardList.AppendChild(threadAddress);
            }

            FileIO.SaveShiftJis("setting", "SaveThreadList.xml", doc.OuterXml);
        }

        delegate void ShowThreadDelegate(string threadUrl, string threadName);
        
        public void Read()
        {
            string str = FileIO.ReadShiftJis("setting", "SaveThreadList.xml");

            //中身がなければリターン
            if ((str == null) || (str.Length == 0)) return;
            
            XmlDocument dom = new XmlDocument();
            dom.LoadXml(str);

            foreach (XmlElement node in dom.GetElementsByTagName("ThreadAddress", "SaveThreadList"))
            {
                //Addressの値を得る
                string threadUrl = node.Attributes["Address"].Value;
                //<>と</>に囲われた部分を得る
                string threadName = node.InnerText;

                //スレッドとしてタブを開く
                Const.form.mainForm.Invoke(new ShowThreadDelegate(MainFormConst.threadListTabMain.ShowThread), threadUrl, threadName);
            }

            //Const.form.mainForm.Invoke((Action)(() => Const.form.threadListTabControlParts.SelectedIndex = 0));
        }
    }
}