﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Net;
using System.IO;
using System.Threading;
using System.Drawing;
using System.Text;
using System.Linq;
using System.Runtime.InteropServices;

using nispi.controlclass;
using nispi.BoardListBrowser;

namespace nispi
{
    class ZenbunSearchView : BoardViewCommon
    {
        public BoardListBrowserParts boardListBrowserParts;
        public ZenbunSearchView()
        {
            try
            {
                this.boardListControls = new BoardListControls(this as BoardViewCommon);
                this.boardListControls.closeTabButtonParts.Enabled = false;

                this.boardListControls.listViewParts.VirtualListSize = 0;
                this.boardListControls.listViewParts.boardView = this as BoardViewCommon;
                this.boardListControls.listViewParts.Hide();

                boardListBrowserParts = BoardListBrowserCtrlManager.Pop();
                boardListBrowserParts.Location = new Point(0, 27);
                boardListBrowserParts.ownerForm = Const.form.mainForm;

                this.boardListControls.tabPageExParts.AddControl(boardListBrowserParts);


                Const.form.boardListTabControlParts.AddControl(this.boardListControls.tabPageExParts);


                this.boardListControls.listViewParts.Size =
                    new Size(Const.form.boardListTabControlParts.Size.Width - 2,
                        Const.form.boardListTabControlParts.Size.Height - 27);

                Const.form.mainForm.Invoke((Action)(() => ChangeUserAgent()));
            }
            catch { ;}
        }
        public override void Dispoose()
        {
            try
            {
                this.boardListControls.RemoveAllControls();

                MainFormConst.boardListTabMain.remove_view((BoardViewCommon)this);

                Const.form.boardListTabControlParts.Refresh();
            }
            catch { ;}
        }
        public override void BrowserOpen(string url)
        {
            Const.form.mainForm.Invoke((Action)(() => this.boardListBrowserParts.AllowNavigation = true));
            Const.form.mainForm.Invoke((Action)(() => this.boardListBrowserParts.control.Navigate(url)));///, null, null, "User-Agent: Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0; AgeOn) like Gecko")));
            Const.form.mainForm.Invoke((Action)(() => this.boardListBrowserParts.type = "refind2ch"));
        }

        [DllImport("urlmon.dll", CharSet = CharSet.Ansi)]
        private static extern int UrlMkSetSessionOption(
            int dwOption, string pBuffer, int dwBufferLength, int dwReserved);

        const int URLMON_OPTION_USERAGENT = 0x10000001;

        public void ChangeUserAgent()
        {
            string ua = "Monazilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0; AgeOn) like Gecko";

            UrlMkSetSessionOption(URLMON_OPTION_USERAGENT, ua, ua.Length, 0);
        }
    }
}