﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Drawing;
using System.Diagnostics;

namespace nispi
{
    class FormShowStyle
    {
        public string NOW_TYPE;
        public string TYPE1 = "TYPE1";
        public string TYPE2 = "TYPE2";
        public string TYPE3 = "TYPE3";

        public string MAXSIZETHREAD = "OFF";

        public string MAXSIZEBOARD= "OFF";

        public string MAXSIZEINDEX = "OFF";

        public FormShowStyle()
        {
            NOW_TYPE = "TYPE1";
        }

        public void ChangeToType1()
        {
            //設定をオフ
            if (NOW_TYPE.Equals(TYPE2) == true)
                OffType2();
            else if (NOW_TYPE.Equals(TYPE3) == true)
                OffType3();
            else
                return;

            ReSizeType1();

            Const.form.mainSplitContainerParts.AddToPanel1(Const.form.boardIndexTabControlParts);
            Const.form.subMainSplitContainerParts.AddToPanel1(Const.form.boardListTabControlParts);
            Const.form.subMainSplitContainerParts.AddToPanel2(Const.form.threadListTabControlParts);
            Const.form.mainSplitContainerParts.AddToPanel2(Const.form.subMainSplitContainerParts);

            Const.form.mainForm.AddControl(Const.form.mainSplitContainerParts);

            Const.form.mainSplitContainerParts.Show();
            Const.form.subMainSplitContainerParts.Show();

            Const.form.mainForm.Update();

            NOW_TYPE = TYPE1;
        }

        public void ChangeToType2()
        {
            //設定をオフ
            if (NOW_TYPE.Equals(TYPE1) == true)
                OffType1();
            else if (NOW_TYPE.Equals(TYPE3) == true)
                OffType3();
            else
                return;

            ReSizeType2();

            Const.form.subMainSplitContainerType2Parts.AddToPanel1(Const.form.boardIndexTabControlParts);
            Const.form.subMainSplitContainerType2Parts.AddToPanel2(Const.form.boardListTabControlParts);
            Const.form.mainSplitContainerType2Parts.AddToPanel2(Const.form.threadListTabControlParts);
            Const.form.mainSplitContainerType2Parts.AddToPanel1(Const.form.subMainSplitContainerType2Parts);

            Const.form.mainForm.AddControl(Const.form.mainSplitContainerType2Parts);

            Const.form.mainSplitContainerType2Parts.Show();
            Const.form.subMainSplitContainerType2Parts.Show();

            Const.form.mainForm.Update();

            NOW_TYPE = TYPE2;
        }
        public void ChangeToType3()
        {
            //設定をオフ
            if (NOW_TYPE.Equals(TYPE1) == true)
                OffType1();
            else if (NOW_TYPE.Equals(TYPE2) == true)
                OffType2();
            else
                return;

            ReSizeType3();

            Const.form.subMainSplitContainerType3Parts.AddToPanel1(Const.form.boardIndexTabControlParts);
            Const.form.subMainSplitContainerType3Parts.AddToPanel2(Const.form.boardListTabControlParts);
            Const.form.mainSplitContainerType3Parts.AddToPanel2(Const.form.threadListTabControlParts);
            Const.form.mainSplitContainerType3Parts.AddToPanel1(Const.form.subMainSplitContainerType3Parts);

            Const.form.mainForm.AddControl(Const.form.mainSplitContainerType3Parts);

            Const.form.mainSplitContainerType3Parts.Show();
            Const.form.subMainSplitContainerType3Parts.Show();

            Const.form.mainForm.Update();

            NOW_TYPE = TYPE3;
        }
        //TYPE1の設定をオフ
        public void OffType1()
        {
            try
            {
                Const.form.mainForm.ControlsRemove(Const.form.mainSplitContainerParts);
            }
            catch (System.Exception ex)
            {
                //Const.debugForm.OutPutDebug("Other", ex);
            }

            try
            {
                Const.form.mainSplitContainerParts.Panel2ControlsRemove(Const.form.subMainSplitContainerParts);
                Const.form.mainSplitContainerParts.Panel1ControlsRemove(Const.form.boardIndexTabControlParts);
                Const.form.subMainSplitContainerParts.Panel1ControlsRemove(Const.form.boardListTabControlParts);
                Const.form.subMainSplitContainerParts.Panel2ControlsRemove(Const.form.threadListTabControlParts);

                Const.form.mainSplitContainerParts.Hide();
                Const.form.subMainSplitContainerParts.Hide();
            }
            catch (System.Exception ex)
            {
                //Const.debugForm.OutPutDebug("Other", ex);
                return;
            }
        }

        //TYPE2の設定をオフ
        public void OffType2()
        {
            try
            {
                Const.form.mainForm.ControlsRemove(Const.form.mainSplitContainerType2Parts);
            }
            catch { ;}

            try
            {
                Const.form.mainSplitContainerType2Parts.Panel1ControlsRemove(Const.form.subMainSplitContainerType2Parts);
                Const.form.subMainSplitContainerType2Parts.Panel1ControlsRemove(Const.form.boardIndexTabControlParts);
                Const.form.subMainSplitContainerType2Parts.Panel2ControlsRemove(Const.form.boardListTabControlParts);
                Const.form.mainSplitContainerType2Parts.Panel2ControlsRemove(Const.form.threadListTabControlParts);

                Const.form.mainSplitContainerType2Parts.Hide();
                Const.form.subMainSplitContainerType2Parts.Hide();
            }
            catch (System.Exception ex)
            {
                //Const.debugForm.OutPutDebug("Other", ex);
            }
        }
        //TYPE3の設定をオフ
        public void OffType3()
        {
            try
            {
                Const.form.mainForm.ControlsRemove(Const.form.mainSplitContainerType3Parts);
            }
            catch { ;}

            try
            {
                Const.form.mainSplitContainerType3Parts.Panel1ControlsRemove(Const.form.subMainSplitContainerType3Parts);
                Const.form.subMainSplitContainerType3Parts.Panel1ControlsRemove(Const.form.boardIndexTabControlParts);
                Const.form.subMainSplitContainerType3Parts.Panel2ControlsRemove(Const.form.boardListTabControlParts);
                Const.form.mainSplitContainerType3Parts.Panel2ControlsRemove(Const.form.threadListTabControlParts);

                Const.form.mainSplitContainerType3Parts.Hide();
                Const.form.subMainSplitContainerType3Parts.Hide();
            }
            catch (System.Exception ex)
            {
                //Const.debugForm.OutPutDebug("Other", ex);
            }
        }
        public void ReSize()
        {
            //リサイズを振り分ける
            if (NOW_TYPE.Equals(TYPE1) == true)
                ReSizeType1();
            else if (NOW_TYPE.Equals(TYPE2) == true)
                ReSizeType2();
            else if (NOW_TYPE.Equals(TYPE3) == true)
                ReSizeType3();
        }
        public void ReSizeType1()
        {
            try
            {

                if (MainFormConst.formShowStyle.MAXSIZEINDEX.Equals("OFF") == true)
                {
                    Const.form.boardIndexTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerParts.SplitterDistance + 2,
                        Const.form.mainSplitContainerParts.Size.Height + 2);
                }
                else if (MainFormConst.formShowStyle.MAXSIZEINDEX.Equals("ON") == true)
                {
                    Const.form.boardIndexTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerParts.Size.Width + 3,
                            Const.form.mainSplitContainerParts.Size.Height + 3);
                }

                if (MainFormConst.formShowStyle.MAXSIZETHREAD.Equals("OFF") == true)
                {
                    Const.form.threadListTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerParts.Size.Width - Const.form.mainSplitContainerParts.SplitterDistance - 3,
                            Const.form.mainSplitContainerParts.Size.Height - Const.form.subMainSplitContainerParts.SplitterDistance - 3);
                }
                else if (MainFormConst.formShowStyle.MAXSIZETHREAD.Equals("ON") == true)
                {
                    Const.form.threadListTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerParts.Size.Width + 3,
                            Const.form.mainSplitContainerParts.Size.Height + 3);
                }
                if (MainFormConst.formShowStyle.MAXSIZEBOARD.Equals("OFF") == true)
                {
                    Const.form.boardListTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerParts.Size.Width - Const.form.mainSplitContainerParts.SplitterDistance - 3,
                            Const.form.subMainSplitContainerParts.SplitterDistance + 2);
                }
                else if (MainFormConst.formShowStyle.MAXSIZEBOARD.Equals("ON") == true)
                {
                    Const.form.boardListTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerParts.Size.Width + 3,
                            Const.form.mainSplitContainerParts.Size.Height + 3);
                }
                //タブコントロールのタブのサイズ変更を促す+マジックコード

                Const.form.threadListTabControlParts.ItemSize = new Size(Const.form.threadListTabControlParts.Size.Width / 4 - 2, 25);
                Const.form.boardListTabControlParts.ItemSize = new Size(Const.form.boardListTabControlParts.Size.Width / 4 - 2, 25);
                Const.form.boardIndexTabControlParts.ItemSize = new Size(Const.form.boardIndexTabControlParts.Size.Width / 4 - 2, 25);

                ResizeIndexBoard();

                /*MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].boardListControls.listViewParts.Size =
                    new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);

                MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.Size =
                    new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);*/

                foreach (BoardViewCommon boardView in MainFormConst.boardListTabMain.view_list)
                {
                    boardView.boardListControls.listViewParts.Size =
                        new Size(boardView.boardListControls.tabPageExParts.Size.Width,
                            boardView.boardListControls.tabPageExParts.Size.Height - 27);
                }
                MainFormConst.boardListTabMain.zenbunSearchView.boardListBrowserParts.Size =
                        new Size(MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Width,
                            MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Height - 27);

                foreach (ThreadViewCommon threadView in MainFormConst.threadListTabMain.viewList)
                {
                    threadView.threadViewControls.browserParts.Size =
                        new Size(threadView.threadViewControls.tabPageExParts.Size.Width,
                            threadView.threadViewControls.tabPageExParts.Size.Height - 27);
                }
                /*if (MainFormConst.threadListTabMain.viewList != null)
                {
                    //MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.SuspendLayout();
                    MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.Size =
                        new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);
                    //MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.ResumeLayout();
                }*/
            }
            catch { ;}
        }
        public void ReSizeType2()
        {
            try
            {
                if (MainFormConst.formShowStyle.MAXSIZEINDEX.Equals("OFF") == true)
                {
                    Const.form.boardIndexTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType2Parts.SplitterDistance + 4,
                             Const.form.subMainSplitContainerType2Parts.SplitterDistance + 2);
                }
                else if (MainFormConst.formShowStyle.MAXSIZEINDEX.Equals("ON") == true)
                {
                    Const.form.boardIndexTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType2Parts.Size.Width + 3,
                             Const.form.mainSplitContainerType2Parts.Size.Height + 3);
                }

                if (MainFormConst.formShowStyle.MAXSIZETHREAD.Equals("OFF") == true)
                {
                    Const.form.threadListTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType2Parts.Size.Width - Const.form.mainSplitContainerType2Parts.SplitterDistance - 2,
                             Const.form.mainSplitContainerType2Parts.Size.Height + 2);
                }
                else
                {
                    Const.form.threadListTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType2Parts.Size.Width + 3,
                             Const.form.mainSplitContainerType2Parts.Size.Height + 3);
                }
                if (MainFormConst.formShowStyle.MAXSIZEBOARD.Equals("OFF") == true)
                {
                    Const.form.boardListTabControlParts.Size =
                        new Size(Const.form.mainSplitContainerType2Parts.SplitterDistance + 4,
                        Const.form.mainSplitContainerType2Parts.Size.Height - Const.form.subMainSplitContainerType2Parts.SplitterDistance - 3);

                }
                else if (MainFormConst.formShowStyle.MAXSIZEBOARD.Equals("ON") == true)
                {
                    Const.form.boardListTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType2Parts.Size.Width + 3,
                             Const.form.mainSplitContainerType2Parts.Size.Height + 3);
                }


                //タブコントロールのタブのサイズ変更を促す+マジックコード
                Const.form.threadListTabControlParts.ItemSize = new Size(Const.form.threadListTabControlParts.Size.Width / 4 - 2, 25);
                Const.form.boardListTabControlParts.ItemSize = new Size(Const.form.boardListTabControlParts.Size.Width / 4 - 2, 25);
                Const.form.boardIndexTabControlParts.ItemSize = new Size(Const.form.boardIndexTabControlParts.Size.Width / 4 - 2, 25);

                ResizeIndexBoard();


                /*MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].boardListControls.listViewParts.Size =
                    new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);

                MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.Size =
                    new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);*/


                foreach (BoardViewCommon boardView in MainFormConst.boardListTabMain.view_list)
                {
                    boardView.boardListControls.listViewParts.Size =
                        new Size(boardView.boardListControls.tabPageExParts.Size.Width,
                            boardView.boardListControls.tabPageExParts.Size.Height - 27);
                    //new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);
                }
                MainFormConst.boardListTabMain.zenbunSearchView.boardListBrowserParts.Size =
                    new Size(MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Width,
                        MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Height - 27);

                foreach (ThreadViewCommon threadView in MainFormConst.threadListTabMain.viewList)
                {
                    threadView.threadViewControls.browserParts.Size =
                        new Size(threadView.threadViewControls.tabPageExParts.Size.Width,
                            threadView.threadViewControls.tabPageExParts.Size.Height - 27);
                }
            }
            catch { ;}
        }

        public void ReSizeType3()
        {
            try
            {
                if (MainFormConst.formShowStyle.MAXSIZEINDEX.Equals("OFF") == true)
                {
                    Const.form.boardIndexTabControlParts.Size =
                         new Size(Const.form.subMainSplitContainerType3Parts.SplitterDistance + 2,
                             Const.form.mainSplitContainerType3Parts.Panel2_Height + 1);
                }
                else if (MainFormConst.formShowStyle.MAXSIZEINDEX.Equals("ON") == true)
                {
                    Const.form.boardIndexTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType3Parts.Size.Width + 3,
                             Const.form.mainSplitContainerType3Parts.Size.Height + 3);
                }

                if (MainFormConst.formShowStyle.MAXSIZETHREAD.Equals("OFF") == true)
                {
                    Const.form.threadListTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType3Parts.Size.Width - Const.form.mainSplitContainerType3Parts.SplitterDistance - 2,
                             Const.form.mainSplitContainerType3Parts.Size.Height + 2);
                }
                else
                {
                    Const.form.threadListTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType3Parts.Size.Width + 3,
                             Const.form.mainSplitContainerType3Parts.Size.Height + 3);
                }
                if (MainFormConst.formShowStyle.MAXSIZEBOARD.Equals("OFF") == true)
                {
                    Const.form.boardListTabControlParts.Size =
                      new Size(Const.form.subMainSplitContainerType3Parts.Size.Width - Const.form.subMainSplitContainerType3Parts.SplitterDistance,
                          Const.form.mainSplitContainerType3Parts.Panel2_Height + 1);
                }
                else if (MainFormConst.formShowStyle.MAXSIZEBOARD.Equals("ON") == true)
                {
                    Const.form.boardListTabControlParts.Size =
                         new Size(Const.form.mainSplitContainerType3Parts.Size.Width + 3,
                             Const.form.mainSplitContainerType3Parts.Size.Height + 3);
                }

                //タブコントロールのタブのサイズ変更を促す+マジックコード
                Const.form.threadListTabControlParts.ItemSize = new Size(Const.form.threadListTabControlParts.Size.Width / 4 - 2, 25);
                Const.form.boardListTabControlParts.ItemSize = new Size(Const.form.boardListTabControlParts.Size.Width / 4 - 2, 25);
                Const.form.boardIndexTabControlParts.ItemSize = new Size(Const.form.boardIndexTabControlParts.Size.Width / 4 - 2, 25);

                ResizeIndexBoard();


                foreach (BoardViewCommon boardView in MainFormConst.boardListTabMain.view_list)
                {
                    boardView.boardListControls.listViewParts.Size =
                        new Size(boardView.boardListControls.tabPageExParts.Size.Width,
                            boardView.boardListControls.tabPageExParts.Size.Height - 27);
                }

                MainFormConst.boardListTabMain.zenbunSearchView.boardListBrowserParts.Size =
                    new Size(MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Width,
                        MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Height - 27);

                foreach (ThreadViewCommon threadView in MainFormConst.threadListTabMain.viewList)
                {
                    threadView.threadViewControls.browserParts.Size =
                        new Size(threadView.threadViewControls.tabPageExParts.Size.Width,
                            threadView.threadViewControls.tabPageExParts.Size.Height - 27);

                    //new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);
                }
            }
            catch { ;}
        }
        public void ResizeIndexBoard()
        {
            if ((MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                    MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            /*if ((MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }*/

            if ((MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28))
            {
                MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }

            if ((MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.Size.Width !=
                MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Size.Width) ||
                (MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.Size.Height !=
                MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 30))
            {
                MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.Size =
                    new Size(MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Size.Width,
                        MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Size.Height - 28);
            }
        }
    }
}