﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

using nispi.Analysis;
using nispi.WriteToThread;
using nispi.Menu;
using nispi.Controls.Main.ThreadList.AutoReload;

namespace nispi.controlclass
{
    class ThreadListControlsEvent : ThreadListControlsMethod
    {
        /*public ThreadViewCommon threadView;
        public ThreadListControls threadListControls;
        public AnalysisImage analysisImage;
        public AnalysisLink analysisLink;
        public AnalysisMecab analysisMecab;*/

        public ThreadListControlsEvent(ThreadViewCommon threadView, ThreadListControls threadListControls)
        {
            this.threadView = threadView;
            this.threadListControls = threadListControls;

            this.threadListControls.browserParts.control.PreviewKeyDown += new PreviewKeyDownEventHandler(control_PreviewKeyDownEvent);

            this.threadListControls.postButtonParts.Click += new EventHandler(postDialogButton_Click);
            this.threadListControls.reloadButtonParts.Click += new EventHandler(reload_button_Click);
            this.threadListControls.favoriteButtonParts.Click += new EventHandler(favorite_button_Click);

            this.threadListControls.searchButtonParts.Click += new EventHandler(search_button_Click);
            this.threadListControls.searchTextBoxParts.KeyPress += new KeyPressEventHandler(search_textBox_KeyPress);
            this.threadListControls.extractionButtonParts.Click += new EventHandler(extraction_button_Click);

            this.threadListControls.analysisImageButtonParts.Click += new EventHandler(analysisImageButton_Click);
            this.threadListControls.analysisLinkButtonParts.Click += new EventHandler(analysisLinkButton_Click);
            this.threadListControls.analysisMecabParts.Click += new EventHandler(analysisMecabButton_Click);
            this.threadListControls.analysisMagicButtonParts.Click += new EventHandler(analysisMagicButtonParts_Click);

            this.threadListControls.pinPointDateButtonParts.Click += new EventHandler(pinPointDateButton_Click);
            this.threadListControls.timeOffButtonParts.Click += new EventHandler(timeOffButton_Click);
            this.threadListControls.withInCBoxParts.SelectedIndexChanged += new EventHandler(withInCBox_SelectedIndexChanged);

            this.threadListControls.autoReloadButtonParts.Click += new EventHandler(autoReloadButton_Click);

            this.threadListControls.closeTabButtonParts.Click += new EventHandler(closeTabButton_Click);
        }
        public void RemoveEvent()
        {
            this.threadListControls.browserParts.control.PreviewKeyDown -= new PreviewKeyDownEventHandler(control_PreviewKeyDownEvent);

            this.threadListControls.postButtonParts.Click -= new EventHandler(postDialogButton_Click);
            this.threadListControls.reloadButtonParts.Click -= new EventHandler(reload_button_Click);
            this.threadListControls.favoriteButtonParts.Click -= new EventHandler(favorite_button_Click);

            this.threadListControls.searchButtonParts.Click -= new EventHandler(search_button_Click);
            this.threadListControls.searchTextBoxParts.KeyPress -= new KeyPressEventHandler(search_textBox_KeyPress);
            this.threadListControls.extractionButtonParts.Click -= new EventHandler(extraction_button_Click);

            this.threadListControls.analysisImageButtonParts.Click -= new EventHandler(analysisImageButton_Click);
            this.threadListControls.analysisLinkButtonParts.Click -= new EventHandler(analysisLinkButton_Click);
            this.threadListControls.analysisMecabParts.Click -= new EventHandler(analysisMecabButton_Click);
            this.threadListControls.analysisMagicButtonParts.Click -= new EventHandler(analysisMagicButtonParts_Click);

            this.threadListControls.pinPointDateButtonParts.Click -= new EventHandler(pinPointDateButton_Click);
            this.threadListControls.timeOffButtonParts.Click -= new EventHandler(timeOffButton_Click);
            this.threadListControls.withInCBoxParts.SelectedIndexChanged -= new EventHandler(withInCBox_SelectedIndexChanged);

            this.threadListControls.autoReloadButtonParts.Click -= new EventHandler(autoReloadButton_Click);

            this.threadListControls.closeTabButtonParts.Click -= new EventHandler(closeTabButton_Click);

            threadView = null;
            threadListControls = null;
        }
    }

    class ThreadListControlsMethod
    {
        public ThreadViewCommon threadView;
        public ThreadListControls threadListControls;
        public AnalysisImage2 analysisImage2;
        public AnalysisLink analysisLink;
        public AnalysisMecab analysisMecab;
        public AnalysisMagic analysisMagic;
        public int index;
        public bool autoReload = false;

        public ThreadListControlsMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                index = Const.form.threadListTabControlParts.SelectedIndex;
                threadView = MainFormConst.threadListTabMain.viewList[index];

                if (threadView.datUrl.Length > 0)
                    return true;
                else
                    return false;
            }
            catch
            {
                return false;
            }
        }
        public void control_PreviewKeyDownEvent(object sender, PreviewKeyDownEventArgs e)
        {
            if ((e.Control == true) && (e.KeyCode == Keys.W))
            {
                int selectIndex = Const.form.threadListTabControlParts.SelectedIndex;
                MainFormConst.threadListTabMain.viewList[selectIndex].dispoose();
                //e.IsInputKey = true;
            }
            else if ((e.Control == true) && (e.KeyCode == Keys.R))
            {
                int selectIndex = Const.form.threadListTabControlParts.SelectedIndex;
                Thread t = new Thread(new ThreadStart(MainFormConst.threadListTabMain.viewList[selectIndex].ReloadThread));
                t.IsBackground = true;
                t.Start();
                //e.IsInputKey = true;
            }
            else if ((e.Control == true) && (e.KeyCode == Keys.Q))
            {
                int selectIndex = Const.form.threadListTabControlParts.SelectedIndex;

                if (selectIndex == 0)
                {
                    return;
                }
                ContextMenuControls.threadListTabMenu.threadListTabEvent.menuItemCloseAllTab_Click(new object(), new EventArgs());
                //e.IsInputKey = true;
            }
            else if ((e.Control == true) && (e.KeyCode == Keys.F))
            {
                int selectIndex = Const.form.threadListTabControlParts.SelectedIndex;

                if (selectIndex == 0)
                {
                    return;
                }
                ContextMenuControls.threadListTabMenu.threadListTabEvent.menuItemAddFavorite_Click(new object(), new EventArgs());
                //e.IsInputKey = true;
            }
            else if (e.KeyCode == Keys.F6)
            {
                //e.e.Handled = true;
                Const.form.mainForm.Hide();
                Const.form.OffMaxSizeBoard();
                Const.form.OffMaxSizeIndex();
                Const.form.MaxSizeThread();
                Const.form.mainForm.Show();
            }
            else if (e.KeyCode == Keys.F5)
            {
                Const.form.mainForm.Hide();
                Const.form.OffMaxSizeThread();
                Const.form.OffMaxSizeIndex();
                Const.form.MaxSizeBoard();
                Const.form.mainForm.Show();

            }
            else if (e.KeyCode == Keys.F4)
            {
                Const.form.mainForm.Hide();
                Const.form.OffMaxSizeThread();
                Const.form.OffMaxSizeBoard();
                Const.form.MaxSizeIndex();
                Const.form.mainForm.Show();
            }
            else if (e.KeyCode == Keys.F3)
            {
                Const.form.ChangeToType3(new object(), new EventArgs());
            }
            else if (e.KeyCode == Keys.F2)
            {
                Const.form.ChangeToType2(new object(), new EventArgs());
            }
            else if (e.KeyCode == Keys.F1)
            {
                Const.form.ChangeToType1(new object(), new EventArgs());
            }
            e.IsInputKey = true;
        }

        public void search_textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                e.Handled = true;
                //ブラウザ内検索
                string str = threadListControls.searchTextBoxParts.Text;
                HtmlUtil.SearchInBrowser(threadListControls.browserParts, str);
            }
        }

        public void search_button_Click(object sender, EventArgs e)
        {
            string str = threadListControls.searchTextBoxParts.Text;
            HtmlUtil.SearchInBrowser(threadListControls.browserParts, str);
        }

        public void extraction_button_Click(object sender, EventArgs e)
        {
            try
            {
                string str = threadListControls.searchTextBoxParts.Text;
                if (str.Length > 0)
                    MainFormConst.PopUpWindow(Cursor.Position, threadView, threadView.datUrl, str, "WORD");
            }
            catch { ;}
        }
        public void reload_button_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(new ThreadStart(threadView.ReloadThread));
            t.IsBackground = true;
            t.Start();

            return;
        }

        public void analysisImageButton_Click(object sender, EventArgs e)
        {
            DatInfo datz;
            if (AnalysisImage2.Visible == false)
            {
                try
                {
                    AnalysisImage2.Visible = true;
                    datz = new DatInfo(threadView.datUrl);
                    datz.LoadFromFile();
                    analysisImage2 = new AnalysisImage2();
                    analysisImage2.Open(datz);
                }
                catch
                { ;}
            }
            else
            {
                //analysisImage2.Cloose();
            }
        }

        public void analysisLinkButton_Click(object sender, EventArgs e)
        {
            DatInfo datz;
            if (AnalysisLink.Visible == false)
            {
                try
                {
                    datz = new DatInfo(threadView.datUrl);
                    datz.LoadFromFile();
                    analysisLink = new AnalysisLink();
                    analysisLink.Open(datz);
                }
                catch
                { ;}
            }
            else
            {
                analysisLink.Cloose();
            }
        }

        public void analysisMecabButton_Click(object sender, EventArgs e)
        {
            DatInfo datz;
            if (AnalysisMecab.Visible == false)
            {
                try
                {
                    datz = new DatInfo(threadView.datUrl);
                    datz.LoadFromFile();
                    analysisMecab = new AnalysisMecab();
                    analysisMecab.Open(datz);
                }
                catch
                { ;}
            }
            else
            {
                analysisMecab.Cloose();
            }
        }

        public void analysisMagicButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                if (threadView.datUrl != null)
                {
                    if (this.threadListControls.analysisMagic.analysisMagicControls.amFormParts.Visible == false)
                        this.threadListControls.analysisMagic.Show();
                    else
                        this.threadListControls.analysisMagic.Hide();
                }
            }
            catch { ;}
        }
        public void favorite_button_Click(object sender, EventArgs e)
        {
            string url = threadView.datUrl;
            string title = threadView.threadName;
            string resNum = threadView.resNum;

            MainFormConst.boardListTabMain.favoriteBoardView.Register(url, title, resNum);

            //再読み込み
            Thread t = new Thread(new ThreadStart(MainFormConst.boardListTabMain.favoriteBoardView.worker));
            t.IsBackground = true;
            t.Start();
        }

        public void pinPointDateButton_Click(object sender, EventArgs e)
        {
            try
            {
                this.threadListControls.withInCBoxParts.SelectedIndexChanged -= new EventHandler(withInCBox_SelectedIndexChanged);
                this.threadListControls.withInCBoxParts.SelectedIndex = 0;
                this.threadListControls.withInCBoxParts.SelectedIndexChanged += new EventHandler(withInCBox_SelectedIndexChanged);

                CalendarInThreadView calendarInThreadView = new CalendarInThreadView(threadView, Cursor.Position);
            }
            catch { ;}
        }

        public void postDialogButton_Click(object sender, EventArgs e)
        {
            try
            {
                WriteMain writeMainForm = new WriteMain(threadView.datUrl, threadView.threadName);
            }
            catch { ;}
        }

        public void timeOffButton_Click(object sender, EventArgs e)
        {
            Const.form.mainForm.SetWaitCursor();

            this.threadListControls.withInCBoxParts.SelectedIndexChanged -= new EventHandler(withInCBox_SelectedIndexChanged);
            this.threadListControls.withInCBoxParts.SelectedIndex = 0;
            this.threadListControls.withInCBoxParts.SelectedIndexChanged += new EventHandler(withInCBox_SelectedIndexChanged);

            threadView.ReSetExtractionData();

            //this.threadListControls.pinPointDateButtonParts.control.Text = "日時指定";
            threadView.ReShowThread();

            Const.form.mainForm.ReSetWaitCursor();
        }

        public void withInCBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            Const.form.mainForm.SetWaitCursor();

            //this.threadListControls.pinPointDateButtonParts.Text = "日時指定";
            threadView.SetExtractionData(this.threadListControls.withInCBoxParts.SelectedIndex, "", "");
            threadView.ReShowThread();

            Const.form.mainForm.ReSetWaitCursor();
        }

        public void autoReloadButton_Click(object sender, EventArgs e)
        {
            if (true == CheckConsistency())
            {
                Button b = (Button)sender;

                if (autoReload == false)
                {
                    autoReload = true;
                    b.Image = Resources.autoreload_ture;
                    AutoReloadDataManager.Add(threadView.datUrl);
                }
                else
                {
                    autoReload = false;
                    b.Image = Resources.autoreload_false;
                    AutoReloadDataManager.Remove(threadView.datUrl);
                }
            }
        }
        public void autoReloadOff(string datUrl)
        {
            autoReload = false;
            //b.Image = Resources.autoreload_false;
            AutoReloadDataManager.Remove(datUrl);
        }

        public void closeTabButton_Click(object sender, EventArgs e)
        {
            this.threadView.dispoose();
        }
    }
}