﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;
using System.Drawing;

using nispi.controlclass;
namespace nispi
{
    class RelationThreadMenu
    {
        public ContextMenuStripParts contextMenuStripParts;
        ToolStripMenuItemParts[] tsip;
        int num = 0;

        public BoardIndexTreeViewMenuEvent boardIndexTreeViewMenuEvent;

        public RelationThreadMenu(int num, List<ThreadData> td, Point point)
        {
            if (num < 2)
                return;
            this.num = num;

            contextMenuStripParts = ContextMenuStripPartsManager.Pop();
            contextMenuStripParts.control.Closed += new ToolStripDropDownClosedEventHandler(contextMenuStripParts_Closed);
            tsip = new ToolStripMenuItemParts[num];

            for (int x = 0; x < num; x += 1)
            {
                tsip[x] = ToolStripMenuItemPartsManager.Pop();
                tsip[x].Text = td[x].title;
                tsip[x].Name = td[x].datUrl;
                tsip[x].control.MouseDown += new MouseEventHandler(RelationThreadItem_Click);
                contextMenuStripParts.ItemsAdd(tsip[x]);
            }
            contextMenuStripParts.Show(Const.form.mainForm, Const.form.mainForm.control.PointToClient(point));
        }
        public void contextMenuStripParts_Closed(object sender, ToolStripDropDownClosedEventArgs e)
        {
            contextMenuStripParts.control.Items.Clear();
            contextMenuStripParts.control.Closed -= new ToolStripDropDownClosedEventHandler(contextMenuStripParts_Closed);

            for (int x = 0; x < this.num; x += 1)
            {
                tsip[x].Text = "";
                tsip[x].Name = "";
                tsip[x].control.MouseDown -= new MouseEventHandler(RelationThreadItem_Click);
                ToolStripMenuItemPartsManager.Push(tsip[x]);
            }

            ContextMenuStripPartsManager.Push(contextMenuStripParts);
        }
        public void RelationThreadItem_Click(object sender, MouseEventArgs e)
        {
            ToolStripMenuItem tsm = (ToolStripMenuItem)sender;

            MainFormConst.ShowThread(tsm.Name,tsm.Name);
            

        }
    }
}