﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;


using nispi.Menu;

//タブのコンテキストメニューはマウス押下で開くので独自のShowメソッドは必要ない。
namespace nispi.controlclass
{
    class BoardIndexTabEvent:BoardIndexTabMethod
    {
        //コンテキストメニュー
        public BoardIndexTabEvent(BoardIndexTabMenu boardIndexTabMenu)
        {
            this.boardIndexTabMenu = boardIndexTabMenu;

            this.boardIndexTabMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            this.boardIndexTabMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            this.boardIndexTabMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            this.boardIndexTabMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            this.boardIndexTabMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            this.boardIndexTabMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            this.boardIndexTabMenu.menuItemReloadParts.Image = Resources.reload;
            this.boardIndexTabMenu.menuItemReloadParts.ImageTransparentColor = Color.White;

            Const.form.boardIndexTabControlParts.MouseUp += new MouseEventHandler(boardIndex_tabControl_MouseUp);
            Const.form.boardIndexTabControlParts.MouseDown += new MouseEventHandler(boardIndex_tabControl_MouseDown);
        }
        //メインメニュー
        public BoardIndexTabEvent(BoardIndexTabMainMenu boardIndexTabMainMenu)
        {
            this.boardIndexTabMainMenu = boardIndexTabMainMenu;

            this.boardIndexTabMainMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            this.boardIndexTabMainMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            this.boardIndexTabMainMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            this.boardIndexTabMainMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            this.boardIndexTabMainMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            this.boardIndexTabMainMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            this.boardIndexTabMainMenu.menuItemReloadParts.Image = Resources.reload;
            this.boardIndexTabMainMenu.menuItemReloadParts.ImageTransparentColor = Color.White;
        }
    }
    class BoardIndexTabMethod
    {
        public BoardIndexTabMenu boardIndexTabMenu;
        public BoardIndexTabMainMenu boardIndexTabMainMenu;


        public BoardIndexTabMethod()
        {
        }
        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            string url;
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                url = Const.BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
            {
                url = Const.SC_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
            {
                url = Const.OPEN2CH_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
            {
                url = Const.NEXT2CH_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
            {
                url = Const.JIKKYO_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            /*else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                url = Const.BLOGBAN_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }*/
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                url = Const.SHIZU_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }

            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
            {
                url = Const.VIP2CH_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
            {
                url = Const.MACHIBBS_BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }

            else
            {
                //title = ViewMediator.boardIndexTabWidget.favoriteBoardIndexView.tabPage.Text;
            }
        }

        public void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            string url;
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                url = Const.BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
            {
                url = Const.SC_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
            {
                url = Const.OPEN2CH_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
            {
                url = Const.NEXT2CH_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
            {
                url = Const.JIKKYO_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            /*else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                url = Const.BLOGBAN_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }*/
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                url = Const.SHIZU_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }

            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
            {
                url = Const.VIP2CH_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
            {
                url = Const.MACHIBBS_BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }

            else
            {
                //title = ViewMediator.boardIndexTabWidget.favoriteBoardIndexView.tabPage.Text;
            }
        }

        //マップのIndexタブでも利用されている
        public void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            string title;
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            /*else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }*/
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }

            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
            {
                //板のインデックスにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }

            else
            {
                //板のお気に入りにアクセス。一つしかない。
                title = MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            Clipboard.SetDataObject(title, true);
        }

        //+++++//
        public void menuItemReload_Click(object sender, EventArgs e)
        {
            //お気に入りか、２ｃｈのインデックスか
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.boardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.scBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.open2chBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.next2chBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            /*else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.blogbanBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }*/
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.shizuBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }

            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.vip2chBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.machibbsBoardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }

            else// if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.favoriteBoardIndexView.LoadFavoriteBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
        }

        /*public void menuItemAddSearch_Click(object sender, EventArgs e)
        {
            ;
        }*/

        public void boardIndex_tabControl_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                this.boardIndexTabMenu.contextMenuStripParts.Show(Const.form.boardIndexTabControlParts, e.Location);
            }
        }

        public void boardIndex_tabControl_MouseDown(object sender, MouseEventArgs e)
        {
            int selectNum = 0;

            if (e.Button == MouseButtons.Right)
            {
                for (int i = 0; i < Const.form.boardIndexTabControlParts.Count; i++)
                {
                    if (Const.form.boardIndexTabControlParts.GetTabRect(i).Contains(e.X, e.Y))
                    {
                        Const.form.boardIndexTabControlParts.SelectedIndex = i;
                        selectNum = i;
                        break;
                    }
                }
            }
            else
            {
                return;
            }

            if (selectNum == 0)
            {
                this.boardIndexTabMenu.menuItemOpenBrowserParts.Enabled = true;
                this.boardIndexTabMenu.menuItemCopyURLParts.Enabled = true;
                this.boardIndexTabMenu.menuItemCopyTitleParts.Enabled = true;
                this.boardIndexTabMenu.menuItemReloadParts.Enabled = true;

            }
            else if (selectNum == 1)
            {
                this.boardIndexTabMenu.menuItemOpenBrowserParts.Enabled = false;
                this.boardIndexTabMenu.menuItemCopyURLParts.Enabled = false;
                this.boardIndexTabMenu.menuItemCopyTitleParts.Enabled = true;
                this.boardIndexTabMenu.menuItemReloadParts.Enabled = true;
            }
        }
    }
}
