﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using nispi.controlclass;

namespace nispi
{
    class AllAnalysisMainMenu : ThreadListControlsMethod
    {
        //メインメニュー
        public ToolStripMenuItemParts menuItemWordOpenParts;
        public ToolStripMenuItemParts menuItemWordCloseParts;

        public ToolStripMenuItemParts menuItemImageOpenParts;
        public ToolStripMenuItemParts menuItemImageCloseParts;
        public ToolStripMenuItemParts menuItemLinkOpenParts;
        public ToolStripMenuItemParts menuItemLinkCloseParts;

        public AllAnalysisMainMenu(ToolStripMenuItemParts menuItemParts)
        {
            menuItemWordOpenParts = ToolStripMenuItemPartsManager.Pop();
            menuItemWordCloseParts = ToolStripMenuItemPartsManager.Pop();

            menuItemImageOpenParts = ToolStripMenuItemPartsManager.Pop();
            menuItemImageCloseParts = ToolStripMenuItemPartsManager.Pop();

            menuItemLinkOpenParts = ToolStripMenuItemPartsManager.Pop();
            menuItemLinkCloseParts = ToolStripMenuItemPartsManager.Pop();


            menuItemWordOpenParts.Text = "単語抽出をする(&T)";
            menuItemWordOpenParts.Image = Resources.word;
            menuItemWordOpenParts.Click += new EventHandler(analysisMecabButton_Click);
            menuItemWordCloseParts.Text = "単語抽出を閉じる(&W)";
            menuItemWordCloseParts.Click += new EventHandler(analysisMecabButton_Click);

            menuItemImageOpenParts.Text = "画像抽出をする(&G)";
            menuItemImageOpenParts.Image = Resources.analysisimage;
            menuItemImageOpenParts.Click += new EventHandler(analysisImageButton_Click);
            menuItemImageCloseParts.Text = "画像抽出を閉じる";
            menuItemImageCloseParts.Click += new EventHandler(analysisImageButton_Click);

            menuItemLinkOpenParts.Text = "リンク抽出をする(&L)";
            menuItemLinkOpenParts.Image = Resources.analysislink;
            menuItemLinkOpenParts.Click += new EventHandler(analysisLinkButton_Click);
            menuItemLinkCloseParts.Text = "リンク抽出を閉じる";
            menuItemLinkCloseParts.Click += new EventHandler(analysisLinkButton_Click);

            menuItemParts.DropDownItemsAdd(menuItemWordOpenParts);
            //menuItemParts.DropDownItemsAdd(menuItemWordCloseParts);
            
            menuItemParts.DropDownItemsAdd("-");
            menuItemParts.DropDownItemsAdd(menuItemImageOpenParts);
            //menuItemParts.DropDownItemsAdd(menuItemImageCloseParts);

            menuItemParts.DropDownItemsAdd("-");
            menuItemParts.DropDownItemsAdd(menuItemLinkOpenParts);
            //menuItemParts.DropDownItemsAdd(menuItemLinkCloseParts);
        }

        public void SetMainMenu()
        {
            if (false == CheckConsistency())
            {
                menuItemWordOpenParts.Enabled = false;
                menuItemWordCloseParts.Enabled = false;
                menuItemImageOpenParts.Enabled = false;
                menuItemImageCloseParts.Enabled = false;
                menuItemLinkOpenParts.Enabled = false;
                menuItemLinkCloseParts.Enabled = false;
                return;
            }
            else
            {
                menuItemWordOpenParts.Enabled = true;
                menuItemWordCloseParts.Enabled = true;
                menuItemImageOpenParts.Enabled = true;
                menuItemImageCloseParts.Enabled = true;
                menuItemLinkOpenParts.Enabled = true;
                menuItemLinkCloseParts.Enabled = true;
                return;
            }
        }
    }
}
