﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace nispi.WriteToBoard
{
    //書き込みに際して必要なデータ

    [Serializable]
    class WriteData
    {
        public string titleName = "";
        public string writeAddress = "";
        public string boardID = "";
        public string boardName = "";
        
        //作成するスレッドの名前
        public string threadName = "";
        
        public string serverTime = "";
        public string postData = "";
        public string buttonText = "新規スレッド作成";

        public string boardUrl = "";
        public string htmlData = "";

        public string nameText = "";
        public string mailText = "";
        public string contentsText = "";

        public WriteData(string boardUrl, string titleName)
        {
            this.boardUrl = boardUrl;

            this.boardID = Util.BoardUrlToBoardID(this.boardUrl);
            this.boardName = BoardDataBase.GetName(this.boardUrl);

            if (Util.BoardType(this.boardUrl) == Util.TYPE_JBBS)
                this.writeAddress = Util.DatUrlToJbbsBoardWriteUrl(boardUrl);
            else
                this.writeAddress = Util.DatUrlToWriteUrl(boardUrl);

            this.titleName = titleName;
        }

        //クローン作製で参考に使用したサイト：http://smdn.jp/programming/netfx/cloning/
        public T CloneObject<T>(T source)
        {
            // バイナリシリアライズによってsourceの複製を作成する
            using (MemoryStream stream = new MemoryStream())
            {
                BinaryFormatter f = new BinaryFormatter();

                f.Serialize(stream, source);

                stream.Position = 0L;

                return (T)f.Deserialize(stream);
            }
        }
    }
}
