﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

using Dotnetrix.Controls;

namespace nispi.controlclass
{
    class TabPageEx:TabPage
    {

    }
    class TabPageExParts:ControlBase
    {
        public TabPageEX control;
 
        public TabPageExParts()
        {
            control = new TabPageEX();// (" ");
            //control.UseVisualStyleBackColor = false;
            control.Name = "";
            control.Text = "";
            control.BackColor = SystemColors.Control;
            control.BorderStyle = BorderStyle.FixedSingle;
            //control.UseVisualStyleBackColor = true;
            control.MouseMove += new MouseEventHandler(tabPageMouseMove);
            control.Font = this.control.Font = new Font("ＭＳ Ｐゴシック", 12.0F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            this.controlBase = (System.Windows.Forms.Control)control;
            
        }

        public BorderStyle BorderStyle
        {
            set
            {
                this.control.BorderStyle = value;
            }
        }

        public string ToolTipText
        {
            set
            {
                this.control.ToolTipText = value;
            }
            get
            {
                return this.control.ToolTipText;
            }
        }

        public int ImageIndex
        {
            set
            {
                this.control.ImageIndex = value;
            }
            get
            {
                return this.control.ImageIndex;
            }
        }


        //マウスが動いた時に、フォーカスが無いのならば与える（スクロールバークリック時に対応）
        public void tabPageMouseMove(object sender, MouseEventArgs e)
        {
            TabPageEX tabPage = (TabPageEX)sender;
            if (tabPage.ContainsFocus == false)
            {
                //ポップアップウィンドウがある場合は無条件で消す
                if (MainFormConst.htmlPopUpWindowWidget.popUpList.Count > 0)
                {
                    MainFormConst.htmlPopUpWindowWidget.RemoveAllPopUp();
                    tabPage.Focus();
                }
                //ほにゃ//元Focus()
                if (Const.form.mainForm.ContainsFocus == true)
                {
                    tabPage.Select();
                }
            }
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class TabPageExPartsManager
    {
        public static LinkedList<TabPageExParts> allFormList = new LinkedList<TabPageExParts>();
        public static Stack<TabPageExParts> tabPageStack = new Stack<TabPageExParts>();
        public static Mutex mutex = new Mutex(false, "TabPageExPartsManager");

        public static TabPageExParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new TabPageExParts());

            TabPageExParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
            {
                ChangeOutWard(tabPage);
                allFormList.AddLast(tabPage);
            }

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(TabPageExParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (TabPageExParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(TabPageExParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardTab.TabForeColorRed,
                Const.opt.outWardTab.TabForeColorGreen,
                Const.opt.outWardTab.TabForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardTab.TabBackColorRed,
                Const.opt.outWardTab.TabBackColorGreen,
                Const.opt.outWardTab.TabBackColorBlue);

            float scaledFloat = Scale.GetScaledFloat();

            parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}
