﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace nispi.OptionControl
{
    class AbonOptionEvent
    {
        AbonOption abonOption;
        
        public AbonOptionEvent(AbonOption abonOption)
        {
            this.abonOption = abonOption;
            abonOption.abonSubmitButtonParts.Click += new EventHandler(abonSubmitButtonParts_Click);
            abonOption.abonRemoveButtonParts.Click += new EventHandler(abonRemoveButtonParts_Click);
            abonOption.abonListViewParts.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(abonListViewParts_DoubleClick);
        }

        public void EventRemove()
        {
            abonOption.abonSubmitButtonParts.Click -= new EventHandler(abonSubmitButtonParts_Click);
            abonOption.abonRemoveButtonParts.Click -= new EventHandler(abonRemoveButtonParts_Click);
            abonOption.abonListViewParts.MouseDoubleClick -= new System.Windows.Forms.MouseEventHandler(abonListViewParts_DoubleClick);
            this.abonOption = null;
        }

        public void abonSubmitButtonParts_Click(object sender, EventArgs e)
        {
            //テキストを得る
            string text = abonOption.abonTBoxParts.Text;
            if (text.Length == 0)
                return;
            //正規表現のフラグを得る
            string regFlag = abonOption.abonCheckBoxParts.Checked.ToString();

            //テキストを削除
            abonOption.abonTBoxParts.Text = "";

            //種類を得る
            int typeNum = abonOption.abonCBoxParts.SelectedIndex;
            abonOption.abonCBoxParts.SelectedIndex = 0;

            abonOption.Add(text, regFlag, GetTypeFromNum(typeNum), "False");

            abonOption.AddListView(new AbonData(text, regFlag, GetTypeFromNum(typeNum), "False"));

            abonOption.SaveToFile();
        }

        private string GetTypeFromNum(int num)
        {
            switch (num)
            {
                case 0:
                    return "名前";
                case 1:
                    return "ＩＤ";
                case 2:
                    return "コメント";
                default:
                    return null;
            }

        }
        public void abonRemoveButtonParts_Click(object sender, EventArgs e)
        {
            int num = 0;
            try
            {
                num = abonOption.abonListViewParts.GetSelectedItemNum();
                if (num < 0)
                    return;
            }
            catch
            {
                return;
            }

            abonOption.Remove(num);

            abonOption.ItemsRemoveAt(num);

            abonOption.SaveToFile();
        }
        public void abonListViewParts_DoubleClick(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            int num = 0;
            try
            {
                num = abonOption.abonListViewParts.GetSelectedItemNum();
                if (num < 0)
                    return;
            }
            catch
            {
                return;
            }
            if (abonOption.abonDataList[num].flag == "True")
                abonOption.abonDataList[num].flag = "False";
            else
                abonOption.abonDataList[num].flag = "True";

            abonOption.SaveToFile();

            abonOption.abonListViewParts.Items_Clear();

            abonOption.MakeListView();
        }
    }
}
