﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Xml.Linq;
using System.IO;

namespace nispi.OptionControl
{
    class OthreOptionData : CommonInEvent
    {
        private string userAgent;
        private bool isProxyUse;
        private string proxyAddress;
        private string proxyPort;

        private string logFolder;
        private bool isWriteHistory;
        
        private bool isViewTaskBar;
        private bool isSaveOpenWindow;

        //画像とみなす拡張子
        private bool isPngImage;
        private bool isJpegImage;
        private bool isGifImage;
        private bool isBmpImage;

        private string modeType2ch;

        private string autoReloadTime;

        private string redirect;

        private Mutex mutex = new Mutex(false, "OthreOptionData");

        public OthreOptionData()
        {
            GetXMLData();
        }

        public string ResetXML()
        {
            XNamespace ns = "OthreOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "UserAgent", "Monazilla/1.00 (AgeOn/0.9)"),
                new XElement(ns + "IsProxyUse", "False"),

                new XElement(ns + "ProxyAddress", "none"),
                new XElement(ns + "ProxyPort", "8080"),
                new XElement(ns + "LogFolder", "?current:Ageon"),
                new XElement(ns + "IsWriteHistory", "True"),
                new XElement(ns + "IsViewTaskBar", "True"),
                new XElement(ns + "IsSaveOpenWindow", "True"),

                new XElement(ns + "IsJpegImage", "True"),
                new XElement(ns + "IsPngImage", "True"),
                new XElement(ns + "IsGifImage", "True"),
                new XElement(ns + "IsBmpImage", "True"),

                new XElement(ns + "ModeType2ch", "IEMode"),

                new XElement(ns + "AutoReloadTime", "15"),

                new XElement(ns + "Redirect", "noRedirect"));

            FileIO.SaveShiftJis("setting", "other.xml", doc.ToString());

            return doc.ToString();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "other.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "OthreOptionData";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                this.UserAgent = doc2.Element(ns + "UserAgent").Value;
                this.IsProxyUse = doc2.Element(ns + "IsProxyUse").Value;

                this.ProxyAddress = doc2.Element(ns + "ProxyAddress").Value;
                this.ProxyPort = doc2.Element(ns + "ProxyPort").Value;

                string tempLogFolder = doc2.Element(ns + "LogFolder").Value;
                //行が?current:で始まっている場合
                if (tempLogFolder.StartsWith("?current:") == true)
                {
                    string temp = tempLogFolder.Substring(9, tempLogFolder.Length - 9);
                    this.LogFolder = Const.DataDirNonAgeon;// +Path.DirectorySeparatorChar + temp;
                    Const.DataDir = this.logFolder;
                }
                else
                {
                    this.logFolder = tempLogFolder;
                    Const.DataDir = tempLogFolder;
                }
                this.IsWriteHistory = doc2.Element(ns + "IsWriteHistory").Value;

                this.IsViewTaskBar = doc2.Element(ns + "IsViewTaskBar").Value;
                this.IsSaveOpenWindow = doc2.Element(ns + "IsSaveOpenWindow").Value;

                try
                {
                    this.IsJpegImage = doc2.Element(ns + "IsJpegImage").Value;
                    this.IsPngImage = doc2.Element(ns + "IsPngImage").Value;
                    this.IsGifImage = doc2.Element(ns + "IsGifImage").Value;
                    this.IsBmpImage = doc2.Element(ns + "IsBmpImage").Value;
                }
                catch
                {
                    this.IsJpegImage = "True";
                    this.IsPngImage = "True";
                    this.IsGifImage = "True";
                    this.IsBmpImage = "True";
                }
                //2chモードかIEモードか
                try
                {
                    this.ModeType2ch = doc2.Element(ns + "ModeType2ch").Value;
                }
                catch
                {
                    this.ModeType2ch = "IEMode";
                }
                //オートリロード秒
                try
                {
                    this.AutoReloadTime = doc2.Element(ns + "AutoReloadTime").Value;
                }
                catch
                {
                    this.AutoReloadTime = "15";
                }
                //リダイレクト
                try
                {
                    this.Redirect = doc2.Element(ns + "Redirect").Value;
                }
                catch
                {
                    this.Redirect = "noRedirect";
                }
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public void SaveToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "OthreOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "UserAgent", this.UserAgent),
                new XElement(ns + "IsProxyUse", this.IsProxyUse),

                new XElement(ns + "ProxyAddress", this.ProxyAddress),
                new XElement(ns + "ProxyPort", this.ProxyPort),
                new XElement(ns + "LogFolder", this.logFolder),
                new XElement(ns + "IsWriteHistory", this.IsWriteHistory),

                new XElement(ns + "IsViewTaskBar", this.IsViewTaskBar),
                new XElement(ns + "IsSaveOpenWindow", this.IsSaveOpenWindow),

                new XElement(ns + "IsJpegImage", this.IsJpegImage),
                new XElement(ns + "IsPngImage", this.IsPngImage),
                new XElement(ns + "IsGifImage", this.IsGifImage),
                new XElement(ns + "IsBmpImage", this.IsBmpImage),

                new XElement(ns + "ModeType2ch", this.ModeType2ch),

                new XElement(ns + "AutoReloadTime", this.AutoReloadTime),

                new XElement(ns + "Redirect", this.Redirect));

            FileIO.SaveShiftJis("setting", "other.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public string UserAgent
        {
            set
            {
                mutex.WaitOne();
                this.userAgent = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = this.userAgent;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string IsProxyUse
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isProxyUse = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isProxyUse;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string ProxyAddress
        {
            set
            {
                mutex.WaitOne();
                this.proxyAddress = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.proxyAddress);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string ProxyPort
        {
            set
            {
                if (CheckInt(value) == false) return;
                mutex.WaitOne();
                this.proxyPort = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.proxyPort);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string LogFolder
        {
            set
            {
                if (CheckFolder(value) == false) return;
                mutex.WaitOne();
                this.logFolder = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.logFolder);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public string IsWriteHistory
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isWriteHistory = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isWriteHistory;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }

        public string IsViewTaskBar
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isViewTaskBar = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isViewTaskBar;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }

        public string IsSaveOpenWindow
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isSaveOpenWindow = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isSaveOpenWindow;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }

        //画像
        public string IsJpegImage
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isJpegImage = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isJpegImage;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string IsPngImage
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isPngImage = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isPngImage;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string IsGifImage
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isGifImage = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isGifImage;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string IsBmpImage
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isBmpImage = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isBmpImage;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string ModeType2ch
        {
            set
            {
                mutex.WaitOne();
                this.modeType2ch = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.modeType2ch);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string AutoReloadTime
        {
            set
            {
                if (CheckInt(value) == false) return;
                mutex.WaitOne();
                this.autoReloadTime = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.autoReloadTime);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string Redirect
        {
            set
            {
                mutex.WaitOne();
                this.redirect = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.redirect);
                mutex.ReleaseMutex();
                return data;
            }
        }
    }
}
