﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;
namespace nispi.OptionControl
{
    //タブのタブのテキストの色と背景色とフォント、フォームの背景色、テキストの色とフォント
    //リストビュー、インデックスの背景色、選択した色、フォント

    class OutWardForm:OutWardFormData
    {
        public TabPageExParts tabPageParts;
        GroupBoxParts formGBoxParts;

        public LabelParts formSampleLabelParts;
        public ButtonParts formForeColorButtonParts;
        public ButtonParts formBackColorButtonParts;
        public ButtonParts formResetButtonParts;

        public OptionMainForm optionTabMain;
        public OutWardEventForm outWardEventForm;

        public OutWardForm(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;

            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            formGBoxParts = new GroupBoxParts();

            formSampleLabelParts = new LabelParts();
            formForeColorButtonParts = new ButtonParts();

            formBackColorButtonParts = new ButtonParts();

            formResetButtonParts = new ButtonParts();

            tabPageParts = new  TabPageExParts();
            tabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabPageParts.Text = "外観 ";
            tabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            formGBoxParts.Location = new Point(10, 10);
            formGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 100);
            formGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            formGBoxParts.Text = "フォーム";

            formSampleLabelParts.Location = new Point(20, 30);
            formSampleLabelParts.Size = new Size(200, 60);
            formSampleLabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            formSampleLabelParts.Text = "文字色";
            formSampleLabelParts.BackColor = SystemColors.Control;
            formSampleLabelParts.ForeColor = SystemColors.WindowText;
            formSampleLabelParts.Set_BorderStyle_FixedSingle();

            formForeColorButtonParts.Location = new Point(230, 30);
            formForeColorButtonParts.Size = new Size(200, 25);
            formForeColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            formForeColorButtonParts.Text = "文字色";

            formBackColorButtonParts.Location = new Point(230, 60);
            formBackColorButtonParts.Size = new Size(100, 25);
            formBackColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            formBackColorButtonParts.Text = "背景色";

            formResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            formResetButtonParts.Size = new Size(100, 25);
            formResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            formResetButtonParts.Text = "元に戻す";

            tabPageParts.AddControl(formGBoxParts);
            formGBoxParts.AddControl(formSampleLabelParts);
            formGBoxParts.AddControl(formForeColorButtonParts);
            formGBoxParts.AddControl(formBackColorButtonParts);
            formGBoxParts.AddControl(formResetButtonParts);

            optionTabMain.optionTabControlParts.AddControl(tabPageParts);

            this.outWardEventForm = new OutWardEventForm(this);

        }
        public void SetDataToGUI()
        {
            this.outWardEventForm.ResetEvent();

            //this.formSampleLabelParts.SetFont(this.FormFontName, this.FormFontSize);

            this.formSampleLabelParts.ForeColor = Color.FromArgb(this.FormForeColorRed,
                 this.FormForeColorGreen,
                 this.FormForeColorBlue);

            this.formSampleLabelParts.BackColor = Color.FromArgb(this.FormBackColorRed,
                this.FormBackColorGreen,
                this.FormBackColorBlue);

            this.outWardEventForm.SetEvent();
         
        }
    }
}
