﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Xml.Linq;

namespace nispi.OptionControl
{
    class WriteOptionData : CommonInEvent
    {


        private string writeName;
        private string writeMail;
        private bool isSageCheck;


        private Mutex mutex = new Mutex(false, "WriteOptionData");

        public WriteOptionData()
        {
            GetXMLData();
        }
        public string ResetXML()
        {
            mutex.WaitOne();

            XNamespace ns = "WriteOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "WriteName", ""),
                new XElement(ns + "WriteMail", ""),
                new XElement(ns + "IsSageCheck", "False"));

            FileIO.SaveShiftJis("setting", "write.xml", doc.ToString());

            mutex.ReleaseMutex();

            return doc.ToString();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "write.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "WriteOptionData";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                this.WriteName = doc2.Element(ns + "WriteName").Value;
                this.WriteMail = doc2.Element(ns + "WriteMail").Value;
                this.IsSageCheck = doc2.Element(ns + "IsSageCheck").Value;
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public void SaveToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "WriteOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "WriteName", this.WriteName),
                new XElement(ns + "WriteMail", this.WriteMail),
                new XElement(ns + "IsSageCheck", this.IsSageCheck));

            FileIO.SaveShiftJis("setting", "write.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        public string WriteName
        {
            set
            {
                mutex.WaitOne();
                this.writeName = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.writeName);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public string WriteMail
        {
            set
            {
                mutex.WaitOne();
                this.writeMail = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.writeMail);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public string IsSageCheck
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isSageCheck = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isSageCheck;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
    }
}
