﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

using nispi;
using nispi.controlclass;

namespace nispi.OptionControl.theme
{
    class Theme
    {
        //ブラウザの文字色
        private byte browserForeColorRed;
        private byte browserForeColorGreen;
        private byte browserForeColorBlue;
        //背景色
        private byte browserBackColorRed;
        private byte browserBackColorGreen;
        private byte browserBackColorBlue;
        //リンクの色
        private byte browserLinkColorRed;
        private byte browserLinkColorGreen;
        private byte browserLinkColorBlue;
        //既リンクの色
        private byte browserLinkedColorRed;
        private byte browserLinkedColorGreen;
        private byte browserLinkedColorBlue;

        //フォーム
        private byte formForeColorRed;
        private byte formForeColorGreen;
        private byte formForeColorBlue;

        private byte formBackColorRed;
        private byte formBackColorGreen;
        private byte formBackColorBlue;

        //リストの文字色
        private byte lVForeColorRed;
        private byte lVForeColorGreen;
        private byte lVForeColorBlue;
        //リストの背景色の一つおき
        private byte lVBackColorRed;
        private byte lVBackColorGreen;
        private byte lVBackColorBlue;
        //リストの背景色の一つおき
        private byte lVBackColor2Red;
        private byte lVBackColor2Green;
        private byte lVBackColor2Blue;
        //選択されたリストの前景色
        private byte lVSelectForeColorRed;
        private byte lVSelectForeColorGreen;
        private byte lVSelectForeColorBlue;
        //選択されたリストの背景色
        private byte lVSelectBackColorRed;
        private byte lVSelectBackColorGreen;
        private byte lVSelectBackColorBlue;
        //カラムの文字色
        private byte lVColmunForeColorRed;
        private byte lVColmunForeColorGreen;
        private byte lVColmunForeColorBlue;
        //カラムの背景色
        private byte lVColmunBackColorRed;
        private byte lVColmunBackColorGreen;
        private byte lVColmunBackColorBlue;

        //タブの中身の文字色
        private byte tabForeColorRed;
        private byte tabForeColorGreen;
        private byte tabForeColorBlue;
        //タブの中身の背景色
        private byte tabBackColorRed;
        private byte tabBackColorGreen;
        private byte tabBackColorBlue;
        //タブのつまむ部分の色のグラデーション
        private byte tabColorStartRed;
        private byte tabColorStartGreen;
        private byte tabColorStartBlue;
        //タブのつまむ部分のグラデーションの終わりの色
        private byte tabColorEndRed;
        private byte tabColorEndGreen;
        private byte tabColorEndBlue;

        //メニュー
        private byte menuSample1ForeColorRed;
        private byte menuSample1ForeColorGreen;
        private byte menuSample1ForeColorBlue;

        private byte menuSample1BackColorRed;
        private byte menuSample1BackColorGreen;
        private byte menuSample1BackColorBlue;
        //選択
        private byte menuSample2ForeColorRed;
        private byte menuSample2ForeColorGreen;
        private byte menuSample2ForeColorBlue;

        private byte menuSample2BackColorRed;
        private byte menuSample2BackColorGreen;
        private byte menuSample2BackColorBlue;

        public Theme()
        {

        }

        public void GetXMLData(string theme)
        {
            string str = FileIO.ReadShiftJis("theme", theme);
            //Const.debugForm.OutPutDebug("BoardIndex", "1");
            if ((str == null) || (str.Length == 0))
                return;
            //Const.debugForm.OutPutDebug("BoardIndex", "2");
            try
            {
                XNamespace ns = "Themes";
                //Const.debugForm.OutPutDebug("BoardIndex", "3");
                XDocument doc = XDocument.Parse(str);
                //Const.debugForm.OutPutDebug("BoardIndex", "4");
                XElement doc2 = doc.Element(ns + theme.Split('.')[0]);
                //Const.debugForm.OutPutDebug("BoardIndex", "5");
                //ブラウザ
                Const.opt.outWardBrowser.BrowserForeColorRed = Byte.Parse(doc2.Element(ns + "BrowserForeColorRed").Value);
                Const.opt.outWardBrowser.BrowserForeColorGreen = Byte.Parse(doc2.Element(ns + "BrowserForeColorGreen").Value);
                Const.opt.outWardBrowser.BrowserForeColorBlue = Byte.Parse(doc2.Element(ns + "BrowserForeColorBlue").Value);

                Const.opt.outWardBrowser.BrowserBackColorRed = Byte.Parse(doc2.Element(ns + "BrowserBackColorRed").Value);
                Const.opt.outWardBrowser.BrowserBackColorGreen = Byte.Parse(doc2.Element(ns + "BrowserBackColorGreen").Value);
                Const.opt.outWardBrowser.BrowserBackColorBlue = Byte.Parse(doc2.Element(ns + "BrowserBackColorBlue").Value);

                Const.opt.outWardBrowser.BrowserLinkColorRed = Byte.Parse(doc2.Element(ns + "BrowserLinkColorRed").Value);
                Const.opt.outWardBrowser.BrowserLinkColorGreen = Byte.Parse(doc2.Element(ns + "BrowserLinkColorGreen").Value);
                Const.opt.outWardBrowser.BrowserLinkColorBlue = Byte.Parse(doc2.Element(ns + "BrowserLinkColorBlue").Value);

                Const.opt.outWardBrowser.BrowserLinkedColorRed = Byte.Parse(doc2.Element(ns + "BrowserLinkedColorRed").Value);
                Const.opt.outWardBrowser.BrowserLinkedColorGreen = Byte.Parse(doc2.Element(ns + "BrowserLinkedColorGreen").Value);
                Const.opt.outWardBrowser.BrowserLinkedColorBlue = Byte.Parse(doc2.Element(ns + "BrowserLinkedColorBlue").Value);

                //フォーム
                Const.opt.outWardForm.FormForeColorRed = Byte.Parse(doc2.Element(ns + "FormForeColorRed").Value);
                Const.opt.outWardForm.FormForeColorGreen = Byte.Parse(doc2.Element(ns + "FormForeColorGreen").Value);
                Const.opt.outWardForm.FormForeColorBlue = Byte.Parse(doc2.Element(ns + "FormForeColorBlue").Value);

                Const.opt.outWardForm.FormBackColorRed = Byte.Parse(doc2.Element(ns + "FormBackColorRed").Value);
                Const.opt.outWardForm.FormBackColorGreen = Byte.Parse(doc2.Element(ns + "FormBackColorGreen").Value);
                Const.opt.outWardForm.FormBackColorBlue = Byte.Parse(doc2.Element(ns + "FormBackColorBlue").Value);
                //Const.debugForm.OutPutDebug("BoardIndex", "6");
                //リスト
                Const.opt.outWardList.LVForeColorRed = Byte.Parse(doc2.Element(ns + "LVForeColorRed").Value);
                Const.opt.outWardList.LVForeColorGreen = Byte.Parse(doc2.Element(ns + "LVForeColorGreen").Value);
                Const.opt.outWardList.LVForeColorBlue = Byte.Parse(doc2.Element(ns + "LVForeColorBlue").Value);

                Const.opt.outWardList.LVBackColorRed = Byte.Parse(doc2.Element(ns + "LVBackColorRed").Value);
                Const.opt.outWardList.LVBackColorGreen = Byte.Parse(doc2.Element(ns + "LVBackColorGreen").Value);
                Const.opt.outWardList.LVBackColorBlue = Byte.Parse(doc2.Element(ns + "LVBackColorBlue").Value);

                Const.opt.outWardList.LVBackColor2Red = Byte.Parse(doc2.Element(ns + "LVBackColor2Red").Value);
                Const.opt.outWardList.LVBackColor2Green = Byte.Parse(doc2.Element(ns + "LVBackColor2Green").Value);
                Const.opt.outWardList.LVBackColor2Blue = Byte.Parse(doc2.Element(ns + "LVBackColor2Blue").Value);

                Const.opt.outWardList.LVSelectForeColorRed = Byte.Parse(doc2.Element(ns + "LVSelectForeColorRed").Value);
                Const.opt.outWardList.LVSelectForeColorGreen = Byte.Parse(doc2.Element(ns + "LVSelectForeColorGreen").Value);
                Const.opt.outWardList.LVSelectForeColorBlue = Byte.Parse(doc2.Element(ns + "LVSelectForeColorBlue").Value);

                Const.opt.outWardList.LVSelectBackColorRed = Byte.Parse(doc2.Element(ns + "LVSelectBackColorRed").Value);
                Const.opt.outWardList.LVSelectBackColorGreen = Byte.Parse(doc2.Element(ns + "LVSelectBackColorGreen").Value);
                Const.opt.outWardList.LVSelectBackColorBlue = Byte.Parse(doc2.Element(ns + "LVSelectBackColorBlue").Value);

                Const.opt.outWardList.LVColmunForeColorRed = Byte.Parse(doc2.Element(ns + "LVColmunForeColorRed").Value);
                Const.opt.outWardList.LVColmunForeColorGreen = Byte.Parse(doc2.Element(ns + "LVColmunForeColorGreen").Value);
                Const.opt.outWardList.LVColmunForeColorBlue = Byte.Parse(doc2.Element(ns + "LVColmunForeColorBlue").Value);

                Const.opt.outWardList.LVColmunBackColorRed = Byte.Parse(doc2.Element(ns + "LVColmunBackColorRed").Value);
                Const.opt.outWardList.LVColmunBackColorGreen = Byte.Parse(doc2.Element(ns + "LVColmunBackColorGreen").Value);
                Const.opt.outWardList.LVColmunBackColorBlue = Byte.Parse(doc2.Element(ns + "LVColmunBackColorBlue").Value);

                //タブ
                Const.opt.outWardTab.TabForeColorRed = Byte.Parse(doc2.Element(ns + "TabForeColorRed").Value);
                Const.opt.outWardTab.TabForeColorGreen = Byte.Parse(doc2.Element(ns + "TabForeColorGreen").Value);
                Const.opt.outWardTab.TabForeColorBlue = Byte.Parse(doc2.Element(ns + "TabForeColorBlue").Value);

                Const.opt.outWardTab.TabBackColorRed = Byte.Parse(doc2.Element(ns + "TabBackColorRed").Value);
                Const.opt.outWardTab.TabBackColorGreen = Byte.Parse(doc2.Element(ns + "TabBackColorGreen").Value);
                Const.opt.outWardTab.TabBackColorBlue = Byte.Parse(doc2.Element(ns + "TabBackColorBlue").Value);
                //Const.debugForm.OutPutDebug("BoardIndex", "8");
                Const.opt.outWardTab.TabSelectedColorRed = Byte.Parse(doc2.Element(ns + "TabSelectedColorRed").Value);
                Const.opt.outWardTab.TabSelectedColorGreen = Byte.Parse(doc2.Element(ns + "TabSelectedColorGreen").Value);
                Const.opt.outWardTab.TabSelectedColorBlue = Byte.Parse(doc2.Element(ns + "TabSelectedColorBlue").Value);

                Const.opt.outWardTab.TabHotColorRed = Byte.Parse(doc2.Element(ns + "TabHotColorRed").Value);
                Const.opt.outWardTab.TabHotColorGreen = Byte.Parse(doc2.Element(ns + "TabHotColorGreen").Value);
                Const.opt.outWardTab.TabHotColorBlue = Byte.Parse(doc2.Element(ns + "TabHotColorBlue").Value);
                //Const.debugForm.OutPutDebug("BoardIndex", "9");
                //メニュー
                Const.opt.outWardMenu.MenuSample1ForeColorRed = Byte.Parse(doc2.Element(ns + "MenuSample1ForeColorRed").Value);
                Const.opt.outWardMenu.MenuSample1ForeColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample1ForeColorGreen").Value);
                Const.opt.outWardMenu.MenuSample1ForeColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample1ForeColorBlue").Value);

                Const.opt.outWardMenu.MenuSample1BackColorRed = Byte.Parse(doc2.Element(ns + "MenuSample1BackColorRed").Value);
                Const.opt.outWardMenu.MenuSample1BackColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample1BackColorGreen").Value);
                Const.opt.outWardMenu.MenuSample1BackColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample1BackColorBlue").Value);

                Const.opt.outWardMenu.MenuSample2ForeColorRed = Byte.Parse(doc2.Element(ns + "MenuSample2ForeColorRed").Value);
                Const.opt.outWardMenu.MenuSample2ForeColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample2ForeColorGreen").Value);
                Const.opt.outWardMenu.MenuSample2ForeColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample2ForeColorBlue").Value);

                Const.opt.outWardMenu.MenuSample2BackColorRed = Byte.Parse(doc2.Element(ns + "MenuSample2BackColorRed").Value);
                Const.opt.outWardMenu.MenuSample2BackColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample2BackColorGreen").Value);
                Const.opt.outWardMenu.MenuSample2BackColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample2BackColorBlue").Value);
                Const.opt.outWardMenu.IsUseRenderer = "True";
                //Const.debugForm.OutPutDebug("BoardIndex", "10");
                Const.opt.outWardForm.SaveFormToFile();
                Const.opt.outWardTab.SaveTabToFile();
                Const.opt.outWardList.SaveListViewToFile();
                Const.opt.outWardBrowser.SaveBrowserToFile();
                Const.opt.outWardMenu.SaveFormToFile();
                //Const.debugForm.OutPutDebug("BoardIndex", "11");
                //再起動する
                System.Diagnostics.Process.Start("ExitAndRun.exe");
                //Const.debugForm.OutPutDebug("BoardIndex", "12");
                return;
            }
            catch { ;}
        }
        public string OutPutXML()
        {
            XNamespace ns = "Themes";
            XElement doc = new XElement(ns + "Standard",

                new XElement(ns + "BrowserForeColorRed", Const.opt.outWardBrowser.BrowserForeColorRed),
                new XElement(ns + "BrowserForeColorGreen", Const.opt.outWardBrowser.BrowserForeColorGreen),
                new XElement(ns + "BrowserForeColorBlue", Const.opt.outWardBrowser.BrowserForeColorBlue),

                new XElement(ns + "BrowserBackColorRed", Const.opt.outWardBrowser.BrowserBackColorRed),
                new XElement(ns + "BrowserBackColorGreen", Const.opt.outWardBrowser.BrowserBackColorGreen),
                new XElement(ns + "BrowserBackColorBlue", Const.opt.outWardBrowser.BrowserBackColorBlue),

                new XElement(ns + "BrowserLinkColorRed", Const.opt.outWardBrowser.BrowserLinkColorRed),
                new XElement(ns + "BrowserLinkColorGreen", Const.opt.outWardBrowser.BrowserLinkColorGreen),
                new XElement(ns + "BrowserLinkColorBlue", Const.opt.outWardBrowser.BrowserLinkColorBlue),

                new XElement(ns + "BrowserLinkedColorRed", Const.opt.outWardBrowser.BrowserLinkedColorRed),
                new XElement(ns + "BrowserLinkedColorGreen", Const.opt.outWardBrowser.BrowserLinkedColorGreen),
                new XElement(ns + "BrowserLinkedColorBlue", Const.opt.outWardBrowser.BrowserLinkedColorBlue),

                //
                new XElement(ns + "FormForeColorRed", Const.opt.outWardForm.FormForeColorRed),
                new XElement(ns + "FormForeColorGreen", Const.opt.outWardForm.FormForeColorGreen),
                new XElement(ns + "FormForeColorBlue", Const.opt.outWardForm.FormForeColorBlue),

                new XElement(ns + "FormBackColorRed", Const.opt.outWardForm.FormBackColorRed),
                new XElement(ns + "FormBackColorGreen", Const.opt.outWardForm.FormBackColorGreen),
                new XElement(ns + "FormBackColorBlue", Const.opt.outWardForm.FormBackColorBlue),

                //
                new XElement(ns + "LVForeColorRed", Const.opt.outWardList.LVForeColorRed),
                new XElement(ns + "LVForeColorGreen", Const.opt.outWardList.LVForeColorGreen),
                new XElement(ns + "LVForeColorBlue", Const.opt.outWardList.LVForeColorBlue),

                new XElement(ns + "LVBackColorRed", Const.opt.outWardList.LVBackColorRed),
                new XElement(ns + "LVBackColorGreen", Const.opt.outWardList.LVBackColorGreen),
                new XElement(ns + "LVBackColorBlue", Const.opt.outWardList.LVBackColorBlue),

                new XElement(ns + "LVBackColor2Red", Const.opt.outWardList.LVBackColor2Red),
                new XElement(ns + "LVBackColor2Green", Const.opt.outWardList.LVBackColor2Green),
                new XElement(ns + "LVBackColor2Blue", Const.opt.outWardList.LVBackColor2Blue),

                new XElement(ns + "LVSelectForeColorRed", Const.opt.outWardList.LVSelectForeColorRed),
                new XElement(ns + "LVSelectForeColorGreen", Const.opt.outWardList.LVSelectForeColorGreen),
                new XElement(ns + "LVSelectForeColorBlue", Const.opt.outWardList.LVSelectForeColorBlue),

                new XElement(ns + "LVSelectBackColorRed", Const.opt.outWardList.LVSelectBackColorRed),
                new XElement(ns + "LVSelectBackColorGreen", Const.opt.outWardList.LVSelectBackColorGreen),
                new XElement(ns + "LVSelectBackColorBlue", Const.opt.outWardList.LVSelectBackColorBlue),

                new XElement(ns + "LVColmunForeColorRed", Const.opt.outWardList.LVColmunForeColorRed),
                new XElement(ns + "LVColmunForeColorGreen", Const.opt.outWardList.LVColmunForeColorGreen),
                new XElement(ns + "LVColmunForeColorBlue", Const.opt.outWardList.LVColmunForeColorBlue ),

                new XElement(ns + "LVColmunBackColorRed", Const.opt.outWardList.LVColmunBackColorRed),
                new XElement(ns + "LVColmunBackColorGreen", Const.opt.outWardList.LVColmunBackColorGreen),
                new XElement(ns + "LVColmunBackColorBlue", Const.opt.outWardList.LVColmunBackColorBlue),


                //
                new XElement(ns + "TabForeColorRed", Const.opt.outWardTab.TabForeColorRed),
                new XElement(ns + "TabForeColorGreen", Const.opt.outWardTab.TabForeColorGreen),
                new XElement(ns + "TabForeColorBlue", Const.opt.outWardTab.TabForeColorBlue),

                new XElement(ns + "TabBackColorRed", Const.opt.outWardTab.TabBackColorRed),
                new XElement(ns + "TabBackColorGreen", Const.opt.outWardTab.TabBackColorGreen),
                new XElement(ns + "TabBackColorBlue", Const.opt.outWardTab.TabBackColorBlue),

                new XElement(ns + "TabSelectedColorRed", Const.opt.outWardTab.TabSelectedColorRed),
                new XElement(ns + "TabSelectedColorGreen", Const.opt.outWardTab.TabSelectedColorGreen),
                new XElement(ns + "TabSelectedColorBlue", Const.opt.outWardTab.TabSelectedColorBlue),

                new XElement(ns + "TabHotColorRed", Const.opt.outWardTab.TabHotColorRed),
                new XElement(ns + "TabHotColorGreen", Const.opt.outWardTab.TabHotColorGreen),
                new XElement(ns + "TabHotColorBlue", Const.opt.outWardTab.TabHotColorBlue),

                //
                new XElement(ns + "MenuSample1ForeColorRed", Const.opt.outWardMenu.MenuSample1ForeColorRed),
                new XElement(ns + "MenuSample1ForeColorGreen", Const.opt.outWardMenu.MenuSample1ForeColorGreen),
                new XElement(ns + "MenuSample1ForeColorBlue", Const.opt.outWardMenu.MenuSample1ForeColorBlue),

                new XElement(ns + "MenuSample1BackColorRed", Const.opt.outWardMenu.MenuSample1BackColorRed),
                new XElement(ns + "MenuSample1BackColorGreen", Const.opt.outWardMenu.MenuSample1BackColorGreen),
                new XElement(ns + "MenuSample1BackColorBlue", Const.opt.outWardMenu.MenuSample1BackColorBlue),

                new XElement(ns + "MenuSample2ForeColorRed", Const.opt.outWardMenu.MenuSample2ForeColorRed),
                new XElement(ns + "MenuSample2ForeColorGreen", Const.opt.outWardMenu.MenuSample2ForeColorGreen),
                new XElement(ns + "MenuSample2ForeColorBlue", Const.opt.outWardMenu.MenuSample2ForeColorBlue),

                new XElement(ns + "MenuSample2BackColorRed", Const.opt.outWardMenu.MenuSample2BackColorRed),//SystemColors.Control.R.ToString()),
                new XElement(ns + "MenuSample2BackColorGreen", Const.opt.outWardMenu.MenuSample2BackColorGreen),//SystemColors.Control.G.ToString()),
                new XElement(ns + "MenuSample2BackColorBlue", Const.opt.outWardMenu.MenuSample2BackColorBlue));

            FileIO.SaveShiftJis("theme", "standard.xml", doc.ToString());
            return doc.ToString();
            return "";
        }
        public string ResetXML()
        {
            //mutex.WaitOne();

            XNamespace ns = "Themes";
            XElement doc = new XElement(ns + "Standard",
                
                new XElement(ns + "BrowserForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "BrowserForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "BrowserForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "BrowserBackColorRed", SystemColors.Window.R.ToString()),
                new XElement(ns + "BrowserBackColorGreen", SystemColors.Window.G.ToString()),
                new XElement(ns + "BrowserBackColorBlue", SystemColors.Window.B.ToString()),

                new XElement(ns + "BrowserLinkColorRed", 0),
                new XElement(ns + "BrowserLinkColorGreen", 0),
                new XElement(ns + "BrowserLinkColorBlue", 255),

                new XElement(ns + "BrowserLinkedColorRed", 128),
                new XElement(ns + "BrowserLinkedColorGreen", 0),
                new XElement(ns + "BrowserLinkedColorBlue", 128),

                //
                new XElement(ns + "FormForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "FormForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "FormForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "FormBackColorRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "FormBackColorGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "FormBackColorBlue", SystemColors.Control.B.ToString()),

                //
                new XElement(ns + "LVForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "LVForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "LVForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "LVBackColorRed", Color.White.R.ToString()),
                new XElement(ns + "LVBackColorGreen", Color.White.G.ToString()),
                new XElement(ns + "LVBackColorBlue", Color.White.B.ToString()),

                new XElement(ns + "LVBackColor2Red", Color.AliceBlue.R.ToString()),
                new XElement(ns + "LVBackColor2Green", Color.AliceBlue.G.ToString()),
                new XElement(ns + "LVBackColor2Blue", Color.AliceBlue.B.ToString()),

                new XElement(ns + "LVSelectForeColorRed", SystemColors.HighlightText.R.ToString()),
                new XElement(ns + "LVSelectForeColorGreen", SystemColors.HighlightText.G.ToString()),
                new XElement(ns + "LVSelectForeColorBlue", SystemColors.HighlightText.B.ToString()),

                new XElement(ns + "LVSelectBackColorRed", SystemColors.Highlight.R.ToString()),
                new XElement(ns + "LVSelectBackColorGreen", SystemColors.Highlight.G.ToString()),
                new XElement(ns + "LVSelectBackColorBlue", SystemColors.Highlight.B.ToString()),

                new XElement(ns + "LVColmunForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "LVColmunForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "LVColmunForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "LVColmunBackColorRed", SystemColors.Window.R.ToString()),
                new XElement(ns + "LVColmunBackColorGreen", SystemColors.Window.G.ToString()),
                new XElement(ns + "LVColmunBackColorBlue", SystemColors.Window.B.ToString()),


                //
                new XElement(ns + "TabForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "TabForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "TabForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "TabBackColorRed", SystemColors.Window.R.ToString()),
                new XElement(ns + "TabBackColorGreen", SystemColors.Window.G.ToString()),
                new XElement(ns + "TabBackColorBlue", SystemColors.Window.B.ToString()),

                new XElement(ns + "TabSelectedColorRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "TabSelectedColorGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "TabSelectedColorBlue", SystemColors.Control.B.ToString()),

                new XElement(ns + "TabHotColorRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "TabHotColorGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "TabHotColorBlue", SystemColors.Control.B.ToString()),
                
                //
                new XElement(ns + "MenuSample1ForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "MenuSample1ForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "MenuSample1ForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "MenuSample1BackColorRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "MenuSample1BackColorGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "MenuSample1BackColorBlue", SystemColors.Control.B.ToString()),

                new XElement(ns + "MenuSample2ForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "MenuSample2ForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "MenuSample2ForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "MenuSample2BackColorRed", Color.FromArgb(255, 209, 226, 242).R.ToString()),//SystemColors.Control.R.ToString()),
                new XElement(ns + "MenuSample2BackColorGreen", Color.FromArgb(255, 209, 226, 242).G.ToString()),//SystemColors.Control.G.ToString()),
                new XElement(ns + "MenuSample2BackColorBlue", Color.FromArgb(255, 209, 226, 242).B.ToString()));

            FileIO.SaveShiftJis("theme", "standard.xml", doc.ToString());
            return doc.ToString();
        }
    }
}