﻿using System.Linq;
using System.Text;
using System.Xml;
using System.IO;
using System;
//using System.Threading.Tasks;

//メインフォームを閉じるときに保存、
////BoardIndexViewにてRead()を行っている
namespace nispi.SaveBoardAndThread
{
    class SaveIndexTabNum
    {
        public SaveIndexTabNum()
        {
        }

        public void Save(int num)
        {
            string ns = "SaveIndexTabNum";

            XmlDocument doc = new XmlDocument();
            XmlElement saveBoardList = doc.CreateElement("SaveIndexTabNum", ns);
            doc.AppendChild(saveBoardList);

            XmlElement threadAddress = doc.CreateElement("IndexTabNum", ns);
            //内部にAddressを作成
            threadAddress.SetAttribute("Num", num.ToString());
            //スレッドの名前を<>と</>に囲われた中身に設定
            threadAddress.InnerText = "temp";
            //SaveThreadListの下位に加える
            saveBoardList.AppendChild(threadAddress);


            FileIO.SaveShiftJis("setting", "SaveIndexTabNum.xml", doc.OuterXml);
        }

        delegate void ShowThreadDelegate(string threadUrl, string threadName);
        
        public void Read()
        {
            string str = FileIO.ReadShiftJis("setting", "SaveIndexTabNum.xml");

            //中身がなければリターン
            if ((str == null) || (str.Length == 0)) return;
            
            XmlDocument dom = new XmlDocument();
            dom.LoadXml(str);

            foreach (XmlElement node in dom.GetElementsByTagName("IndexTabNum", "SaveIndexTabNum"))
            {
                //Addressの値を得る
                string numStr = node.Attributes["Num"].Value;
                //<>と</>に囲われた部分を得る
                string tempStr = node.InnerText;

                //
                Const.form.boardIndexTabControlParts.SelectedIndex = Int32.Parse(numStr);

                break;
            }

            //Const.form.mainForm.Invoke((Action)(() => Const.form.threadListTabControlParts.SelectedIndex = 0));
        }
    }
}