<?php
// $Id: dbList.inc,v 1.1 2005/04/08 07:14:41 atsushifx Exp $
//
/**
 * ڡ󥰥饹
 *
 * ɽѤ˥ڡֹ䡢ڡQueryȯԤʤɤԤ
 *
 * @package jp.sf.aglib.dbobject
 *
 * @copyright Copyright &copy; 2004-2005 aglib Project
 * @licence http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.1 $
 * @since   1.00
 * @create  2004-05-05
 */
require_once 'aglib.inc';
// aglib
require_once 'DB/dbBase.inc';

/**
* ɽDBϥ饹
* @version $Revision: 1.1 $
* @author Furukaw Atsushi <atsushifx@aglabo.com>
* @since 2003/9/19
*/
class dbList extends dbBase {
    /**
    * @var string ơ֥
    */
    var $dbtable;

    /**
    * @access private
    * @var int ڡ(1ڡɽԿ)
    */
    var $_pgrows = 10;

    /**
    * @access private
    * @var int ơ֥Կ
    */
    var $_rowmax = 0;

    /**
    * @access private
    * @var int ڡ
    */
    var $_pgmax = 0;

    /**
    * @access private
    * @var string SQL¹Ѥwhere
    */
    var $_where = "";

    /**
    * @access private
    * @var whereθ³SQL
    */
    var $_addSql = "";

    /**
    * @access private
    * @var DB_Result: SQLη
    */
    var $_result;


    /**
     * 󥹥ȥ饯
     *
     * @param string            ơ֥̾
     * @param int(&optional)    ڡ(1ԤɽԿ)
     */
    function dbList($table, $pgsize=0)
    {
        $this->dbBase();
        $this->dbtable = $table;
        if ($pgsize > 0) {
            $this->setPagesize($pgsize);
        }
    }

    /**
     * Version
     *
     * @param void
     * @return string   СNo
     */
    function version()
    {
        return '1.00';
    }

    /**
     * ڡ
     *
     * @param int ڡ(1ڡɽԿ)
     * @return int ڡ
     */
    function setPagesize($pgrows)
    {
        if ($pgrows <= 0)   return false;
        $this->_pgrows = $pgrows;
        return $this->_pgrows;
    }

    /**
     * ڡ򻻽Ф
     *
     * @return Фڡ
     */
    function pageCalc()
    {
        $this->_pgmax = intval(($this->_rowmax + $this->_pgrows - 1) / $this->_pgrows);
        return $this->_pgmax;
    }

    /**
     * ڡֹꤹ
     *
     * @access private
     * @param int ڡֹ
     * @return ڡֹ
     */
    function _regPage(&$pgno)
    {
        $this->pageCalc();
        if ($pgno < 1)              $pgno = 1;
        if ($pgno > $this->_pgmax)  $pgno = $this->_pgmax;
        return $pgno;
    }

    /**
    * ڡ鳫ϹԤ
    * @param int ڡֹ
    * @return Ϲ
    */
    function pageStart($pgno)
    {
        $pgno = $this->_regPage($pgno); // ڡֹ(̤1ڡ,ڡСǽڡ)
        $start = ($pgno - 1) * $this->_pgrows;
        return $start;
    }

    /**
    * ڡ뤫å
    * @param int ڡֹ
    * @return bool true:ڡ꡿false:ڡʤ
    */
    function hasPrev($pgno)
    {
        $pgno = $this->_regPage($pgno);
        return ($pgno > 1);
    }

    /**
    * ڡ뤫å
    * @param int ڡֹ
    * @return bool true:ڡ꡿false:ڡʤ
    */
    function hasNext($pgno)
    {
        $pgno = $this->_regPage($pgno);
        return ($pgno < $this->_pgmax);
    }

    /**
    * Ѥwhereꤹ
    * @param string where
    * @return string where
    */
    function prepare($where, $addsql=null)
    {
        $this->_where = $where;
        $this->_addSql = $addsql;
        return $this->_where;
    }

    /**
    * ιԿ
    * @param string(&optional)  SQLwhere
    * @return int ιԿ/false:¹Լ
    */
    function count($where = "")
    {
        if (!$this->connect())  return false;
        if ($where != "")    $this->prepare($where);
        $sql = $this->_makeSql("count(*)", false);
        $count = $this->_db->GetOne($sql);
        if (DB::isError($count))    return false;
        $this->_rowmax = $count;
        return $count;
    }


    /**
    * ڡιԤSQLȯԤ
    * @param int ڡֹ
    * @return DB_Result SQL¹Է
    */
    function execute($pgno)
    {
        $count = $this->count();        // Կ
        $start = $this->pageStart($pgno);

        $sql = $this->_makeSql("*");
        $this->_result = $this->_db->limitQuery($sql, $start, $this->_pgrows);
        return $this->_result;
    }

    /**
    * SQL
    * @access private
    * @param string $columns ̼ʸ
    */
    function _makeSql($columns)
    {
        $sql    = "select " . $columns . "\n";
        $sql .= "from " . $this->dbtable . "\n";
        if ($this->_where != "") {
            $sql .= "where " . $this->_where . "\n";
        }
        $cnt_flag = stristr($columns, "count");
        if (!$cnt_flag && $this->_addSql!="") {
            $sql .= $this->_addSql;
        }
        return $sql;
    }
}
?>
