<?php
// $Id: agMail.inc,v 1.3 2005/04/08 07:55:54 atsushifx Exp $
// 
/**
 * ܸб᡼饹
 *
 * @package jp.sf.aglib.mail
 *
 * @copyright Copyright &copy 2004-2005 aglib Project
 * @license http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @since   1.10
 * @version $Revision: 1.3 $
 * @create  2004-10-26
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
require_once 'aglib.inc';
// PEAR lib
require_once 'Mail.php';        // PEAR::Mail
// aglib
require_once 'agOptions.inc';
/**
 * ᡼Unit
 *
 * ư᡼Ѥɬפʥإåꤷƥ᡼
 * ᡼֤PEAR::MailѤƹԤ
 *
 * @since   1.10
 * @version 1.00
 * @create  2004-10-26
 *
 * @author Furukawa Atsushi <atsushifx@aglabo.com>
 */
class agMail {
    /**
    * @access private
    * @var agOptions ץꡦѰѾ饹
    */
    var $_opt;  //

    /**
    * @access private
    * @var string[] Mailإå
    */
    var $_header;

    /**
    * @access private
    * @var Mail ᡼˥å
    */
    var $_mail;


    /**
    * 󥹥ȥ饯
    */
    function agMail($protocol = null, $param = null, $force_init = false)
    {
        $init_header = array(
            "X-Mailer" => "agMailer Ver " . $this->version(),
            "Mime-Version" => "1.0",
            "Content-Type" => "text/plain; charset=iso-2022-jp",
            "Content-Transfer-Encoding" => "7bit",
        );
        $init_opt = array(
            "encode" => "JIS",
            "header" => $init_header,
        );
        $this->_opt = & agOptions::init($init_opt, $force_init);
        $this->_header = &$this->getOption("header");

        // ᡼˥åȺ
        if ($protocol == null) {  $protocol = "mail";  }
        $this->_mail = Mail::factory($protocol, $param);
    }

    /**
    * agMailΥС
    *
    * @param void
    * @return string СNo
    */
    function version()
    {
        return "1.00";
    }

    /**
    * ץ
    *
    * ꤵ줿ץ˳ͤ
    *
    * @param string ץ (null:ƤΥץ)
    * @return string[] ץꥹ
    */
    function &setOption($name, $opt=null)
    {
        return $this->_opt->setOption($name, $opt);
    }

    /**
    * ץ
    *
    * ꤵ줿ץ˳ͤ
    *
    * @param string ץ (null:ƤΥץ)
    * @return mixed ץ
    */
    function &getOption($opt=null)
    {
        return $this->_opt->getOption($opt);
    }


    /**
    * إå
    * ᡼Υإåꤹ
    * @param string إå
    * @param string إå
    * @return boolean true:
    */
    function setHeader($key, $value)
    {
        if ($key != null) {
            $this->_header[$key] = $value;
        }
        return true;
    }

    /**
    * إå
    *
    * ꤵ줿᡼إå
    *
    * @param string إå (null:ƤΥإå)
    * @return string إå
    */
    function getHeader($key = null)
    {
        $ret = null;
        if ($key == null) {
            $ret = $this->_header;
        } else {
            $ret = $this->_header[$key];
        }
        return $ret;
    }

    /**
    * ԰ꥹȤ
    * ̾ȤMime󥳡ɤǥ᡼륢ɥ쥹ղä
    *
    * @param string ᡼륢ɥ쥹
    * @return string ᡼륢ɥ쥹ꥹ
    */
    function fromList($addresses)
    {
        $list = null;
        if (!is_array($addresses)) {
            $addresses = array($addresses);
        }
        $list = array();
        foreach ($addresses as $addr=>$name) {
            if (is_int($addr)) {    // only address
                $addr = $name;
                $name = null;
            } else {
                $addr = $this->mailEncode($name) . " <" . $addr . ">";
            }
            array_push($list, $addr);
        }
        $list = implode(", ", $list);
        return $list;
    }

    /**
    * åISO-2022-JPѴ
    *
    * @param string Υå
    * @param string 󥳡ѴΥå
    */
    function mailConvert($message)
    {
        return mb_convert_encoding($message, $this->getOption("encode"));
    }

    /**
    * Subjectʤɤ褦ʸMime󥳡ɤ
    */
    function mailEncode($message)
    {
        return mb_encode_mimeheader($message, $this->getOption("encode"));
    }


    /**
    * ᡼
    *
    * @param string ꥹ
    * @param string 
    * @param string ᡼Subject
    * @param string ᡼å
    * @return boolean true:᡼PEAR_Error:
    */
    function send($to, $from, $subject, $message)
    {
        $message = $this->mailConvert($message);
        $this->setHeader("To", $to);
        $this->setHeader("From", $this->fromList($from));
        $this->setHeader("Subject", $this->mailEncode($subject));
        return $this->_mail->send($to, $this->getHeader(), $message);
    }
}
?>
