<?php
// $Id: agDA.inc,v 1.13 2005/04/08 07:57:36 atsushifx Exp $
//ͭ
/**
 * ǡ
 *
 * 󤪤ӥ饹ΥСǥǡμϤԤ
 *
 * @package jp.sf.aglib
 *
 * @copyright Copyright &copy 2004-2005 aglib Project
 * @license http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.13 $
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 * @create  2005-03-28
 */
require_once 'aglib.inc';
//

/**
 * ǡ
 *
 * 󤪤ӥ饹ΥСǥǡμϤԤ
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 * @version 0.10
 * @create  2005-03-28
 */
class agDA {
    /**
    * @access public
    * @var string   饹СPrefix
    */
    var $prefix;

    /**
    * @access private
    * @var string   饹СPrefix
    */
    var $_pfx_connect = '_';

    /**
    * 󥹥ȥ饯
    *
    * ǡѥ󥹥ȥ饯
    *   - СѤPrefixǤ
    *
    * @param string Сץե (='')
    * @return void
    */
    function agDA($prefix = '')
    {
        $this->setPrefix($prefix);
    }

    /**
    * Prefix
    *
    * 饹СPrefixꤹ
    *
    * @param string     ꤹPrefix(=null)
    * @return string    СPrefix
    */
    function setPrefix($prefix = null)
    {
        $old_prefix = $this->getPrefix();
        if (!is_null($prefix)) {
            $this->prefix = rtrim(trim($prefix), $this->_pfx_connect);
        }
        return $old_prefix;
    }

    /**
    * Prefix
    *
    * 饹СPrefix
    *
    * @param string(&optional)  ץեʸ
    *           - Default:ꤷСPrefix
    * @param bool(&optional)    ץե
    * @return string            СPrefix
    *           - false:ꤷPrefix
    *           - true: եPrefix
    */
    function getPrefix($prefix='', $fieldAdd = false)
    {
        $prefix = $this->prefix;
        return $this->prefix;
    }

    /**
     * Prefix
     *
     * եɡ뤿Prefixʸ
     *
     * @param   string(&optional)   Prefix
     *              - null:饹СѤPrefixѤ
     * @return  string  եɺPrefix
     */
    function makePrefix($prefix = null)
    {
        if (is_null($prefix)) {
            $prefix = $this->getPrefix();
        }
        $prefix = rtrim(trim($prefix), $this->_pfx_connect);
        if ($prefix != '') {
            $prefix .= $this->_pfx_connect;
        }
        return $prefix;
    }

    /**
     * С
     *
     * Ƥ򥯥饹ΥСꤹ
     *
     * @param &object   С륯饹
     * @param mixed[]   եɥꥹ
     * @return &object    object:С
     */
    function &initField(&$object, $fields)
    {
        $prefix = $this->makePrefix();
        foreach ($fields as $id => $v) {
            $field = $prefix . $id;
            $object->$field = null;
        }
        return $object;
    }

    /**
     * С
     *
     * Ƥ򥯥饹ΥСꤹ
     *
     * @param &object   Сꤹ륯饹
     * @param mixed[]   ԡ
     * @param string[]  եɥꥹ
     * @param string(&optional) եPrefix
     * @return bool true:ｪλ/false:̤
     */
    function toField(&$object, &$row, $fields, $prefix='')
    {
        $ret = true;
        $m_pfx = $this->makePrefix();
        $prefix = $this->makePrefix($prefix);
        foreach ($fields as $key => $v) {
            $field = $m_pfx . $key;
            $m_key = $prefix . $key;

            if (isset($row[$m_key])) {
                $object->$field = $row[$m_key];
            } else {
                $object->$field = null;
                $ret = false;
            }
        }
        return $ret;
    }

    /**
     * 
     *
     * Υեɤnullꥢ
     * <sub>ꥢեɤϥեɥꥹȤǻ</sub>
     *
     * @param &mixed[]  եɤ
     * @param string[]  եɥꥹ
     * @param string(&optional) եPrefix
     * @return mixed[]  եɽ
     */
    function initAssoc(&$row, $fieldList, $prefix='')
    {
        $prefix = $this->makePrefix($prefix);
        foreach ($fieldList as $key => $v) {
            $key = $prefix . $key;
            $row[$key] = null;
        }
        return $row;
    }

    /**
     * С
     *
     * Ƥ򥯥饹ΥСꤹ
     */
    function toAssoc(&$object, &$row, $fields, $prefix='')
    {
        $ret = true;
        $m_pfx = $this->makePrefix();
        $prefix = $this->makePrefix($prefix);
        foreach ($fields as $key => $v) {
            $field = $m_pfx . $key;
            $key = $prefix . $key;
            if (empty($object->$field)) {
                $row[$key] = null;
                $ret = false;
            } else {
                $row[$key] = $object->$field;
            }
        }
        return $ret;
    }

    /**
     * 
     *
     * 1ԸѤ˸եɤͤΥڥ
     *
     * @param &object           С֥
     * @param string[]          եɥꥹ
     * @param mixed/string      
     * @param mixed(&optional)   <sub>(ˤϡ2ѥ᡼Ȥʤ)</sub>
     * @return mixed[]  ڥ/agError:
     *      - AGERR_AG_NOKEY    ꤵƤʤ
     */
    function getSearchKey(&$object, $fields, $keyorid='', $id = '')
    {
        $ret = array();
        if (is_string($id))         $id = trim($id);
        if (is_string($keyorid))    $keyorid = trim($keyorid);

        if ($id != '') {
            if (!isset($fields[$keyorid]))      return aglib::raiseError('AGERR_DB_ILLEGALFIELD');
            $ret = array($keyorid => $id);
        } else {
            $key = key($fields);
            if ($keyorid != '') {
                $ret = array($key => $keyorid);
            } else {
                $field = $this->makePrefix() . $key;
                $value = $object->$field;
                $ret = array($key => $value);
            }
        }
        return $ret;
    }
}
?>
