<?php
//
// $Id: dbBase.inc,v 1.2 2005/09/20 07:53:22 atsushifx Exp $
/**
 * DB³ܥ饹
 *
 * DB³³饹륯饹
 * SQLʤɤϤ٤ƤΥ饹̤ƥ褦ˤ
 *
 * @package jp.sf.aglib.db
 *
 * @copyright Copyright &copy; 2004-2005 <a href="http://aglib.sourceforge.jp/">aglib Project</a>
 * @licence http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.2 $
 * @since   1.00
 * @create  2004-05-05
 */
require_once 'aglib.inc';

// PEAR
require_once 'DB.php';
// aglib
require_once 'agOptions.inc';
require_once 'DB/dbo/DBO.inc';

// Database³
if (!defined("DBO_DATABASE")) {
    define("DBO_DATABASE", "mock");
    define("DBO_USER",     "nobody");
    define("DBO_PASSWORD", "nobody");
    define("DBO_HOST",     "localhost");
    define("DBO_DBDB",     "aglib");
}

/**
 * DB³ܥ饹
 *
 * DB³δԤDB³Υåɬ׻DB³ꤹ
 * ǽ󶡤
 *
 * @version 1.00.01
 * @since   1.00
 * @create  2004-01-26
 *
 * @author  Furukaw Atsushi <atsushifx@aglabo.com>
 */
class dbBase {
    /**
    * @access pricate
    * @var agOptions ץ
    */
    var $_opt;

    /**
    * @access pricate
    * @var DBO_xxx DBManager
    */
    var $_dbo = null;

    /**
    * @access private
    * @var DB DB³
    */
    var $_db;

    /**
     * 󥹥ȥ饯
     *
     * db³
     *
     * @access private
     * @param void
     */
    function dbBase()
    {
        $initOptions = array(
            'database'  => DBO_DATABASE,
            'user'      => DBO_USER,
            'password'  => DBO_PASSWORD,
            'host'      => DBO_HOST,
            'dbdb'      => DBO_DBDB,
            'pconnect'  => true,
            '_db' => false,
        );
        $this->_opt = & agOptions::init($initOptions, false, 'ag_dbBase');
        $this->_db = & $this->getOption('_db');
    }

    /**
    * Version
    *
    * dbObject饤֥ΥС
    *
    * @access public
    * @param void
    * @return string    СʥС
    */
    function version()
    {
        return '1.10.03';
    }

    /**
     * ץ
     *
     * @access private
     * @param string ץ̾
     * @param mixed  ץValue (=null)
     * @return mixed()  ץ
     */
    function &setOption($name, $opt=null)
    {
        return $this->_opt->setOption($name, $opt);
    }

    /**
     * ץ
     *
     * @access private
     * @param string ץ̾
     * @param mixed  ץValue (=null)
     * @return mixed()  ץ
     */
    function &getOption($name=null)
    {
        return $this->_opt->getOption($name);
    }

    /**
     * dbo
     *
     * database˱dbo
     *
     * @param string database
     * @return DBO   dbo
     */
    function &dboFactory($database = "")
    {
        if ($database == "") {
            $database = $this->getOption("database");
        }
        $dbo = & DBO::factory($database);
        return $dbo;
    }

    /**
     * DSN
     *
     * ꤷץ󤫤DSN
     *
     * @access private
     * @param void
     * @return string   DSN
     */
    function getDSN()
    {
        $database = $this->getOption('database');
        $user = $this->getOption('user');
        $password = $this->getOption('password');
        $host = $this->getOption('host');
        $db = $this->getOption('dbdb');

        $dsn =$database . '://' . $user;
        if ($password != '')  $dsn .= ':' . $password;
        $dsn .= '@' . $host;
        $dsn .= '/' . $db;
        return $dsn;
    }


    /**
     * DB³å
     *
     * @param void
     * @return true:³Ƥ롿false:³Ƥʤ
     */
    function isConnection()
    {
        $ret = (is_object($this->_db) && is_subclass_of($this->_db, 'DB_common'));
        if ($ret){ $ret = !!$this->_db->connection; }
        return $ret;
    }

    /**
     * dboƥ
     *
     * dboޥ͡㡼Ѥߤå
     *
     * @param  void
     * @return bool true:DBOѤ/false:DBO̤
     *
     */
    function isdboSetted()
    {
        $isobject = is_object($this->_dbo);
        $issubclass = is_subclass_of($this->_dbo, 'DBO');
        return ($isobject && $issubclass);
    }

    /**
     * DB³
     *
     * @param bool  (=null)³Ū³򤹤뤫ɤ
     *              ̤ΤȤϥץŬ
     * @return  DB:³agError:³
     */
    function &connect($pconnect = null)
    {
        if (is_null($pconnect)) {
            $pconnect = $this->getOption('pconnect');
        }
        if (!$this->isdboSetted()) {
            $this->_dbo = & $this->dboFactory();
        }
        if ($this->isConnection()) return $this->_db;
        $dsn = $this->getDSN();
        $db = & DB::connect($dsn, $pconnect);
        if (DB::isError($db))     return $db;
        $db->autoCommit(false);
        $this->_db = $db;
        return $db;
    }

    /**
     * DBǤ
     *
     * @param void
     * @return bool  true:/false:Ǽ
     * @return void
     */
    function disconnect()
    {
        $ret = true;
        if ($this->isConnection()) {
            $ret = $this->_db->disconnect();
            if ($ret) {
                $this->_db =false;
            }
        }
        return $ret;
    }

    /**
     * ե
     *
     * ꤷơ֥Υե
     *
     * @param string  ơ֥̾
     * @return string[] ե
     */
    function getFields($table)
    {
        $table = trim($table);
        if ($table == '') {
            return aglib::raiseError('AGERR_DB_FIELDCANTGET');
        }
        $db = $this->connect();
        if (DB::isError($db))   return $db;
        $list = $this->_dbo->getFields($this->_db, $table);
        return $list;
    }

    /**
     * ʸEscape
     *
     * @param string    ʸ
     * @return string   Escapeʸ
     */
    function escape($str)
    {
        $er = $this->connect();
        if (DB::isError($er))   return $er;
        return $this->_dbo->escape($str);
    }

    /**
     * LikeʸEscape
     *
     * @param string    ʸ
     * @return string   Escapeʸ
     */
    function likeEscape($str)
    {
        $er = $this->connect();
        if (DB::isError($er))   return $er;
        return $this->_dbo->likeEscape($str);
    }

    /**
     * Query¹Ԥ
     *
     * ꤷSQL¹Ԥ
     *
     * @param string    ¹ԤQuery(SQL)
     * @param mixed[]   ɲäǼ¹Ԥѥ᡼
     * @return mix      PEAR::DBˤ¸
     *      - DB_Result:¹(̤)
     *      - DB_Ok:¹
     *      - DB_Error:¹Լ
     */
    function query($query, $params = array())
    {
        $db = &$this->connect();
        if (aglib::isError($db))    return $db;
        $result =  $this->_db->query($query, $params);
        return $result;
    }

    /**
     * DBߥå
     *
     * ȥ󥶥򳫻Ϥ
     *
     * @param void
     * @return DB_OK:commitDB_Error:commit
     */
    function begin()
    {
        return $this->query('begin');
    }

    /**
     * DBߥå
     *
     * ¹ԤSQLcommit
     *
     * @param void
     * @return DB_OK:commitDB_Error:commit
     */
    function commit()
    {
        $db = &$this->connect();
        return  $db->commit();
    }

    /**
     * DBХå
     *
     * @param void
     * @return DB_OK:rollbackDB_Error:rollback
     */
    function rollback()
    {
        $db = &$this->connect();
        return $db->rollback();
    }

    /**
     * 1ɤ߹Query
     *
     * query¹Ԥ̤1Ԥɤ߹
     *
     * @param string    ¹ԤQuery
     * @param mixed[]   ¹Իѥ᡼
     * @param int       ¹Էɤ߹ߥ⡼
     *
     */
    function &getRow($query, $params = array(), $fetchmode = DB_FETCHMODE_DEFAULT)
    {
        $db = &$this->connect();
        if (aglib::isError($db))    return $db;
        return $this->_db->getrow($query, $params, $fetchmode);
    }

    /**
     * getOne
     *
     * Query¹Ԥ̤ǽ1ܤ
     *
     * @param string                ¹ԤQuery
     * @param mixed[](&optional)    ץʥѥ᡼
     * @return mixed                /DB_Error:
     */
    function getOne($query, $params = array())
    {
        $er = &$this->connect();
        if (aglib::isError($er))    return $er;
        return $this->_db->getOne($query, $params);
    }

    function getSequenceName($seq_name)
    {
        $er = &$this->connect();
        if (aglib::isError($er))    return $er;
        return $this->_db->getSequenceName($seq_name);
    }

    function createSequence($seq_name)
    {
        $er = &$this->connect();
        if (aglib::isError($er))    return $er;
        return $this->_db->createSequence($seq_name);
    }

    function dropSequence($seq_name)
    {
        $er = &$this->connect();
        if (aglib::isError($er))    return $er;
        return $this->_db->dropSequence($seq_name);
    }

    function nextId($seq_name, $ondemand = true)
    {
        $er = &$this->connect();
        if (aglib::isError($er))    return $er;
        return $this->_db->nextId($seq_name, $ondemand);
    }

    /**
     * ¸ߥå
     *
     * ꤷSQLιԤ¸ߤ뤫å
     *
     * @param string    ¸ߥåSQL
     * @return bool     true:¸ߡfalse:¸ߤʤ
     */
    function isExist($sql)
    {
        $v = $this->getOne($sql);
        if (DB::isError($v)) {
            $er = false;
        } else {
            $er = ($v != "");
        }
        return $er;
    }

    /**
     * ¸ߥå
     *
     * ꤷSQLιԤ¸ߤ뤫å
     *
     * @param string    ¸ߥåSQL
     * @return bool     true:¸ߡfalse:¸ߤʤ
     */
    function isRowExist($sql)
    {
        $v = $this->getOne($sql);
        if (DB::isError($v)) {
            $er = false;
        } else {
            $er = ($v != "");
        }
        return $er;
    }
}
?>
