<?php
// $Id: dbList.inc,v 1.1 2005/09/20 06:16:36 atsushifx Exp $
//
/**
 * 
 *
 * ꤷơ֥Where礫
 *
 * @package jp.sf.aglib.db
 *
 * @copyright Copyright &copy; 2004-2005 aglib Project
 * @licence http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.1 $
 * @since   1.00
 * @create  2004-05-05
 */
require_once 'aglib.inc';
// aglib
require_once 'DB/dbBase.inc';
require_once 'DB/dbWhere.inc';

/**
 * ڡɽ
 *
 * ꤷڡΰɽSQL
 *
 * @version 1.10
 * @author  Furukaw Atsushi <atsushifx@aglabo.com>
 * @since   1.00
 * @create  2004-05-05
 */
class dbList extends dbBase {
    /**
     * @access private
     * @var string ơ֥(ʣ)
     */
    var $_tables;

    /**
     * @access private
     * @var string ɽ륫
     */
    var $_columns = "*";

    /**
     * @access private
     * @var string orderby
     */
    var $_orderby = "";

    /**
     * @access private
     * @var ơ֥³
     */
    var $_connectors = "";

    /**
    * @access private
    * @var int ơ֥Կ
    */
    var $_rowmax = 0;

    /**
     * @access private
     * @var string SQL¹Ѥwhere
     */
    var $_where = "";

    /**
     * 󥹥ȥ饯
     *
     * @param string            ơ֥̾
     * @param int(&optional)    ڡ(1ԤɽԿ)
     */
    function dbList($tables, $orderby="", $columns="", $connectors="")
    {
        global $ag_dbl_Pagesize;

        $this->dbBase();
        $this->_tables = $tables;
        if ($orderby != '') { $this->_orderby = $orderby; }

        if ($columns == '') { $columns = '*'; }
        $this->_columns = $columns;
        if ($connectors != '') { $this->_connectors = $connectors; }
    }

    /**
     * Version
     *
     * @param void
     * @return string   СNo
     */
    function version()
    {
        return '1.10';
    }

    /**
     * ơ֥ꥹȤơ֥̾
     *
     * @param int   ơֹ֥(1-)
     * @return string   ơ֥̾
     */
    function getTable($no = 1)
    {
        if ($no < 0){   return false; }
        $tableList = explode(",", $this->_tables);
        if ($no > 0) { $no--; }
        if ($no >= count($tableList)){ $no = count($tableList) - 1; }
        $table = trim($tableList[$no]);
        $table = preg_replace("/[ ]+\w+/", "", $table);
        return $table;
    }

    /**
     * Ѥwhereꤹ
     * @param string where
     * @return string where
     */
    function prepare($where)
    {
        $this->_where = $where;
        return $this->_where;
    }

    /**
     * ڡιԤSQLȯԤ
     *
     * @param [string[]]    ѥѥ᡼
     * @return DB_Result    SQL¹Է
     */
    function query($param = null)
    {
        $sql = $this->_makeSql();
        $result = $this->query($sql);
        return $result;
    }

    /**
     * ιԿ
     *
     * @param [string]  SQLwhere
     * @return int ιԿ/false:¹Լ
     */
    function count($param = null)
    {
        $sql = $this->_makeSql("count(*)", $param);
        if(aglib::isError($sql))    return $sql;
        $er = $this->connect();
        if (!$this->connect())      return $er;
        $count = $this->_db->GetOne($sql);
        if (DB::isError($count))    return $count;
        $this->_rowmax = intval($count);
        return $count;
    }

    /**
     * Where -- ҥ饹
     *
     * @abstrct
     * @param [mixed] $param
     * @return string  Where
     */
    function makeWhere($param = null)
    {
        // abstract
        return $param;
    }

    /**
     * SQL
     *
     * @access private
     * @param [string]  ̼ʸ
     * @param [mixed]  ѥѥ᡼
     * @return string SQL
     */
    function _makeSql($columns = "", $param = null)
    {
        if ($this->_tables == '') { return aglib::raiseError('AGERR_DB_NOTABLE'); }

        if ($columns == "") { $columns = $this->_columns; }
        $sql = "select " . $columns . "\n";
        $sql .= "from " . $this->_tables;

        $wh = new dbWhere();
        $where = "";
        $where = $wh->add($where, $this->_connectors);
        $where = $wh->add($where, $this->_where);
        $where = $wh->add($where, $this->makeWhere($param));
        if ($where != "") {
            $sql .= "\nwhere " . $where;
        }
        $is_count = stristr($sql, 'count(');
        if (!$is_count) {
            if ($this->_orderby) {
                $sql .= "\norder by " . $this->_orderby;
            }
        }
        return $sql;
    }
}
?>
