<?php
// $Id: DBO_pgsql.inc,v 1.1 2005/09/20 06:16:36 atsushifx Exp $
/**
 * PostgresDBOޥ͡
 *
 * DBObjectѤPostgresǤΥեɥꥹȼ̾ѴԤ
 *
 * @package jp.sf.aglib.db.dbo
 *
 * @copyright Copyright &copy; 2004-2005 aglib Project
 * @license http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.1 $
 * @since   0.10
 * @create  2004-07-29
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
require_once 'DB/dbo/DBO.inc';

/**
 * postgresDBOޥ͡㥯饹
 *
 * postgresѤ˥桼ƥƥ᥽åɥ饹
 *
 * @version 1.00
 * @since   1.00
 * @create  2004-04-04
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
class DBO_pgsql extends DBO {
    /**
    * ꤷDBơ֥Υեɰ
    */
    function getFields($db, $table)
    {
        $class = 'db_pgsql';
        if (phpversion() >= '5.0.0'){ $class = 'DB_pgsql'; }
        if (!is_object($db) || (get_class($db)!= $class)) return aglib::raiseError('AGERR_DB_ILLEGALDB');
        $table = trim($table);
        $sql = "select attnum, attname, typname, attlen
    from pg_class c, pg_attribute a, pg_type t
    where c.oid = a.attrelid and t.oid=a.atttypid and
                attnum > 0 and
                relname='$table'
    order by attnum";
        $res = $db->Query($sql);
        if (DB::isError($res))  return $res;
        $fields = array();
        while ($row = $res->FetchRow(DB_FETCHMODE_ASSOC)) {
            $key = $row["attname"];
            $type = $this->convertType($row["typname"], $row["attlen"]);
            if (!$type)  return aglib::raiseError('AGERR_DB_TYPEUNDEF'); // Unknown Data Type
            $fields[$key] = $type;
        }
        if ($fields == array())  return aglib::raiseError('AGERR_DB_FIELDCANTGET');
        return $fields;
    }

    /**
    * ̾DB̤Υ̾Ѵ
    * @param string ̾(DB)
    * @param integer ǡ
    * @return string ̾(DB)
    */
    function convertType($type_org, $len)
    {
        $type = null;
        switch ($type_org){
        case "bool":
        case "boolean":
            $type = AGDB_TYPE_BOOL;
            break;
        case "int":
        case "int2":
        case "int4":
        case "int8":
            if ($len == 1) {
                $type = AGDB_TYPE_BOOL;
            } else {
                $type = AGDB_TYPE_INT;
            }
            break;

        case 'decimal':
        case 'money':
        case 'numeric':
            $type = AGDB_TYPE_CURRENCY;
            break;

        case "text":
        case "char":
        case "varchar":
            $type = AGDB_TYPE_STRING;
            break;

        case "date":
            $type = AGDB_TYPE_DATE;
            break;

        case "time":
        case "timetz":
            $type = AGDB_TYPE_TIME;
            break;

        case 'datetime':
        case 'timestamp':
        case 'timestamptz':
            $type = AGDB_TYPE_DATETIME;
            break;

        case 'float':
        case 'double':
        case 'real':
            $type = AGDB_TYPE_REAL;
            break;

        default:
            $type = false;
        }
        return $type;
    }

    /**
     * ʸEscape
     *
     * SQLѤʸEscape
     *
     * @param string    Escapeʸ
     * @return string   Escapeʸ
     */
    function escape($str)
    {
        if (is_null($str))  return NULL;
        $esStr = pg_escape_string($str);
        return $esStr;
    }
}
?>
