/*
 * header file for fontset.c
 *
 * $Id: fontset.h,v 1.3 2002/03/26 10:46:59 taka Exp $
 */
#ifndef FONTSET_H_INCLUDED
#define FONTSET_H_INCLUDED

#define DEFAULT_FONTSETNAME "-misc-fixed-medium-r-normal--14-130-75-75-*-*--*"
struct fontsetentry;

struct fontsetentry*
fontset_get_byname (Display* d, const char* fontsetname);
void
fontset_release (struct fontsetentry* f);
struct fontsetentry*
fontset_duplicate (struct fontsetentry* f);
XFontSet
fontset_get_xfontset (struct fontsetentry* f);
XFontSetExtents*
fontset_get_xfontsetextents (struct fontsetentry* f);
char*
fontset_get_fontsetname (struct fontsetentry* f);

int
fontset_initialize_module (Display* d);
void
fontset_destroy_module (void);

#endif /* FONTSET_H_INCLUDED */

