/*
 * header file of hotkeys.c
 *
 * $Id: hotkeys.h,v 1.11 2002/03/26 10:46:59 taka Exp $
 */

#ifndef HOTKEYS_H_INCLUDED
#define HOTKEYS_H_INCLUDED

#include <X11/Xlib.h>

enum
{
	HOT_KEYS_ASCII,		/* hanakaku mode (default: C-l) */
	HOT_KEYS_HIRAGANA,	/* hiragana mode (default: C-j) */
	HOT_KEYS_KATAKANA,	/* katakana mode (default: none) */
	HOT_KEYS_ZENKAKU_ASCII,	/* zenkaku-ascii mode (default: none) */
	HOT_KEYS_KANA,		/* kana mode     (default: none) */
	HOT_KEYS_HENKAN,	/* henkan mode   (default: Space) */
	HOT_KEYS_CANCEL,	/* cancel        (default: Escape) */
	HOT_KEYS_BACKSPACE,	/* back space    (default: Backspace) */
	HOT_KEYS_DELETE,	/* delete        (default: C-d) */
	HOT_KEYS_COMMIT,	/* commit        (default: Return) */
	HOT_KEYS_ON,            /* ime on        (default: Alt-Esc) */
	HOT_KEYS_LEFT,		/* cursor left   (default: left cursor) */
	HOT_KEYS_RIGHT,		/* cursor right  (default: right cursor) */
	HOT_KEYS_FIRST,		/* cursor first  (default: C-a) */
	HOT_KEYS_LAST,		/* cursor last   (default: C-e) */
	HOT_KEYS_GROW,          /* grow phrase (default: shift right cursor) */
	HOT_KEYS_SHRINK,        /* shrink phrase(default: shift left cursor) */
	HOT_KEYS_ON_OR_COMMIT,  /* ime on or commit (C-j) */
	HOT_KEYS_CAND_NEXT,	/* next candidate (default: Down) */
	HOT_KEYS_CAND_PREV,	/* prev candidate (default: Up) */

	HOT_KEYS_KEY,           /* key input for conversion. unused at table */
	HOT_KEYS_TYPE_NUM,
};

struct hotkeys*
hotkeys_allocate (void);
void
hotkeys_destroy (struct hotkeys* hk);

int
hotkeys_add_entry (struct hotkeys* hk, int hktype, int state, KeySym ksym);
int
hotkeys_get_type (struct hotkeys* hk, int state, KeySym ksym);
void
hotkeys_removeall (struct hotkeys* hk);
int
setkey_func (const char* buf);
void
load_setkey_default (void);

#endif /* HOTKEYS_H_INCLUDED */
