/*
 * imconnection header
 *
 * $Id: imconnection.h,v 1.10 2001/09/12 23:24:54 taka Exp $
 */
#ifndef IMCONNECTION_H_INCLUDED
#define IMCONNECTION_H_INCLUDED

enum {
	XIM_CONNECT                    = 1,
	XIM_CONNECT_REPLY              = 2,
	XIM_DISCONNECT                 = 3,
	XIM_DISCONNECT_REPLY           = 4,
	XIM_AUTH_REQUIRED              = 10,
	XIM_AUTH_REPLY                 = 11,
	XIM_AUTH_NEXT                  = 12,
	XIM_AUTH_SETUP                 = 13,
	XIM_AUTH_NG                    = 14,
	XIM_ERROR                      = 20,
	XIM_OPEN                       = 30,
	XIM_OPEN_REPLY                 = 31,
	XIM_CLOSE                      = 32,
	XIM_CLOSE_REPLY                = 33,
	XIM_REGISTER_TRIGGERKEYS       = 34,
	XIM_TRIGGER_NOTIFY             = 35,
	XIM_TRIGGER_NOTIFY_REPLY       = 36,
	XIM_SET_EVENT_MASK             = 37,
	XIM_ENCODING_NEGOTIATION       = 38,
	XIM_ENCODING_NEGOTIATION_REPLY = 39,
	XIM_QUERY_EXTENSION            = 40,
	XIM_QUERY_EXTENSION_REPLY      = 41,
	XIM_SET_IM_VALUES              = 42,
	XIM_SET_IM_VALUES_REPLY        = 43,
	XIM_GET_IM_VALUES              = 44,
	XIM_GET_IM_VALUES_REPLY        = 45,
	XIM_CREATE_IC                  = 50,
	XIM_CREATE_IC_REPLY            = 51,
	XIM_DESTROY_IC                 = 52,
	XIM_DESTROY_IC_REPLY           = 53,
	XIM_SET_IC_VALUES              = 54,
	XIM_SET_IC_VALUES_REPLY        = 55,
	XIM_GET_IC_VALUES              = 56,
	XIM_GET_IC_VALUES_REPLY        = 57,
	XIM_SET_IC_FOCUS               = 58,
	XIM_UNSET_IC_FOCUS             = 59,
	XIM_FORWARD_EVENT              = 60,

	XIM_SYNC                       = 61,
	XIM_SYNC_REPLY                 = 62,
	XIM_COMMIT                     = 63,
	XIM_RESET_IC                   = 64,

	XIM_RESET_IC_REPLY             = 65,
	XIM_GEOMETRY                   = 70,
	XIM_STR_CONVERSION             = 71,
	XIM_STR_CONVERSION_REPLY       = 72,
	XIM_PREEDIT_START              = 73,
	XIM_PREEDIT_START_REPLY        = 74,
	XIM_PREEDIT_DRAW               = 75,
	XIM_PREEDIT_CARET              = 76,
	XIM_PREEDIT_CARET_REPLY        = 77,
	XIM_PREEDIT_DONE               = 78,
	XIM_STATUS_START               = 79,
	XIM_STATUS_DRAW                = 80,
	XIM_STATUS_DONE                = 81,
	XIM_PREEDITSTATE               = 82,

	XIM_EXT_SET_EVENT_MASK         = 129,
	XIM_EXT_FORWARD_KEYEVENT       = 130,
	XIM_EXT_MOVE                   = 131,

	XIM_DISPATCHER_MAX             = 132,
};

enum {
	XIM_ERROR_BADALLOC        = 1,
	XIM_ERROR_BADSTYLE        = 2,
	XIM_ERROR_BADCLIENTWINDOW = 3,
	XIM_ERROR_BADFOCUSWINDOW  = 4,
	XIM_ERROR_BADPROTOCOL     = 13,
	XIM_ERROR_BADSOMETHING    = 999,
};

enum {
	IMC_STATE_INIT,
	IMC_STATE_CLOSE,		/* need to be closed */
};

#include "queue.h"
#define XTRANSPORT_UNIT_SIZE (20)
#define XTRANSPORT_SIZE (XTRANSPORT_UNIT_SIZE * 5)
#define IMC_BUFFER_SIZE	1024
struct imconnection
{
	Display*	display;
	Window		clientwindow;
	Window		comwindow;	/* communication window */
	int		state;

	unsigned char	buffer[IMC_BUFFER_SIZE];
	unsigned int	buffer_len;
	int		byte_order;

	int		major_protocol;
	int		minor_protocol;

	int (*dispatch) (struct imconnection*);

	SIMPLEQ_HEAD (,ximpacket)	packetlist;	/* output buffer */
	SLIST_HEAD   (,ximim)		imlist;

	SLIST_ENTRY (imconnection)	entry;
};

struct imconnection*
imc_allocate (void);
void
imc_free (struct imconnection* p);
Window
imc_comwindow (struct imconnection* p);
void
imc_init (struct imconnection* imc, Display* d, Window p, Window cl);
int
imc_xevent (struct imconnection* imc, XEvent* e);
int
imc_module_initialize (void);
void
imc_send_packets (struct imconnection* imc);

struct imrequest
{
	const char*	name;
	int		major;
	int		minor;
	int (*proc)(struct imconnection*, int major, int minor, int len);
};
struct imrequest*
get_extrequest_table (void);

#endif /* IMCONNECTION_H_INCLUDED */
