/*
 * header file of ximic.c
 *
 * $Id: ximic.h,v 1.10 2001/09/19 21:48:16 taka Exp $
 */
#ifndef XIMIC_H_INCLUDED
#define XIMIC_H_INCLUDED
#include <X11/Intrinsic.h>
#include "queue.h"
#include "pewindow.h"

enum
{
	INVALID       = 0,
	ROOT_WINDOW   = 1,
	OVER_THE_SPOT = 2,
	ON_THE_SPOT   = 3,
	OFF_THE_SPOT  = 4,
	INPUT_TYPE_NUM = 5,
};
enum {
	ATTR_MASK_INPUT_STYLE   = 1 << 0,	/* 0x0001 */
	ATTR_MASK_CLIENT_WINDOW = 1 << 1,	/* 0x0002 */
	ATTR_MASK_FOCUS_WINDOW  = 1 << 2,	/* 0x0004 */
	ATTR_MASK_FOREGROUND    = 1 << 3,	/* 0x0008 */
	ATTR_MASK_BACKGROUND    = 1 << 4,	/* 0x0010 */
	ATTR_MASK_AREA          = 1 << 5,	/* 0x0020 */
	ATTR_MASK_AREA_NEEDED   = 1 << 6,	/* 0x0040 */
	ATTR_MASK_LINE_SPACE    = 1 << 7,	/* 0x0080 */
	ATTR_MASK_SPOT_LOCATION = 1 << 8,	/* 0x0100 */
	ATTR_MASK_FONTSET       = 1 << 9,	/* 0x0200 */
	ATTR_MASK_STATUS_AREA   = 1 << 10,	/* 0x0400 */
};
/* ps means Preedit and Status */
struct ps_attribute
{
	unsigned int set_mask;
	unsigned int changed_mask;
	
	Pixel foreground;
	Pixel background;
	XRectangle area;
	XRectangle area_needed;
	short line_space;
	XPoint spot_location;
	struct fontsetentry* fontset;
};

struct common_attribute
{
	int	set_mask;
	int	changed_mask;

	int	input_style;
	Window	client_window;
	Window	focus_window;

	int	client_width;
	int	client_height;
	int	focus_width;
	int	focus_height;
};

struct ximic
{
	int	imid;	/* duplicated value */
	int	icid;
	struct imconnection* imc;	/* where do I belong to? */

	struct common_attribute	common_attr;
	struct ps_attribute	preedit_attr;
	struct ps_attribute	status_attr;

	struct conversion*	conv;
	struct pewindow*	pew;
	int	isfocused;

	SLIST_ENTRY (ximic)	entry;
};
struct ximim
{
	int	imid;
	SLIST_HEAD (,ximic)	iclist;

	SLIST_ENTRY (ximim)	entry;
};

int
ximim_im_putattributes (struct ximpacket* x, int type);
int
ximim_im_get_values (struct ximpacket* x, char* data, int len, int border);
int
ximic_ic_putattributes (struct ximpacket* x, int type);
void
ximic_make_peattribute (struct ximic* xic, struct pe_attribute* merged);
int
ximic_ic_set_attributes (struct ximic* xmc, struct ximpacket* x, char* data,
			 int len, int btype);
int
ximic_ic_get_attributes (struct ximic* xic, struct ximpacket* x, char* data,
			 int len, int border);

struct ximic*
ximim_allocate_ic (struct ximim* xim, struct imconnection* imc);
void
ximim_destroy_ic (struct ximim* xim, struct ximic* xic);
struct ximic*
ximim_search_ximic (struct ximim* xim, int icid);
struct ximim*
ximim_allocate (void);
void
ximim_destroy (struct ximim* x);

#endif /* XIMIC_H_INCLUDED */
