/*
 * deal XIM Packet
 *
 * $Id: ximpacket.c,v 1.10 2002/03/26 10:47:00 taka Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "imconnection.h"
#include "ximpacket.h"
#include "byteorder.h"
#include "aime.h"

#define XIMPACKET_UNIT_SIZE	32

void
ximpacket_init (struct ximpacket* x)
{
	x->buffer      = NULL;
	x->buffer_size = 0;
	x->buffer_len  = 0;
}

struct ximpacket*
ximpacket_allocate (void)
{
	struct ximpacket* p;
	p = malloc (sizeof (struct ximpacket));
	if (p == NULL) {
		NOMEMORY ("can't allocate ximpacket");
		return NULL;
	}
	ximpacket_init (p);
	return p;
}

void
ximpacket_destroy (struct ximpacket* x)
{
	if (!x) return;
	free (x->buffer);
	free (x);
}

void
ximpacket_init_buffer (struct ximpacket* x)
{
	x->buffer_len = 0;
}

static int
add_buffer (struct ximpacket* x, int size)
{
	int newsize = x->buffer_len + size;
	if (newsize > x->buffer_size) {
		/* round up */
		char* newaddr;

		newsize = (newsize +  XIMPACKET_UNIT_SIZE - 1)
			/ XIMPACKET_UNIT_SIZE * XIMPACKET_UNIT_SIZE;
		newaddr = realloc (x->buffer, newsize);

		if (newaddr == NULL) return -1;

		x->buffer      = newaddr;
		x->buffer_size = newsize;
	}
	return 0;
}

int
ximpacket_put8 (struct ximpacket* x, int data, int type)
{
	int ret;
	ret = add_buffer (x, 1);
	if (ret == -1) return -1;

	put8 (x->buffer + x->buffer_len, data, type);
	x->buffer_len += 1;
	return 0;
}

int
ximpacket_put16 (struct ximpacket* x, int data, int type)
{
	int ret;
	ret = add_buffer (x, 2);
	if (ret == -1) return -1;

	put16 (x->buffer + x->buffer_len, data, type);
	x->buffer_len += 2;
	return 0;
}

int
ximpacket_put32 (struct ximpacket* x, int data, int type)
{
	int ret;
	ret = add_buffer (x, 4);
	if (ret == -1) return -1;

	put32 (x->buffer + x->buffer_len, data, type);
	x->buffer_len += 4;
	return 0;
}

int
ximpacket_reput16 (struct ximpacket* x, int data, int offset, int type)
{
	put16 (x->buffer + offset, data, type);
	return 0;
}

int
ximpacket_putbytes (struct ximpacket* x, const char* msg, int len, int type)
{
	int ret;
	if (!msg) return 0;

	if (!len) len = strlen (msg);

	ret = add_buffer (x, len);
	if (ret == -1) return -1;

	memcpy (x->buffer + x->buffer_len, msg, len);
	x->buffer_len += len;
	return 0;
}

int
ximpacket_simple_request (struct ximpacket* x, int major, int minor)
{
	/* no need to fille byte order with valid value */
	int ret = 0;
	ret |= ximpacket_put8 (x, major, 0);
	ret |= ximpacket_put8 (x, minor, 0);
	ret |= ximpacket_put16 (x, 0, 0);

	return ret;
}

int
ximpacket_putheader (struct ximpacket* x, int major, int minor, int len,
		     int type)
{
	int ret = 0;
	len = (len + 3) / 4;

	ret |= ximpacket_put8  (x, major, type);
	ret |= ximpacket_put8  (x, minor, type);
	ret |= ximpacket_put16 (x, len, type);

	return ret;
}

void
ximpacket_rewritelen (struct ximpacket* x, int type)
{
	int len = x->buffer_len - 4;
	len = (len + 3) / 4;
	if (!x->buffer) return;
	put16 (x->buffer + 2, len, type);
}

int
ximpacket_putpad (struct ximpacket* x, int len)
{
	int ret;
	int padlen;

	padlen = (4 - (len % 4)) % 4;

	if (!padlen) return 0;

	ret = add_buffer (x, padlen);
	if (ret == -1) return -1;

	memset (x->buffer + x->buffer_len, 0, padlen);
	x->buffer_len += padlen;
	return 0;
}
int
ximpacket_error_packet (struct ximpacket* x, int errorcode, int imid, int icid,
			const char* msg, int border)
{
	int msg_len = 0;
	int validflg = 0;
	int ret = 0;

	if (msg) msg_len = strlen (msg);
	if (imid != 0) validflg |= 1;
	if (icid != 0) validflg |= 2;

	ret |= ximpacket_putheader (x, XIM_ERROR, 0, 0, border);
	ret |= ximpacket_put16 (x, imid, border);	/* imid */
	ret |= ximpacket_put16 (x, icid, border);	/* icid */

	ret |= ximpacket_put16 (x, validflg, border);	/*i[m|c]id is invalid*/
	ret |= ximpacket_put16 (x, errorcode, border);

	ret |= ximpacket_put16 (x, msg_len, border);
	ret |= ximpacket_put16 (x, 0, border);	/* reserved for future use */

	ret |= ximpacket_putbytes (x, msg, msg_len, border);
	ret |= ximpacket_putpad (x, msg_len);
	if (ret == 0) ximpacket_rewritelen (x, border);

	return ret;
}

int
ximpacket_position (struct ximpacket* x)
{
	return x->buffer_len;
}
