/*
 * header of ximpacket.c
 *
 * $Id: ximpacket.h,v 1.9 2002/03/26 10:47:00 taka Exp $
 */
#ifndef XIMPACKET_H_INCLUDED
#define XIMPACKET_H_INCLUDED
#include "queue.h"
struct ximpacket
{
	char*		buffer;
	unsigned long	buffer_size;
	unsigned long	buffer_len;

	SIMPLEQ_ENTRY (ximpacket)	entry;
};

void
ximpacket_init (struct ximpacket* x);
struct ximpacket*
ximpacket_allocate (void);
void
ximpacket_destroy (struct ximpacket* x);
void
ximpacket_init_buffer (struct ximpacket* x);

int
ximpacket_put8 (struct ximpacket* x, int data, int type);
int
ximpacket_put16 (struct ximpacket* x, int data, int type);
int
ximpacket_put32 (struct ximpacket* x, int data, int type);
int
ximpacket_reput16 (struct ximpacket* x, int data, int offset, int type);
int
ximpacket_putbytes (struct ximpacket* x, const char* msg, int len, int type);

int
ximpacket_simple_request (struct ximpacket* x, int major, int minor);
int
ximpacket_putheader (struct ximpacket* x, int major, int minor, int len,
		     int type);
void
ximpacket_rewritelen (struct ximpacket* x, int type);
int
ximpacket_putpad (struct ximpacket* x, int len);
int
ximpacket_error_packet (struct ximpacket* x, int errorcode, int imid, int icid,
			const char* msg, int border);
int
ximpacket_position (struct ximpacket* x);

#endif /* XIMPACKET_H_INCLUDED */
