/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.AfterHoliday;
import ajd4jp.EquinoxHoliday;
import ajd4jp.FixHoliday;
import ajd4jp.HolidayType;
import ajd4jp.Holy;
import ajd4jp.Mid;
import ajd4jp.Month;
import ajd4jp.MoveHoliday;
import ajd4jp.OffProvider;
import ajd4jp.Sunday;
import ajd4jp.Week;
import ajd4jp.format.Formats;
import java.util.ArrayList;
import java.util.HashMap;

public enum Holiday implements OffProvider.Off
{
    GANZITU(new FixHoliday("\u5143\u65e5", null, null, new Holy(1, 1, 1))),
    GENSHI(new FixHoliday("\u5143\u59cb\u796d", null, new Holy(1948, 1, 3))),
    SHINNEN(new FixHoliday("\u65b0\u5e74\u5bb4\u4f1a", null, new Holy(1948, 1, 5))),
    SEIJIN(new FixHoliday("\u6210\u4eba\u306e\u65e5", new Holy(1949, 1, 15), new Holy(1999, 1, 15)), new MoveHoliday("\u6210\u4eba\u306e\u65e5", new Holy(2000, 1, 1), null, 1, 2, Week.MONDAY)),
    KOMEI(new FixHoliday("\u5b5d\u660e\u5929\u7687\u796d", null, new Holy(1912, 1, 30))),
    KENKOKU(new FixHoliday("\u7d00\u5143\u7bc0", null, new Holy(1948, 2, 11)), new FixHoliday("\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5", new Holy(1967, 2, 11), null)),
    SHUNBUN(new EquinoxHoliday("\u6625\u5b63\u7687\u970a\u796d", new Holy(1879, 3, 21), new Holy(1948, 3, 21), 0), new EquinoxHoliday("\u6625\u5206\u306e\u65e5", new Holy(1949, 3, 21), null, 0)),
    JINMU(new FixHoliday("\u795e\u6b66\u5929\u7687\u796d", null, new Holy(1948, 4, 3))),
    SHOWA(new FixHoliday("\u5929\u9577\u7bc0", new Holy(1927, 4, 29), new Holy(1948, 4, 29)), new FixHoliday("\u5929\u7687\u8a95\u751f\u65e5", new Holy(1949, 4, 29), new Holy(1988, 4, 29)), new FixHoliday("\u662d\u548c\u306e\u65e5", new Holy(2007, 4, 29), null)),
    KENPO(new FixHoliday("\u61b2\u6cd5\u8a18\u5ff5\u65e5", new Holy(1949, 5, 3), null)),
    MIDORI(new FixHoliday("\u307f\u3069\u308a\u306e\u65e5", new Holy(1989, 4, 29), new Holy(2006, 4, 29)), new FixHoliday("\u307f\u3069\u308a\u306e\u65e5", new Holy(2007, 5, 4), null)),
    KODOMO(new FixHoliday("\u3053\u3069\u3082\u306e\u65e5", new Holy(1949, 5, 5), null)),
    UMI(new FixHoliday("\u6d77\u306e\u65e5", new Holy(1996, 7, 20), new Holy(2002, 7, 20)), new MoveHoliday("\u6d77\u306e\u65e5", new Holy(2003, 1, 1), null, 7, 3, Week.MONDAY)),
    MEIJI(new FixHoliday("\u660e\u6cbb\u5929\u7687\u796d", new Holy(1913, 7, 30), new Holy(1926, 7, 30))),
    YAMA(new FixHoliday("\u5c71\u306e\u65e5", new Holy(2016, 8, 11), null)),
    TAISHO(new FixHoliday("\u5929\u9577\u7bc0", new Holy(1913, 8, 31), new Holy(1926, 8, 31))),
    KEIRO(new FixHoliday("\u656c\u8001\u306e\u65e5", new Holy(1966, 9, 15), new Holy(2002, 9, 15)), new MoveHoliday("\u656c\u8001\u306e\u65e5", new Holy(2003, 9, 15), null, 9, 3, Week.MONDAY)),
    KANNAME(new FixHoliday("\u795e\u5617\u796d", null, new Holy(1878, 9, 17)), new FixHoliday("\u795e\u5617\u796d", new Holy(1879, 10, 17), new Holy(1947, 10, 17))),
    SHUBUN(new EquinoxHoliday("\u79cb\u5b63\u7687\u970a\u796d", new Holy(1878, 9, 23), new Holy(1947, 9, 23), 180), new EquinoxHoliday("\u79cb\u5206\u306e\u65e5", new Holy(1948, 9, 23), null, 180)),
    TAIIKU(new FixHoliday("\u4f53\u80b2\u306e\u65e5", new Holy(1966, 10, 10), new Holy(1999, 10, 10)), new MoveHoliday("\u4f53\u80b2\u306e\u65e5", new Holy(2000, 1, 1), null, 10, 2, Week.MONDAY)),
    TAISHO2(new FixHoliday("\u5929\u9577\u7bc0\u795d\u65e5", new Holy(1913, 10, 31), new Holy(1926, 10, 31))),
    BUNKA(new FixHoliday("\u5929\u9577\u7bc0", null, new Holy(1911, 11, 3)), new FixHoliday("\u660e\u6cbb\u7bc0", new Holy(1927, 11, 3), new Holy(1947, 11, 3)), new FixHoliday("\u6587\u5316\u306e\u65e5", new Holy(1948, 11, 3), null)),
    KINRO(new FixHoliday("\u65b0\u5617\u796d", null, new Holy(1947, 11, 23)), new FixHoliday("\u52e4\u52b4\u611f\u8b1d\u306e\u65e5", new Holy(1948, 11, 23), null)),
    HEISEI(new FixHoliday("\u5929\u7687\u8a95\u751f\u65e5", new Holy(1989, 12, 23), new Holy(2018, 12, 23))),
    TAISHO3(new FixHoliday("\u5927\u6b63\u5929\u7687\u796d", new Holy(1927, 12, 25), new Holy(1947, 12, 25))),
    SOKUI(new FixHoliday("\u5373\u4f4d\u306e\u793c", new Holy(1915, 11, 10)), new FixHoliday("\u5373\u4f4d\u306e\u793c", new Holy(1928, 11, 10)), new FixHoliday("\u5929\u7687\u306e\u5373\u4f4d\u306e\u65e5", new Holy(2019, 5, 1))),
    ONIE(new FixHoliday("\u5927\u5617\u796d", new Holy(1915, 11, 14)), new FixHoliday("\u5927\u5617\u796d", new Holy(1928, 11, 14))),
    DAIKYO1(new FixHoliday("\u5927\u9957\u7b2c\u4e00\u65e5", new Holy(1915, 11, 16)), new FixHoliday("\u5927\u9957\u7b2c\u4e00\u65e5", new Holy(1928, 11, 16))),
    EMP1959(new FixHoliday("\u660e\u4ec1\u89aa\u738b\u306e\u7d50\u5a5a\u306e\u5100", new Holy(1959, 4, 10))),
    EMP1989(new FixHoliday("\u662d\u548c\u5929\u7687\u306e\u5927\u55aa\u306e\u793c", new Holy(1989, 2, 24))),
    EMP1990(new FixHoliday("\u5373\u4f4d\u306e\u793c\u6b63\u6bbf\u306e\u5100", new Holy(1990, 11, 12))),
    EMP1993(new FixHoliday("\u5fb3\u4ec1\u89aa\u738b\u306e\u7d50\u5a5a\u306e\u5100", new Holy(1993, 6, 9))),
    EMP2019(new FixHoliday("\u5373\u4f4d\u306e\u793c\u6b63\u6bbf\u306e\u5100\u306e\u884c\u308f\u308c\u308b\u65e5", new Holy(2019, 10, 22))),
    FURIKAE(new Sunday()),
    KOKUMIN(new Mid());

    private HolidayType[] type;
    private static HashMap<Integer, Holy[]> list;

    private Holiday(HolidayType ... hd) {
        this.type = hd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Holy[] build(int yyyy) throws AJDException {
        Holiday[] hd = Holiday.values();
        HashMap<Integer, Holy[]> hashMap = list;
        synchronized (hashMap) {
            Holy[] dim = list.get(yyyy);
            if (dim != null) {
                return dim;
            }
            ArrayList<Holy> tmp = new ArrayList<Holy>();
            for (int i = 0; i < hd.length; ++i) {
                Holy[] ret;
                if (hd[i].type[0] instanceof AfterHoliday || (ret = HolidayType.select(yyyy, hd[i], hd[i].type)) == null) continue;
                for (int j = 0; j < ret.length; ++j) {
                    tmp.add(ret[j]);
                }
            }
            if (tmp.size() == 0) {
                dim = new Holy[]{};
                list.put(yyyy, dim);
                return dim;
            }
            Holy[][] mon = new Holy[12][];
            for (int i = 0; i < mon.length; ++i) {
                mon[i] = new Month(yyyy, i + 1).getHolis();
            }
            for (Holy h : tmp) {
                mon[h.getMonth() - 1][h.getDay() - 1].set(h.getHoliday());
            }
            tmp = new ArrayList();
            for (int i = 0; i < mon.length; ++i) {
                Holy[] h = mon[i];
                int n = h.length;
                for (int j = 0; j < n; ++j) {
                    Holy h2 = h[j];
                    tmp.add(h2);
                }
            }
            AfterHoliday[] aft = new AfterHoliday[]{(AfterHoliday)((Object)Holiday.FURIKAE.type[0]), (AfterHoliday)((Object)Holiday.KOKUMIN.type[0])};
            dim = tmp.toArray(new Holy[0]);
            for (int i = 0; i < aft.length; ++i) {
                aft[i].set(dim);
                Holy[] ret = HolidayType.select(yyyy, i == 0 ? FURIKAE : KOKUMIN, i == 0 ? Holiday.FURIKAE.type : Holiday.KOKUMIN.type);
                if (ret == null) continue;
                for (int j = 0; j < ret.length; ++j) {
                    mon[ret[j].getMonth() - 1][ret[j].getDay() - 1].set(ret[j].getHoliday());
                }
            }
            tmp = new ArrayList();
            for (Holy h2 : dim) {
                if (h2.getHoliday() == null) continue;
                tmp.add(h2);
            }
            dim = tmp.toArray(new Holy[0]);
            list.put(yyyy, dim);
            return dim;
        }
    }

    public static Holiday getHoliday(AJD ajd) {
        Holy[] ret = null;
        try {
            ret = Holiday.build(ajd.getYear());
        }
        catch (AJDException aJDException) {
            // empty catch block
        }
        for (Holy h : ret) {
            if (h.getMonth() != ajd.getMonth() || h.getDay() != ajd.getDay()) continue;
            return h.getHoliday();
        }
        return null;
    }

    public String getName(AJD ajd) {
        HolidayType t;
        String name = null;
        if (this != Holiday.getHoliday(ajd)) {
            return null;
        }
        HolidayType[] holidayTypeArray = this.type;
        int n = holidayTypeArray.length;
        for (int i = 0; i < n && (name = (t = holidayTypeArray[i]).getName(ajd.getYear())) == null; ++i) {
        }
        return name;
    }

    public static AJD[] getHoliday(int yyyy) throws AJDException {
        ArrayList<AJD> list = new ArrayList<AJD>();
        AJD day = new AJD(yyyy, 1, 1);
        while (day.getYear() == yyyy) {
            if (Holiday.getHoliday(day) != null) {
                list.add(day);
            }
            day = day.addDay(1);
        }
        return list.toArray(new AJD[0]);
    }

    public static void main(String[] argv) throws Exception {
        for (AJD ajd : Holiday.getHoliday(Integer.parseInt(argv[0]))) {
            System.out.print(Formats.DATE.toString(ajd));
            System.out.print("\t");
            System.out.println(Holiday.getHoliday(ajd).getName(ajd));
        }
    }

    static {
        list = new HashMap();
    }
}

