/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery;

import ajd4jp.AJDException;
import ajd4jp.orrery.Angle;
import ajd4jp.orrery.Dim3;
import ajd4jp.orrery.ETD;
import ajd4jp.orrery.Planet;
import ajd4jp.orrery.Raw;
import ajd4jp.orrery.tool.JPLItem;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class Pole
implements Serializable {
    private BigDecimal p;
    private BigDecimal l;
    private static final BigDecimal E84381 = new BigDecimal(84381.406);
    private static final BigDecimal E46 = new BigDecimal(46.836769);
    private static final BigDecimal E59 = new BigDecimal(5.9E-4);
    private static final BigDecimal E1819 = new BigDecimal(0.001813);
    private static final BigDecimal SEC = new BigDecimal(648000);
    private static final Angle[][] ECS = new Angle[][]{{new Angle(2306.2181, Angle.Unit.SECOND), new Angle(0.30188, Angle.Unit.SECOND), new Angle(0.017998, Angle.Unit.SECOND)}, {new Angle(2004.3109, Angle.Unit.SECOND), new Angle(-0.42665, Angle.Unit.SECOND), new Angle(-0.041833, Angle.Unit.SECOND)}, {new Angle(2306.2181, Angle.Unit.SECOND), new Angle(1.09468, Angle.Unit.SECOND), new Angle(0.018203, Angle.Unit.SECOND)}};
    private static final Angle A90 = new Angle(90, Angle.Unit.DEGREE);
    private static final Angle A_90 = new Angle(-90, Angle.Unit.DEGREE);
    private static final Angle[] AX = new Angle[]{new Angle(84381.406, Angle.Unit.SECOND), new Angle(-46.836769, Angle.Unit.SECOND), new Angle(-5.9E-4, Angle.Unit.SECOND), new Angle(0.001813, Angle.Unit.SECOND)};

    private static BigDecimal sin(BigDecimal a) {
        return new BigDecimal(Math.sin(a.doubleValue()));
    }

    private static BigDecimal cos(BigDecimal a) {
        return new BigDecimal(Math.cos(a.doubleValue()));
    }

    private static BigDecimal atan2(BigDecimal a, BigDecimal b) {
        return new BigDecimal(Math.atan2(a.doubleValue(), b.doubleValue()));
    }

    private static BigDecimal sqrt(BigDecimal a) {
        return new BigDecimal(Math.sqrt(a.doubleValue()));
    }

    private Pole() {
        this.l = this.p = BigDecimal.ZERO;
    }

    private Pole(BigDecimal x, BigDecimal y, BigDecimal z) {
        this.l = Pole.atan2(y, x);
        this.p = Pole.atan2(z, Pole.sqrt(x.pow(2).add(y.pow(2))));
    }

    private static Angle mean(Angle[] param, BigDecimal[] uc) {
        BigDecimal ret = BigDecimal.ZERO;
        for (int i = 0; i < 3; ++i) {
            ret = ret.add(param[i].h.multiply(uc[i]));
        }
        return new Angle(ret, Angle.Unit.SECOND);
    }

    private static Dim3 mean(Dim3 org, BigDecimal[] uc) {
        Dim3 ret = org;
        ret = ret.rotateZ(A90.subtract(Pole.mean(ECS[0], uc)));
        ret = ret.rotateX(Pole.mean(ECS[1], uc));
        ret = ret.rotateZ(A_90.subtract(Pole.mean(ECS[2], uc)));
        return ret;
    }

    private static Angle axial(BigDecimal[] uc) {
        BigDecimal ret = Pole.AX[0].h;
        ret = ret.add(Pole.AX[1].h.multiply(uc[0]));
        ret = ret.add(Pole.AX[2].h.multiply(uc[1]));
        ret = ret.add(Pole.AX[3].h.multiply(uc[2]));
        return new Angle(ret, Angle.Unit.SECOND);
    }

    private static Dim3 ecriptic(Dim3 org, BigDecimal[] uc, Angle ax, Angle phi) {
        Dim3 ret = Pole.mean(org, uc);
        ret = ret.rotateX(ax);
        return ret.rotateZ(phi);
    }

    private static Dim3 equator(Dim3 org, BigDecimal[] uc, Angle ax, Angle phi, Angle epsilon) {
        Dim3 ret = Pole.ecriptic(org, uc, ax, phi);
        Angle a = new Angle(0, Angle.Unit.SECOND).subtract(ax.add(epsilon));
        return ret.rotateX(a);
    }

    private static BigDecimal[] get20C(ETD jed) {
        BigDecimal c = jed.get20C();
        return new BigDecimal[]{c, c.pow(2), c.pow(3)};
    }

    public static Pole plot(ETD jed, Planet planet, Plane c) throws AJDException, IOException {
        if (planet == Planet.EARTH) {
            throw new AJDException("Planet.EARTH \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        Dim3 p = Dim3.plot(jed, planet, Planet.EARTH);
        BigDecimal[] uc = Pole.get20C(jed);
        Angle ax = Pole.axial(uc);
        Raw pe = Raw.getRaw(jed, JPLItem.NUTATIONS);
        Angle phi = new Angle(pe.x.negate(), Angle.Unit.RADIAN);
        p = c == Plane.ECLIPTIC ? Pole.ecriptic(p, uc, ax, phi) : Pole.equator(p, uc, ax, phi, new Angle(pe.y, Angle.Unit.RADIAN));
        Dim3.XYZ d = p.get(Dim3.Unit.AU);
        return new Pole(d.x, d.y, d.z);
    }

    public PL get(Angle.Unit latitude, Angle.Unit longitude) {
        Angle rp = new Angle(this.p, Angle.Unit.RADIAN);
        Angle rl = new Angle(this.l, Angle.Unit.RADIAN);
        return new PL(rp.convert(latitude), rl.convert(longitude));
    }

    public static class PL
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Angle lat;
        public Angle lon;

        public PL(Angle latitude, Angle longitude) {
            this.lat = latitude;
            this.lon = longitude;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Lat:").append(this.lat);
            buf.append(" / Lon:").append(this.lon);
            return buf.toString();
        }
    }

    public static enum Plane {
        EQUATOR,
        ECLIPTIC;

    }
}

