/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.Era;
import ajd4jp.Month;
import ajd4jp.Week;
import ajd4jp.iso.Year;
import ajd4jp.util.Calc;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.function.Supplier;

public class AJD
implements Day {
    private static final long serialVersionUID = 1L;
    static final BigDecimal FIX05 = new BigDecimal("0.50000000");
    static final BigDecimal FIX_05 = new BigDecimal("-0.50000000");
    private BigDecimal ajd;
    private Instant instant;
    private static final BigDecimal EPOCH = new BigDecimal("2440587.50000000000000000000");
    private short year;
    private short mon;
    private short day;
    private short hour;
    private short min;
    private short sec;
    public static final ZoneOffset OFFSET = ZoneOffset.of("+09:00");
    private Era.Year era = null;
    private Week week = null;
    private static final BigDecimal DAY_SEC = new BigDecimal(86400);
    private static final BigDecimal NANO_SEC = new BigDecimal(1000000000);
    private static final BigDecimal DAY_NANO_SEC = DAY_SEC.multiply(NANO_SEC);
    private static final BigDecimal J122_1 = new BigDecimal("122.1");
    private static final BigDecimal J365_25 = new BigDecimal("365.25");
    private static final BigDecimal J30_6001 = new BigDecimal("30.6001");

    @Override
    public ZoneId getZoneId() {
        return OFFSET;
    }

    public Instant toInstant() {
        return this.instant;
    }

    public long getTime() {
        return this.instant.toEpochMilli();
    }

    public AJD addNano(long nanos) {
        if (nanos == 0L) {
            return this;
        }
        return this.from(this.instant.plusNanos(nanos));
    }

    public AJD addSecond(long ss) {
        if (ss == 0L) {
            return this;
        }
        return this.from(this.instant.plusSeconds(ss));
    }

    public AJD addMinute(long mm) {
        return this.addSecond(mm * 60L);
    }

    public AJD addHour(long hh) {
        return this.addMinute(hh * 60L);
    }

    public AJD addDay(Number dd) {
        BigDecimal d = new BigDecimal(dd.toString());
        if (d.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        return this.addNano(d.multiply(DAY_NANO_SEC).longValue());
    }

    public String toString() {
        return String.format("%d/%02d/%02d %02d:%02d:%02d.%09d(%s)[%s]", this.year, this.mon, this.day, this.hour, this.min, this.sec, this.getNano(), this.getZoneId(), Calc.toString(this.ajd));
    }

    public String toSqlString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%09d", this.year, this.mon, this.day, this.hour, this.min, this.sec, this.getNano());
    }

    @Override
    public int getYear() {
        return this.year;
    }

    public Era.Year getEra() {
        if (this.era == null) {
            this.era = new Era.Year(this);
        }
        return this.era;
    }

    @Override
    public int getMonth() {
        return this.mon;
    }

    public Month toMonth() {
        return new Month(this);
    }

    @Override
    public int getDay() {
        return this.day;
    }

    public Week getWeek() {
        if (this.week == null) {
            this.week = Week.get(this);
        }
        return this.week;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinute() {
        return this.min;
    }

    @Override
    public int getSecond() {
        return this.sec;
    }

    public int getNano() {
        return this.instant.getNano();
    }

    public AJD() {
        this(Instant.now());
    }

    protected AJD from(Instant ins) {
        return new AJD(ins);
    }

    private static BigDecimal addNanoSec(BigDecimal org, int ns) {
        return org.add(Calc.div(new BigDecimal(ns), DAY_NANO_SEC));
    }

    protected AJD(Instant ins, Supplier<ZoneOffset> offsetter) {
        this.instant = ins;
        this.ajd = Calc.div(new BigDecimal(ins.getEpochSecond()), DAY_SEC).add(EPOCH);
        this.ajd = AJD.addNanoSec(this.ajd, ins.getNano());
        this.set(offsetter);
    }

    public AJD(Instant ins) {
        this(ins, () -> OFFSET);
    }

    private void ajd2Instant(Integer ns) {
        long time;
        int sub;
        if (ns == null) {
            ns = this.ajd.abs().multiply(DAY_NANO_SEC).remainder(NANO_SEC).intValue();
        }
        if ((sub = (int)((time = this.ajd.subtract(EPOCH).multiply(DAY_SEC).longValue()) % 60L)) < 0) {
            sub += 60;
        }
        this.instant = Instant.ofEpochSecond(time - (long)(sub -= this.sec), ns.intValue());
    }

    protected AJD(Number num, Supplier<ZoneOffset> offsetter) {
        this.ajd = new BigDecimal(num.toString()).abs();
        this.set(offsetter);
        this.ajd2Instant(null);
    }

    public AJD(Number num) {
        this(num, () -> OFFSET);
    }

    private static Instant localDateTime2Instant(LocalDateTime ldt, ZoneId zone) {
        return ldt.atZone(zone).toInstant();
    }

    protected static Instant date2Instant(java.util.Date date, ZoneId zone) {
        if (date instanceof Date) {
            return AJD.localDateTime2Instant(((Date)date).toLocalDate().atStartOfDay(), zone);
        }
        if (date instanceof Time) {
            return AJD.localDateTime2Instant(((Time)date).toLocalTime().atDate(LocalDate.of(1970, 1, 1)), zone);
        }
        if (date instanceof Timestamp) {
            return AJD.localDateTime2Instant(((Timestamp)date).toLocalDateTime(), zone);
        }
        return date.toInstant();
    }

    public AJD(java.util.Date date) {
        this(AJD.date2Instant(date, OFFSET));
    }

    public AJD(Day date) {
        this(date.toAJD().instant);
    }

    public AJD(Calendar calendar) {
        this(calendar.toInstant());
    }

    private void set(Supplier<ZoneOffset> offsetter) {
        int offset_min = offsetter.get().getTotalSeconds() / 60;
        BigDecimal tmp = this.ajd;
        double org = this.ajd.doubleValue();
        long jd = Calc.cut(tmp);
        if ((tmp = tmp.subtract(new BigDecimal(jd))).compareTo(FIX05) >= 0) {
            ++jd;
            tmp = tmp.subtract(FIX05);
        } else {
            tmp = tmp.add(FIX05);
        }
        if (org >= 2299160.5) {
            jd = jd + 1L + (jd - 1867216L) / 36524L - (jd - 1867216L) / 146096L;
        }
        BigDecimal bjd = new BigDecimal(jd += 1524L);
        long c = Calc.cut(Calc.div(bjd.subtract(J122_1), J365_25));
        long k = c * 365L + c / 4L;
        long e = Calc.cut(Calc.div(bjd.subtract(new BigDecimal(k)), J30_6001));
        this.year = (short)(c - 4716L);
        this.mon = (short)(e - 1L);
        if (this.mon > 12) {
            this.mon = (short)(this.mon - 12);
            this.year = (short)(this.year + 1);
        }
        if (this.year <= 0) {
            this.year = (short)(this.year - 1);
        }
        this.day = (short)(jd - k - Calc.cut(new BigDecimal("30.6").multiply(new BigDecimal(e))));
        long s = Calc.cut(tmp.multiply(Calc.J86400).add(FIX05));
        this.hour = (short)(s / 3600L);
        this.min = (short)(s % 3600L / 60L + (long)offset_min);
        this.sec = (short)(s % 60L);
        while (this.min < 0) {
            this.min = (short)(this.min + 60);
            this.hour = (short)(this.hour - 1);
        }
        while (this.min > 59) {
            this.min = (short)(this.min - 60);
            this.hour = (short)(this.hour + 1);
        }
        if (this.hour >= 0 && this.hour < 24) {
            return;
        }
        try {
            Month m = new Month(this.year, (int)this.mon);
            if (this.hour < 0) {
                this.hour = (short)(this.hour + 24);
                this.day = (short)(this.day - 1);
                if (this.day < 1) {
                    m = m.add(-1);
                    this.day = (short)m.getLastDay();
                }
            } else {
                this.hour = (short)(this.hour - 24);
                this.day = (short)(this.day + 1);
                if (this.day > m.getLastDay()) {
                    m = m.add(1);
                    this.day = 1;
                }
            }
            this.year = (short)m.getYear();
            this.mon = (short)m.getMonth();
        }
        catch (AJDException m) {
            // empty catch block
        }
        try {
            AJD.isGregorian(this.year, this.mon, this.day);
        }
        catch (AJDException e1) {
            this.day = (short)(offset_min < 0 ? 4 : 15);
        }
    }

    protected AJD from(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        return new AJD(yyyy, mm, dd, hh, mi, ss, ns);
    }

    public AJD(Year yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        this(yyyy.getAjdYear(), mm, dd, hh, mi, ss);
    }

    public AJD(int yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        this(yyyy, mm, dd, hh, mi, ss, 0);
    }

    public AJD(Year yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        this(yyyy.getAjdYear(), mm, dd, hh, mi, ss, ns);
    }

    public AJD(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        this(yyyy, mm, dd, hh, mi, ss, ns, OFFSET);
    }

    protected AJD(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns, ZoneOffset offset) throws AJDException {
        this.initAJD(yyyy, mm, dd, hh, mi, ss, ns, () -> offset);
    }

    AJD(int yyyy, int mm, int dd, ZoneOffset z) {
        try {
            this.initAJD(yyyy, mm, dd, 0, 0, 0, 0, () -> z);
        }
        catch (AJDException aJDException) {
            // empty catch block
        }
    }

    public AJD(Year yyyy, int mm, int dd) throws AJDException {
        this(yyyy.getAjdYear(), mm, dd);
    }

    public AJD(int yyyy, int mm, int dd) throws AJDException {
        this(yyyy, mm, dd, 0, 0, 0);
    }

    public AJD(String yyyy, String mm, String dd, String hh, String mi, String ss) throws AJDException {
        this(Integer.parseInt(yyyy), Integer.parseInt(mm), Integer.parseInt(dd), Integer.parseInt(hh), Integer.parseInt(mi), Integer.parseInt(ss));
    }

    public AJD(String yyyy, String mm, String dd) throws AJDException {
        this(yyyy, mm, dd, "0", "0", "0");
    }

    static int check(int yy, int mm) throws AJDException {
        if (yy == 0) {
            throw new AJDException("\u5e74\u304c0\u3067\u3059\u3002");
        }
        if (mm < 1 || mm > 12) {
            throw new AJDException("\u6708\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (yy < 0) {
            ++yy;
        }
        return yy;
    }

    private static boolean isGregorian(int yy, int mm, int dd) throws AJDException {
        if (dd < 1 || dd > new Month(yy, mm).getLastDay()) {
            throw new AJDException("\u65e5\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (yy == 1582 && mm == 10 && dd > 4 && dd < 15) {
            throw new AJDException("\u65e5\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        return yy > 1582 || yy == 1582 && mm > 10 || yy == 1582 && mm == 10 && dd >= 15;
    }

    void initAJD(int yy, int mm, int dd, int hh, int mi, int ss, int ns, Supplier<ZoneOffset> offsetter) throws AJDException {
        BigDecimal ret;
        long jd;
        if (hh < 0 || hh > 23) {
            throw new AJDException("\u6642\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (mi < 0 || mi > 59) {
            throw new AJDException("\u5206\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (ss < 0 || ss > 59) {
            throw new AJDException("\u79d2\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (ns < 0 || ns > 999999999) {
            throw new AJDException("\u30ca\u30ce\u79d2\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        this.year = (short)yy;
        boolean bc_f = yy <= 0;
        boolean gre_f = AJD.isGregorian(yy, mm, dd);
        yy = AJD.check(yy, mm);
        this.mon = (short)mm;
        this.day = (short)dd;
        this.hour = (short)hh;
        this.min = (short)mi;
        this.sec = (short)ss;
        if (mm <= 2) {
            --yy;
            mm += 12;
        }
        if (hh < 12) {
            jd = 0L;
            ret = FIX05;
        } else {
            jd = 1L;
            ret = FIX_05;
        }
        ret = ret.add(Calc.div(new BigDecimal(hh * 3600 + mi * 60 + ss - offsetter.get().getTotalSeconds()), Calc.J86400));
        ret = AJD.addNanoSec(ret, ns);
        jd += bc_f ? (long)((yy - 3) / 4) : (long)(yy / 4);
        if (gre_f) {
            jd += (long)(2 - yy / 100 + yy / 400);
        }
        this.ajd = ret.add(new BigDecimal(jd += (long)(1720994 + yy * 365 + (mm + 1) * 30 + (mm + 1) * 3 / 5 + dd)));
        if (this.ajd.signum() == -1) {
            throw new AJDException("\u30e6\u30ea\u30a6\u30b9\u901a\u65e5\u57fa\u6e96\u65e5\u3088\u308a\u904e\u53bb\u306e\u65e5\u4ed8\u306b\u306a\u308a\u307e\u3057\u305f\u3002");
        }
        this.ajd2Instant(ns);
    }

    @Override
    public BigDecimal getAJD() {
        return this.ajd;
    }

    @Override
    public AJD toAJD() {
        return this;
    }

    @Override
    public int compareTo(Day jd) {
        return this.instant.compareTo(jd.toAJD().instant);
    }

    public int hashCode() {
        return this.instant.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Day) {
            return this.compareTo((Day)o) == 0;
        }
        return false;
    }

    public AJD trim(TrimParameter param) {
        return param.trim(this);
    }

    public AJD trim() {
        return this.trim(TrimParameter.DAY);
    }

    public Date toDate() {
        return Date.valueOf(this.toSqlString().split(" ")[0]);
    }

    public Time toTime() {
        return Time.valueOf(this.toSqlString().split(" ")[1].split("\\.")[0]);
    }

    public Timestamp toTimestamp() {
        return Timestamp.valueOf(this.toSqlString());
    }

    public static enum TrimParameter {
        DAY(true, true, true),
        HOUR(false, true, true),
        MINUTE(false, false, true),
        SECOND(false, false, false);

        private boolean[] flag;

        private TrimParameter(boolean ... f) {
            this.flag = f;
        }

        private AJD trim(AJD org) {
            AJD ret = org.from(org.year, org.mon, org.day, this.flag[0] ? (short)0 : org.hour, this.flag[1] ? (short)0 : org.min, this.flag[2] ? (short)0 : org.sec, 0);
            if (ret.equals(org)) {
                return org;
            }
            return ret;
        }
    }
}

