/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Equinox;
import ajd4jp.LSCD;
import ajd4jp.STCD;
import ajd4jp.Saku;
import ajd4jp.Span;
import ajd4jp.iso.Year;
import ajd4jp.util.AjdFactory;
import ajd4jp.util.Calc;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;

public class LunisolarYear
implements Comparable<LunisolarYear>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int START = 270;
    private static final int BASE_MON = 11;
    private static HashMap<Year, LunisolarYear> map = new HashMap();
    private int yy;
    private Saku[] month;
    private Saku limit;

    private static boolean isHit(int start, int end) {
        if (start > end) {
            end += 360;
        }
        for (int i = start / 30 * 30; i < end; i += 30) {
            if (start > i || i >= end) continue;
            return true;
        }
        return false;
    }

    private static Saku[] countMon(int year, Saku[] saku, int start, int end) {
        int i;
        int mm = 11;
        int lim = 13;
        if (!saku[start].start_f) {
            ++mm;
            --lim;
        }
        ArrayList<Saku> list = new ArrayList<Saku>();
        for (int cnt = start; cnt < end; ++cnt) {
            if (!saku[cnt].start_f) continue;
            list.add(saku[cnt]);
        }
        saku = list.toArray(new Saku[0]);
        if (saku.length < lim) {
            for (i = 0; i < saku.length; ++i) {
                saku[i].year = year++;
                saku[i].mon = mm++;
                if (mm <= 12) continue;
                mm = 1;
                if (year != 0) continue;
                ++year;
            }
            return saku;
        }
        --mm;
        boolean set_f = false;
        for (i = 1; i < saku.length; ++i) {
            if (set_f || LunisolarYear.isHit(saku[i - 1].sun, saku[i].sun)) {
                if (++mm > 12) {
                    mm = 1;
                    if (++year == 0) {
                        // empty if block
                    }
                }
            } else {
                set_f = true;
                saku[i - 1].leap_f = true;
            }
            saku[i - 1].year = ++year;
            saku[i - 1].mon = mm;
        }
        saku[i - 1].year = year;
        saku[i - 1].mon = 10;
        saku[i - 1].leap_f = saku[i - 1].mon == saku[i - 2].mon;
        return saku;
    }

    private static int getSun(AJD ajd) {
        BigDecimal sun = Equinox.getSun(ajd.getAJD());
        if (sun.compareTo(BigDecimal.ZERO) < 0) {
            sun = sun.add(Equinox.R360);
        }
        int ret = (int)Calc.up(sun);
        return ret;
    }

    private static LunisolarYear get11(AJD ajd) {
        int i;
        int sun = LunisolarYear.getSun(ajd);
        int year = ajd.getYear();
        if (sun > 270 && --year == 0) {
            --year;
        }
        int yyyy = year - 1;
        AJD[] toji = new AJD[4];
        if (yyyy == 0) {
            --yyyy;
        }
        for (int i2 = 0; i2 < toji.length; ++i2) {
            toji[i2] = STCD.getStart(Year.fromAJD(yyyy, ajd.getZoneId()), 270).trim();
            if (++yyyy != 0) continue;
            ++yyyy;
        }
        int day = new Span(toji[0], toji[3]).getDayPart();
        Saku[] saku = new Saku[day + 1];
        for (int i3 = 0; i3 < saku.length; ++i3) {
            saku[i3] = new Saku();
        }
        saku[0].ajd = toji[0];
        saku[0].sun = 270;
        saku[day].ajd = toji[3];
        saku[day].sun = 270;
        ajd = ajd.trim();
        saku[0].moon = Equinox.getMoonPhase(toji[0]);
        day = 1;
        while (day < saku.length) {
            int m_sub;
            saku[day].ajd = toji[0].addDay(day);
            saku[day].sun = LunisolarYear.getSun(saku[day].ajd);
            saku[day].moon = Equinox.getMoonPhase(saku[day].ajd);
            int pre = day - 1;
            if (saku[pre].moon == null) {
                ++day;
                continue;
            }
            if (saku[day].moon.compareTo(saku[pre].moon) < 0) {
                if (saku[day].moon.compareTo(BigDecimal.ZERO) == 0) {
                    saku[day].start_f = true;
                } else {
                    saku[pre].start_f = true;
                }
            }
            int s_sub = 30;
            for (int i4 = 1; i4 <= 2; ++i4) {
                int cmp = toji[i4].compareTo(saku[day].ajd);
                if (cmp < 0) continue;
                s_sub = new Span(toji[i4], saku[day].ajd).getDayPart();
                if (--s_sub >= 1) break;
                s_sub = 1;
                break;
            }
            if ((m_sub = 27 - (int)Calc.cut(saku[day].moon)) < 1) {
                m_sub = 1;
            }
            day += s_sub > m_sub ? m_sub : s_sub;
        }
        int[] mid = new int[2];
        day = 1;
        block4: for (int i5 = 0; i5 < mid.length; ++i5) {
            while (day < saku.length) {
                if (toji[i5 + 1].equals(saku[day].ajd)) {
                    for (int j = day; j >= 0; --j) {
                        if (!saku[j].start_f) continue;
                        mid[i5] = j;
                        continue block4;
                    }
                    continue block4;
                }
                ++day;
            }
        }
        Saku[][] line = new Saku[][]{LunisolarYear.countMon(year - 1 == 0 ? -1 : year - 1, saku, 0, mid[0]), LunisolarYear.countMon(year, saku, mid[0], mid[1]), LunisolarYear.countMon(year + 1 == 0 ? 1 : year + 1, saku, mid[1], saku.length - 1)};
        ArrayList<Saku> list = new ArrayList<Saku>();
        for (i = 0; i < line[0].length; ++i) {
            if (line[0][i].year != year) continue;
            list.add(line[0][i]);
        }
        for (i = 0; i < line[1].length; ++i) {
            list.add(line[1][i]);
        }
        for (i = 0; i < line[2].length && line[2][i].year == year; ++i) {
            list.add(line[2][i]);
        }
        int cnt = list.size();
        for (int i6 = 1; i6 < cnt; ++i6) {
            Saku s = (Saku)list.get(i6 - 1);
            if (s.ajd.compareTo(ajd) > 0 || list.get((int)i6).ajd.compareTo(ajd) <= 0) continue;
            year = s.year;
            break;
        }
        LunisolarYear ls = new LunisolarYear(year, list);
        map.put(Year.fromAJD(year, ajd.getZoneId()), ls);
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LunisolarYear getLunisolarYear(AJD hint) {
        int year = hint.getYear() - 1;
        if (year == 0) {
            year = -1;
        }
        HashMap<Year, LunisolarYear> hashMap = map;
        synchronized (hashMap) {
            int i = 0;
            while (i < 3) {
                LunisolarYear y;
                if (year == 0) {
                    ++year;
                }
                if ((y = map.get(Year.fromAJD(year, hint.getZoneId()))) != null && y.getLSCD(hint) != null) {
                    return y;
                }
                ++i;
                ++year;
            }
            return LunisolarYear.get11(hint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LunisolarYear getLunisolarYear(Year year) {
        HashMap<Year, LunisolarYear> hashMap = map;
        synchronized (hashMap) {
            LunisolarYear y = map.get(year);
            if (y != null) {
                return y;
            }
            return LunisolarYear.get11(AjdFactory.makeAJD(year.getAjdYear(), 6, 1, year.getZoneId()));
        }
    }

    public static LunisolarYear getLunisolarYear(int year) throws AJDException {
        return LunisolarYear.getLunisolarYear(Year.fromAJD(year, AJD.OFFSET));
    }

    public static LunisolarYear getLunisolarYear(int year, ZoneId zone) throws AJDException {
        return LunisolarYear.getLunisolarYear(Year.fromAJD(year, zone));
    }

    private LunisolarYear(int y, ArrayList<Saku> list) {
        int start;
        this.yy = y;
        int cnt = list.size();
        ArrayList<Saku> mine = new ArrayList<Saku>();
        for (start = 0; start < cnt && list.get((int)start).year != y; ++start) {
        }
        while (start < cnt) {
            Saku s = list.get(start);
            if (s.year != y) {
                this.limit = s;
                break;
            }
            mine.add(s);
            ++start;
        }
        this.month = mine.toArray(new Saku[0]);
        if (this.limit == null) {
            int ny = y + 1;
            if (ny == 0) {
                ny = 1;
            }
            LunisolarYear next = null;
            try {
                next = LunisolarYear.getLunisolarYear(ny);
            }
            catch (AJDException aJDException) {
                // empty catch block
            }
            this.limit = next.month[0];
        }
    }

    public int getYear() {
        return this.yy;
    }

    public LSCD getLSCD(AJD dd) {
        int i;
        AJD ajd = dd.trim();
        if (ajd.compareTo(this.month[0].ajd) < 0) {
            return null;
        }
        if (ajd.compareTo(this.limit.ajd) >= 0) {
            return null;
        }
        for (i = 1; i < this.month.length && ajd.compareTo(this.month[i].ajd) >= 0; ++i) {
        }
        return new LSCD(this.month[i - 1].year, this.month[i - 1].leap_f, this.month[i - 1].mon, this.month[i - 1].ajd, dd);
    }

    public int getMonthCount() {
        return this.month.length;
    }

    public int getLeapMonth() {
        for (int i = 0; i < this.month.length; ++i) {
            if (!this.month[i].leap_f) continue;
            return this.month[i].mon;
        }
        return -1;
    }

    private Saku[] getSaku(int mm, boolean leap_f) throws AJDException {
        for (int i = 0; i < this.month.length; ++i) {
            if (this.month[i].leap_f != leap_f || this.month[i].mon != mm) continue;
            Saku next = i == this.month.length - 1 ? this.limit : this.month[i + 1];
            return new Saku[]{this.month[i], next};
        }
        throw new AJDException("\u6307\u5b9a\u6708\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
    }

    public int getLastDay(int mm, boolean leap_f) throws AJDException {
        Saku[] mon = this.getSaku(mm, leap_f);
        return new Span(mon[0].ajd, mon[1].ajd).getDayPart();
    }

    public LSCD getLSCD(int mm, boolean leap_f, int dd) throws AJDException {
        return this.getLSCD(mm, leap_f, dd, 0, 0, 0);
    }

    public LSCD getLSCD(int mm, boolean leap_f, int dd, int hh, int mi, int ss) throws AJDException {
        if (dd < 1 || dd > this.getLastDay(mm, leap_f)) {
            throw new AJDException("\u6307\u5b9a\u65e5\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        Saku[] mon = this.getSaku(mm, leap_f);
        return new LSCD(this.yy, leap_f, mm, dd, mon[0].ajd.addDay(dd - 1).addHour(hh).addMinute(mi).addSecond(ss));
    }

    public static AJD getNewYear(Year yyyy) {
        return LunisolarYear.getLunisolarYear(yyyy).getLSCD(1, false, 1).toAJD();
    }

    public String toString() {
        return Integer.toString(this.yy);
    }

    @Override
    public int compareTo(LunisolarYear y) {
        int ret = this.yy - y.yy;
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.yy;
    }

    public boolean equals(Object o) {
        if (o instanceof LunisolarYear) {
            return this.yy == ((LunisolarYear)o).yy;
        }
        return false;
    }
}

