/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.EarthlyBranch;
import ajd4jp.Equinox;
import ajd4jp.HeavenlyStem;
import ajd4jp.SexagenaryCycle;
import ajd4jp.Span;
import ajd4jp.iso.Year;
import ajd4jp.util.AjdFactory;
import ajd4jp.util.Calc;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;

public class STCD
implements Day {
    private static final long serialVersionUID = 1L;
    private static final int YEAR = 315;
    private static HashMap<Year, HashMap<Integer, AJD>> start_day = new HashMap();
    private AJD ajd;
    private int yy;
    private int mm;
    private int dd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AJD getStart(Year year, int r) {
        HashMap<Year, HashMap<Integer, AJD>> hashMap = start_day;
        synchronized (hashMap) {
            AJD ret = null;
            HashMap<Integer, AJD> ymap = start_day.get(year);
            if (ymap != null) {
                ret = ymap.get(r);
            }
            if (ret == null) {
                try {
                    ret = Equinox.getAJD(year, (Number)r).trim();
                }
                catch (AJDException aJDException) {
                    // empty catch block
                }
                if (ymap == null) {
                    ymap = new HashMap();
                    start_day.put(year, ymap);
                }
                ymap.put(r, ret);
            }
            return ret;
        }
    }

    public STCD(Day day) {
        this(day, false);
    }

    private STCD(Day day, boolean test_f) {
        ZoneId zone = day.getZoneId();
        this.ajd = AjdFactory.makeAJD(day.getAJD(), zone);
        this.yy = this.ajd.getYear();
        if (this.ajd.compareTo(STCD.getStart(this.ajd.toYear(), 315)) < 0) {
            --this.yy;
            if (this.yy <= 0) {
                --this.yy;
            }
        }
        int sun = STCD.getSun(this.ajd);
        this.mm = sun - 315;
        if (this.mm < 0) {
            this.mm += 360;
        }
        this.mm = this.mm / 30 + 1;
        sun = (this.mm - 1) * 30 + 315;
        if (sun > 360) {
            sun -= 360;
        }
        this.dd = new Span(STCD.getStart(this.ajd.toYear(), sun), this.ajd).getDayPart() + 1;
        if (this.dd > 31) {
            this.dd = new Span(STCD.getStart(Year.fromAJD(this.yy, zone), sun), this.ajd).getDayPart() + 1;
        }
        if (!test_f && this.dd > 20) {
            STCD test = new STCD(this.ajd.addDay(1), true);
            if (test.dd == 2) {
                this.yy = test.yy;
                this.mm = test.mm;
                this.dd = 1;
            }
        }
    }

    private static int getSun(AJD ajd) {
        BigDecimal sun = Equinox.getSun(ajd.getAJD());
        if (sun.compareTo(BigDecimal.ZERO) < 0) {
            sun = sun.add(Equinox.R360);
        }
        int ret = (int)Calc.cut(sun);
        if ((ret = ret / 15 * 15) % 10 == 0 && (ret -= 15) < 0) {
            ret += 360;
        }
        return ret;
    }

    @Override
    public int compareTo(Day jd) {
        return this.ajd.compareTo(jd);
    }

    public int hashCode() {
        return this.ajd.hashCode();
    }

    public boolean equals(Object o) {
        return this.ajd.equals(o);
    }

    public String toString() {
        return String.format("%d/%02d/%02d/ %02d:%02d:%02d", this.yy, this.mm, this.dd, this.getHour(), this.getMinute(), this.getSecond());
    }

    @Override
    public AJD toAJD() {
        return this.ajd;
    }

    @Override
    public BigDecimal getAJD() {
        return this.ajd.getAJD();
    }

    @Override
    public int getYear() {
        return this.yy;
    }

    @Override
    public int getMonth() {
        return this.mm;
    }

    @Override
    public int getDay() {
        return this.dd;
    }

    @Override
    public int getHour() {
        return this.ajd.getHour();
    }

    @Override
    public int getMinute() {
        return this.ajd.getMinute();
    }

    @Override
    public int getSecond() {
        return this.ajd.getSecond();
    }

    public static enum Kyusei {
        WHITE1("\u4e00\u767d\u6c34\u661f"),
        BLACK2("\u4e8c\u9ed2\u571f\u661f"),
        BLUE3("\u4e09\u78a7\u6728\u661f"),
        GREEN4("\u56db\u7dd1\u6728\u661f"),
        YELLOW5("\u4e94\u9ec4\u571f\u661f"),
        WHITE6("\u516d\u767d\u91d1\u661f"),
        RED7("\u4e03\u8d64\u91d1\u661f"),
        WHITE8("\u516b\u767d\u571f\u661f"),
        PURPLE9("\u4e5d\u7d2b\u706b\u661f");

        private String name;
        private static final Kyusei[] ky;

        private Kyusei(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }

        private static Kyusei fix(int v) {
            if ((v %= ky.length) < 0) {
                v += ky.length;
            }
            return ky[v];
        }

        public static Kyusei getYear(Day date) {
            int yy = new STCD(date = AjdFactory.makeAJD(date.getAJD(), date.getZoneId()).trim()).getYear();
            if (yy < 0) {
                ++yy;
            }
            return Kyusei.fix(10 - yy);
        }

        public static Kyusei getMonth(Day date) {
            date = AjdFactory.makeAJD(date.getAJD(), date.getZoneId()).trim();
            STCD stcd = new STCD(date);
            EarthlyBranch year = EarthlyBranch.getYear(stcd);
            int start = 8 - year.getNo() % 3 * 3;
            return Kyusei.fix(start - stcd.getMonth());
        }

        private static Start getStart(int r, AJD base) {
            HeavenlyStem h = HeavenlyStem.getDay(base);
            EarthlyBranch e = EarthlyBranch.getDay(base);
            int base_no = SexagenaryCycle.getNo(h, e);
            Start start = new Start();
            start.r = r;
            if (base_no < 29) {
                start.no = r == 90 ? 8 : 0;
                start.ajd = base.addDay(-1 * base_no);
            } else if (base_no > 31) {
                start.no = r == 90 ? 8 : 0;
                start.ajd = base.addDay(60 - base_no);
            } else {
                start.no = r == 90 ? 2 : 6;
                start.ajd = base.addDay(30 - base_no);
            }
            return start;
        }

        private static Start getStart(Day stcd, ZoneId zone) {
            int r = 90;
            int y = stcd.getYear() - 2;
            AJD last = null;
            AJD next = null;
            while (true) {
                if (r >= 360) {
                    r -= 360;
                    if (++y == 0) {
                        y = 1;
                    }
                }
                next = STCD.getStart(Year.fromAJD(y, zone), r);
                if (last != null && next.compareTo(stcd) > 0) break;
                last = next;
                r += 180;
            }
            Start start1 = Kyusei.getStart((r + 180) % 360, last);
            Start start2 = Kyusei.getStart(r, next);
            if (start1.ajd.compareTo(stcd) > 0) {
                return Kyusei.getStart(AjdFactory.makeAJD(stcd.getAJD(), zone).addDay(-30), zone);
            }
            return start2.ajd.compareTo(stcd) <= 0 ? start2 : start1;
        }

        public static Kyusei getDay(Day date) {
            ZoneId zone = date.getZoneId();
            date = AjdFactory.makeAJD(date.getAJD(), zone).trim();
            Start start = Kyusei.getStart(date, zone);
            int cnt = new Span(date, start.ajd).getDayPart();
            if (start.r == 90) {
                return Kyusei.fix(start.no - cnt);
            }
            return Kyusei.fix(start.no + cnt);
        }

        public static Kyusei getTime(Day date) {
            Start start = Kyusei.getStart(date, date.getZoneId());
            int day = EarthlyBranch.getDay(date).getNo() % 3;
            int base = start.r == 90 ? 8 - day * 3 : day * 3;
            int time = EarthlyBranch.getTime(date).getNo();
            if (start.r == 90) {
                return Kyusei.fix(base - time);
            }
            return Kyusei.fix(base + time);
        }

        static {
            ky = Kyusei.values();
        }

        private static class Start {
            int no;
            int r;
            AJD ajd;

            Start() {
            }
        }
    }

    public static enum Doyo {
        WINTER(315),
        SPRING(45),
        SUMMER(135),
        AUTUMN(225);

        private int start;
        private int end;

        private Doyo(int r) {
            this.start = r - 18;
            this.end = r;
        }

        public AJD[] getDoyo(Year year, EarthlyBranch ... filter) {
            AJD[] ajd = new AJD[]{STCD.getStart(year, this.start), STCD.getStart(year, this.end)};
            ArrayList<AJD> list = new ArrayList<AJD>();
            AJD k = ajd[0];
            while (k.compareTo(ajd[1]) < 0) {
                boolean hit = filter.length == 0;
                for (EarthlyBranch f : filter) {
                    if (EarthlyBranch.getDay(k) != f) continue;
                    hit = true;
                    break;
                }
                if (hit) {
                    list.add(k);
                }
                k = k.addDay(1);
            }
            return list.toArray(new AJD[0]);
        }

        public AJD[] getDoyo(int year, EarthlyBranch ... filter) throws AJDException {
            return this.getDoyo(year, AJD.OFFSET, filter);
        }

        public AJD[] getDoyo(int year, ZoneId zone, EarthlyBranch ... filter) throws AJDException {
            return this.getDoyo(Year.fromAJD(year, zone), filter);
        }
    }
}

