/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.iso;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.iso.Year;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class AJD310
extends AJD {
    public static final ZoneId JP_ZONE = ZoneId.of("Asia/Tokyo");
    private ZonedDateTime iso;

    private static String getOffsetHM(ZonedDateTime zdt, boolean std) {
        boolean sub;
        int min = zdt.getOffset().getTotalSeconds() / 60;
        if (min == 0) {
            return "Z";
        }
        int hour = min / 60;
        boolean bl = sub = hour < 0;
        if (sub) {
            hour *= -1;
        }
        if ((min %= 60) < 0) {
            min *= -1;
        }
        String str = String.format(std ? "%02d%02d" : "%02d:%02d", hour, min);
        return (sub ? "-" : "+") + str;
    }

    public String toIsoString(boolean std) {
        int yyyy = Math.abs(this.getYear());
        return (this.getYear() < 0 ? "-" : "") + String.format(std ? "%04d%02d%02dT%02d%02d%02d" : "%04d-%02d-%02dT%02d:%02d:%02d", yyyy, this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond()) + AJD310.getOffsetHM(this.iso, std);
    }

    protected AJD310(ZonedDateTime zdt) throws AJDException {
        super(zdt.toInstant(), () -> zdt.getOffset());
        this.iso = zdt;
    }

    public static AJD310 of(ZonedDateTime zdt) {
        return new AJD310(zdt);
    }

    public AJD310 withZoneSameLocal(ZoneId zone) {
        return AJD310.of(this.toZonedDateTime().withZoneSameLocal(zone));
    }

    public AJD310 withZoneSameInstant(ZoneId zone) {
        return AJD310.of(this.toZonedDateTime().withZoneSameInstant(zone));
    }

    public static AJD310 of(Date date, ZoneId zone) {
        return AJD310.of(ZonedDateTime.ofInstant(AJD310.date2Instant(date, zone), zone));
    }

    public static AJD310 of(Calendar calendar) {
        return AJD310.of(ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()));
    }

    @Override
    public ZoneId getZoneId() {
        return this.iso.getZone();
    }

    @Override
    protected AJD from(Instant ins) {
        return AJD310.of(ZonedDateTime.ofInstant(ins, this.iso.getZone()));
    }

    @Override
    protected AJD from(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        return AJD310.of(ZonedDateTime.of(yyyy, mm, dd, hh, mi, ss, ns, this.iso.getZone()));
    }

    public static AJD310 of(Day day, ZoneId zone) {
        return AJD310.of(ZonedDateTime.ofInstant(Instant.ofEpochMilli(day.toAJD().getTime()), zone));
    }

    public static AJD310 now(ZoneId zone) {
        return AJD310.of(ZonedDateTime.now(zone));
    }

    public static AJD310 of(Year yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws DateTimeException {
        return AJD310.of(ZonedDateTime.of(yyyy.getAjdYear(), mm, dd, hh, mi, ss, ns, yyyy.getZoneId()));
    }

    public static AJD310 of(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns, ZoneId zone) throws DateTimeException {
        if (yyyy == 0) {
            throw new AJDException("\u5e74\u304c0\u3067\u3059\u3002");
        }
        return AJD310.of(ZonedDateTime.of(yyyy < 0 ? yyyy + 1 : yyyy, mm, dd, hh, mi, ss, ns, zone));
    }

    public static AJD310 of(Year yyyy, int mm, int dd, int hh, int mi, int ss) throws DateTimeException {
        return AJD310.of(yyyy.getAjdYear(), mm, dd, hh, mi, ss, yyyy.getZoneId());
    }

    public static AJD310 of(int yyyy, int mm, int dd, int hh, int mi, int ss, ZoneId zone) throws DateTimeException {
        return AJD310.of(yyyy, mm, dd, hh, mi, ss, 0, zone);
    }

    public static AJD310 of(Year yyyy, int mm, int dd) throws AJDException {
        return AJD310.of(yyyy.getAjdYear(), mm, dd, yyyy.getZoneId());
    }

    public static AJD310 of(int yyyy, int mm, int dd, ZoneId zone) throws AJDException {
        try {
            return AJD310.of(yyyy, mm, dd, 0, 0, 0, zone);
        }
        catch (AJDException ae) {
            throw ae;
        }
        catch (Exception etc) {
            throw new AJDException(etc);
        }
    }

    public ZonedDateTime toZonedDateTime() {
        return this.iso;
    }

    public static AJD310[] to(AJD[] src, ZoneId zone) {
        AJD310[] ret = new AJD310[src.length];
        for (int i = 0; i < src.length; ++i) {
            ret[i] = AJD310.of(src[i], zone);
        }
        return ret;
    }
}

