/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.iso;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.iso.Year;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;

public class UTC
extends AJD {
    public static final ZoneOffset OFFSET = ZoneOffset.UTC;

    @Override
    public ZoneId getZoneId() {
        return OFFSET;
    }

    @Override
    protected AJD from(Instant ins) {
        return new UTC(ins);
    }

    @Override
    protected AJD from(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        return new UTC(yyyy, mm, dd, hh, mi, ss, ns);
    }

    public UTC(Instant ins) {
        super(ins, () -> OFFSET);
    }

    public UTC() {
        this(Instant.now());
    }

    public UTC(Calendar calendar) {
        this(calendar.toInstant());
    }

    public UTC(Date date) {
        this(UTC.date2Instant(date, OFFSET));
    }

    public UTC(Day date) {
        this(date.toAJD().toInstant());
    }

    public UTC(Number num) {
        super(num, () -> OFFSET);
    }

    public UTC(int yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        super(yyyy, mm, dd, hh, mi, ss, ns, OFFSET);
    }

    public UTC(Year yyyy, int mm, int dd, int hh, int mi, int ss, int ns) throws AJDException {
        this(yyyy.getAjdYear(), mm, dd, hh, mi, ss, ns);
    }

    public UTC(Year yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        this(yyyy.getAjdYear(), mm, dd, hh, mi, ss);
    }

    public UTC(int yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        this(yyyy, mm, dd, hh, mi, ss, 0);
    }

    public UTC(Year yyyy, int mm, int dd) throws AJDException {
        this(yyyy.getAjdYear(), mm, dd);
    }

    public UTC(int yyyy, int mm, int dd) throws AJDException {
        this(yyyy, mm, dd, 0, 0, 0);
    }
}

