/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.iso;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Month;
import ajd4jp.Span;
import ajd4jp.util.AjdFactory;
import java.io.Serializable;
import java.time.ZoneId;

public class Year
implements Serializable,
Comparable<Year> {
    private static final long serialVersionUID = 1L;
    private short val;
    private ZoneId zone;

    private Year() {
    }

    private Year(int yyyy, ZoneId z) {
        this.val = (short)yyyy;
        this.zone = z;
    }

    public static Year fromAJD(int yyyy, ZoneId zone) throws AJDException {
        if (yyyy == 0) {
            throw new AJDException("\u5e74\u304c0\u3067\u3059\u3002");
        }
        if (yyyy < 0) {
            ++yyyy;
        }
        return new Year(yyyy, zone);
    }

    public static Year fromISO(int yyyy, ZoneId zone) {
        return new Year(yyyy, zone);
    }

    public int getAjdYear() {
        if (this.val < 1) {
            return this.val - 1;
        }
        return this.val;
    }

    public int getIsoYear() {
        return this.val;
    }

    public ZoneId getZoneId() {
        return this.zone;
    }

    public Month getMonth(int mm) throws AJDException {
        return new Month(this, mm);
    }

    public Month[] getMonth() {
        Month[] mon = new Month[12];
        for (int i = 0; i < mon.length; ++i) {
            mon[i] = this.getMonth(i + 1);
        }
        return mon;
    }

    public AJD getFirstDay() {
        return AjdFactory.makeAJD(this.getAjdYear(), 1, 1, this.zone);
    }

    public AJD getDay(int no) {
        AJD ret = this.getFirstDay().addDay(no - 1);
        if (ret.getYear() != this.getAjdYear()) {
            return null;
        }
        return ret;
    }

    public int dayOfYear(AJD ajd) {
        if (ajd.getYear() != this.getAjdYear()) {
            return 0;
        }
        return new Span(ajd.trim(), this.getFirstDay()).getDayPart() + 1;
    }

    public AJD getLastDay() {
        return this.add(1).getFirstDay().addDay(-1);
    }

    public int lastDayOfYear() {
        return this.dayOfYear(this.getLastDay());
    }

    public Year add(int year) {
        return new Year(this.val + year, this.zone);
    }

    @Override
    public int compareTo(Year o) {
        return this.val - o.val;
    }

    public int hashCode() {
        return this.val;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Year)) {
            return false;
        }
        Year anti = (Year)o;
        return anti.compareTo(this) == 0 && anti.zone.equals(this.zone);
    }

    public String toString() {
        int year = this.getAjdYear();
        return (year < 0 ? "\u7d00\u5143\u524d" : "\u897f\u66a6") + Math.abs(year) + "\u5e74";
    }
}

