/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery.tool;

import ajd4jp.Version;
import ajd4jp.orrery.tool.FileList;
import ajd4jp.orrery.tool.JPLItem;
import ajd4jp.orrery.tool.MapXYZ;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class JPL2Bin {
    private static int all_days = 0;
    private static JPLItem[] planet = JPLItem.values();
    private static int[] offset = new int[planet.length];
    private static int[] count = new int[planet.length];
    private static int[] sub = new int[planet.length];
    private static MapXYZ map = null;
    private static File output;
    private static RandomAccessFile[] raf;
    private static BigDecimal last_dt;

    private static String getExt(String name) {
        String[] part = name.split("\\.");
        String no = part[part.length - 1];
        System.out.println("DE" + no);
        return "." + no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readHeader(String name) throws Exception {
        ArrayList<String> key1040 = new ArrayList<String>();
        ArrayList<String> data1041 = new ArrayList<String>();
        System.out.println("Reading " + name);
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new FileReader(name));
            int gno = 0;
            boolean started = false;
            int cnt1050 = 0;
            block14: while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] part = line.split("\\s+");
                if ("GROUP".equals(part[0])) {
                    gno = Integer.parseInt(part[1]);
                    started = false;
                    continue;
                }
                switch (gno) {
                    case 1030: {
                        map = new MapXYZ(part[0], part[1]);
                        all_days = (int)Double.parseDouble(part[2]);
                        break;
                    }
                    case 1040: {
                        if (!started) {
                            started = true;
                            break;
                        }
                        for (String s : part) {
                            key1040.add(s);
                        }
                        continue block14;
                    }
                    case 1041: {
                        if (!started) {
                            started = true;
                            break;
                        }
                        for (String s : part) {
                            data1041.add(s);
                        }
                        continue block14;
                    }
                    case 1050: {
                        int[] data = null;
                        switch (cnt1050) {
                            case 0: {
                                data = offset;
                                break;
                            }
                            case 1: {
                                data = count;
                                break;
                            }
                            case 2: {
                                data = sub;
                            }
                        }
                        for (int i = 0; i < part.length; ++i) {
                            data[i] = Integer.parseInt(part[i]);
                        }
                        ++cnt1050;
                    }
                }
            }
        }
        map.setCount(count);
        map.setStep(all_days, sub);
        map.add(key1040.toArray(new String[0]), data1041.toArray(new String[0]));
        System.out.println();
    }

    private static File[] makeList(String header, String ext) throws Exception {
        File dir = new File(header).getParentFile();
        ArrayList<FileList> list = new ArrayList<FileList>();
        for (File f : dir.listFiles()) {
            FileList fl = FileList.make(f, ext);
            if (fl == null) continue;
            list.add(fl);
        }
        if (list.size() == 0) {
            throw new Exception("No Data(GROUP 1070)");
        }
        FileList[] arr = list.toArray(new FileList[0]);
        Arrays.sort(arr, arr[0]);
        File[] ret = new File[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = arr[i].file;
        }
        return ret;
    }

    private static void write(int p_no, String data) throws Exception {
        byte[] org = MapXYZ.Conv(data).getBytes();
        if (JPL2Bin.map.size < org.length) {
            throw new Exception(String.format("Size over %d < %d", JPL2Bin.map.size, org.length));
        }
        if (JPL2Bin.map.size > org.length) {
            int i;
            byte[] b = new byte[JPL2Bin.map.size];
            for (i = 0; i < org.length; ++i) {
                b[i] = org[i];
            }
            while (i < b.length) {
                b[i] = 32;
                ++i;
            }
            org = b;
        }
        raf[p_no].write(org);
    }

    private static void set(String[] data) throws Exception {
        if (data == null) {
            return;
        }
        BigDecimal st = new BigDecimal(MapXYZ.Conv(data[0]));
        if (last_dt == null) {
            JPL2Bin.map.start_jed = st;
        }
        if (last_dt != null) {
            if (st.compareTo(last_dt) < 0) {
                System.out.println("SKIP: " + st.toString());
                return;
            }
            if (st.compareTo(last_dt) > 0) {
                throw new Exception("Next date mismatch");
            }
        }
        last_dt = st.add(new BigDecimal(all_days));
        int start = offset[0] - 1;
        for (int p = 0; p < planet.length; ++p) {
            int skip = planet[p].GetDim();
            skip *= count[p];
            for (int loop = 0; loop < sub[p]; ++loop) {
                for (int i = 0; i < skip; ++i) {
                    JPL2Bin.write(p, data[start]);
                    ++start;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readData(String file) throws Exception {
        System.out.println("Reading " + file);
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            String[] data = null;
            boolean pno = false;
            int cnt = 0;
            boolean start = false;
            int line_cnt = 0;
            while ((line = br.readLine()) != null) {
                ++line_cnt;
                if ((line = line.trim()).isEmpty()) continue;
                String[] part = line.split("\\s+");
                if (!start) {
                    if (part.length != 2) {
                        throw new Exception("Error line:" + Integer.toString(line_cnt) + "  " + line);
                    }
                    JPL2Bin.set(data);
                    pno = false;
                    cnt = 0;
                    data = new String[Integer.parseInt(part[1])];
                    start = true;
                    continue;
                }
                for (int i = 0; i < part.length; ++i) {
                    data[cnt] = part[i];
                    if (++cnt >= data.length) break;
                }
                if (cnt < data.length) continue;
                start = false;
            }
            JPL2Bin.set(data);
        }
        finally {
            System.out.println();
            if (br != null) {
                br.close();
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        System.out.println(Version.getTitle());
        System.out.println(Version.getCopyRight());
        System.out.println();
        if (argv.length != 2) {
            System.out.println("param>> input_header_file output_dir");
            return;
        }
        output = new File(argv[1]);
        output.mkdirs();
        String ext = JPL2Bin.getExt(argv[0]);
        for (int i = 0; i < planet.length; ++i) {
            JPL2Bin.raf[i] = new RandomAccessFile(new File(output, planet[i].getFileName()), "rw");
            raf[i].setLength(0L);
        }
        JPL2Bin.readHeader(argv[0]);
        for (File f : JPL2Bin.makeList(argv[0], ext)) {
            JPL2Bin.readData(f.toString());
        }
        for (int i = 0; i < planet.length; ++i) {
            raf[i].close();
        }
        JPL2Bin.map.end_jed = new BigDecimal(all_days).add(last_dt);
        map.save(output);
        map.printDate();
        System.out.println("Completed.");
    }

    static {
        raf = new RandomAccessFile[planet.length];
        last_dt = null;
    }
}

