/* -*- c++ -*- */
#ifndef AKAXISO2_XML_BABEL_BABEL_SERIALIZER_H__
#define AKAXISO2_XML_BABEL_BABEL_SERIALIZER_H__

#include <akaxiso2/configuration.h>

/**
 * @file akaxiso2/XML/babel/babel_serializer.h 
 * @brief XML serializer/formatter by using babel transcoder.
 */

#ifdef AKAXISO2_USE_BABEL

#include <akaxiso2/exception.h>
#include <akaxiso2/XML/serializer/xml_serializer_base.h>
#include <akaxiso2/imported/tricklib/tricklib.h>

namespace aka2 {

  /** @brief Formatter with babel encoding translator. */
  class babel_formatter : public formatter_base {
  public:
    babel_formatter() {}
    virtual ~babel_formatter() {}

  private:
    virtual void set_encoding(const std::string &encoding);
    virtual ustring lcp_to_ucs2(const std::string &source);
    virtual void write(const ustring &entity);

    babel::bbl_translater<std::string, ustring> in_translator_;
    babel::bbl_translater<ustring, std::string> out_translator_;
  };


  /** @brief XML serializer with babel encoding translator. */
  class babel_serializer : public xml_serializer_base {
  public:
    babel_serializer(const std::string &encoding = AKAXISO2_DEFAULT_ENCODING)
    : xml_serializer_base(encoding) {
      formatter_ = shared_ptr<formatter_base>(new babel_formatter());
      formatter_->set_encoding(encoding);
    }
  };



} // namespace aka2

#endif

#endif
