#include "any_handler.h"
#include "../../framework/any_op.h"
#include "../../framework/document_factory.h"
#include "../../util/sstream.h"

#include <cassert>

namespace aka2 {
  extern document_factory g_doc_factory_;
}

using namespace aka2;

any_handler::any_handler(any &an, int depth,
			 const qname &tagname, const element_props &props,
			 parser_context &context)  
  : handler(false, depth, props, context) , any_(an) { }

any_handler::~any_handler() {
  abort();
}


validation_result any_handler::query_element(const qname &tagname, const attribute_values &attrs){
  
  if (g_doc_factory_.is_document_type_registered(tagname)) {
    any_.document_ = g_doc_factory_.create_named_document(tagname);
    node root = any_.document_.get_root();
    create_handler(false, root.ptr(), root.op(), 
		   depth_, tagname, any_.document_.get_props(), context_);
    return ok;
  }
  else {
    create_wildcard_handler(any_.wc_, depth_, tagname, props_);
    return ok;
  }
}

validation_result any_handler::query_next(const qname &tagname, const attribute_values &attrs){
  assert(!"Must not be called.");
  return invalid;
}


validation_result any_handler::end_element(const qname &tagname){
  return ok;
}


bool any_handler::parse_entity(const std::string &entity) {
  // !!!!!!!!!!!!!!!!!!!!!! op check.
  return true;
}


node any_handler::get_node() {
  return node(&any_, aka2::any_op::dispatcher_);
}

void any_handler::receive_child(const node &child) {
}

bool any_handler::can_skip() {
  return false;
}

void any_handler::abort() {}
