/* -*- c++ -*- */
#ifndef AKAXISO2_XML_XERCES_HANLDER_H__
#define AKAXISO2_XML_XERCES_HANDLER_H__

#include <akaxiso2/configuration.h>
#ifdef AKAXISO2_USE_XERCESC

#include <akaxiso2/framework/document.h>
#include <akaxiso2/XML/deserializer/document_handler.h>
#include <xercesc/sax2/DefaultHandler.hpp>

namespace aka2 {

  class xerces_string {
  public:
    xerces_string(const XMLCh* xstr) {
      str_ = xercesc::XMLString::transcode(xstr);
    }
    ~xerces_string() {
      xercesc::XMLString::release(&str_);
    }
    const char *str() const { return str_; }
  private:
    char *str_;
  };


  class xerces_handler : public xercesc::DefaultHandler {
  public:
    xerces_handler(preconditions *pcd) : handler_(pcd) {}
    virtual ~xerces_handler(){}
    void set_source_name(const std::string &source_name) {
      handler_.set_source_name(source_name);
    }

   virtual void startDocument();
//    virtual void endDocument();

    virtual void startElement(const XMLCh* const uri, const   XMLCh* const    localname, const   XMLCh* const qname , const xercesc::Attributes& attrs);
    virtual void characters(const XMLCh* const chars, const unsigned int length);
    virtual void endElement(const XMLCh* const uri, const XMLCh* const localname, const XMLCh* const qname);
    
    virtual void startPrefixMapping(const XMLCh* const  prefix, const XMLCh* const  uri) ;
    virtual void endPrefixMapping(const XMLCh* const  prefix);
    
//    virtual void ignorableWhitespace(const XMLCh* const chars, const unsigned int length);
//    virtual void processingInstruction(const   XMLCh* const    target, const XMLCh* const    data);
//    virtual void resetDocument();

    virtual void setDocumentLocator(const xercesc::Locator* const locator);

//    virtual void skippedEntity(const  XMLCh* const  name) ;
//    virtual InputSource* resolveEntity(const   XMLCh* const    publicId, const XMLCh* const    systemId);

//    virtual void comment(const   XMLCh* const    chars, const unsigned int    length);
//    virtual void startCDATA ();
//    virtual void endCDATA ();

// Errors 
    virtual void error(const xercesc::SAXParseException& exception);
    virtual void fatalError(const xercesc::SAXParseException& exception);
    virtual void warning(const xercesc::SAXParseException& exception);
//      virtual void resetErrors();

// DTD-related methods.
/*    virtual void startDTD(const   XMLCh* const    name, const   XMLCh* const    publicId, const   XMLCh* const    systemId);
    virtual void endDTD ();
    virtual void notationDecl(const XMLCh* const name, const XMLCh* const    publicId, const XMLCh* const    systemId);
    virtual void resetDocType();
    virtual void unparsedEntityDecl(const   XMLCh* const    name, const XMLCh* const    publicId, const XMLCh* const    systemId, const XMLCh* const    notationName);
    virtual void elementDecl(const   XMLCh* const    name, const XMLCh* const    model);
    virtual void attributeDecl(const   XMLCh* const    eName, const XMLCh* const    aName, const XMLCh* const    type, const XMLCh* const    mode, const XMLCh* const    value);
    virtual void internalEntityDecl(const   XMLCh* const    name, const XMLCh* const    value);
    virtual void externalEntityDecl(const   XMLCh* const    name, const XMLCh* const    publicId, const XMLCh* const    systemId);
*/
/*
    virtual void startEntity (const XMLCh* const name);
    virtual void endEntity (const XMLCh* const name);
*/


/*
    virtual void startElement(const XMLCh* const name, AttributeList&  attrs);
    virtual void endElement(const XMLCh* const name);
    virtual void characters(const   XMLCh* const    chars, 
          const unsigned int    length);
*/
    document get_document();

  private:
    document_handler handler_;
  };

}

#endif // AKAXISO2_USE_XERCESC

#endif

