/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_ALL_H__
#define AKAXISO2_FRAMEWORK_ALL_H__

/**
 * @file akaxiso2/framework/all.h
 * @brief @ref aka_all -related classes/templates
 */

#include <akaxiso2/framework/simpletype.h>
#include <akaxiso2/framework/attribute.h>
#include <akaxiso2/framework/memberdef.h>

namespace aka2 {

  template<class L>
  class all_op_dispatcher : public all_op {
  public:
    virtual schematype_id get_schematype() const { return all_id; }
    virtual std::string get_typename() const { return L::get_xmltype(); }
    /** creatable */
    virtual void construct(void *e) const {  L::construct(e); }
    virtual void copy_construct(void *e, const void *src) const { L::copy_construct(e, src); }
    virtual void destruct(void *e) const { L::destruct(e); }
    virtual size_t class_size() const { return L::class_size(); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }

    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const {
      return &L::attribute_types_;
    }
    virtual const attribute_type *get_anyattr_type() const { return L::get_anyattr_type(); }
    /** all_info getter. */
    virtual const member_map &get_member_map() const {
      return L::member_map_;
    }
  };

  template<class L>
  struct all_statics {
    static member_map member_map_;
    static all_op_dispatcher<L> dispatcher_;
    static occurrence occ_;
  };

  template<class L>
  member_map all_statics<L>::member_map_;

  template<class L>
  aka2::occurrence all_statics<L>::occ_;

  template<class L>
  all_op_dispatcher<L> all_statics<L>::dispatcher_;

  
  /**
   * @brief template to define @ref aka_all leaf class.
   *
   * Leaf classes for @ref aka_all are derived from this template class.\n
   * Most of Member-defining classes/functions are implemented in aka2::memberdef<L, T>.\n
   *
   * @param T value class type
   * @param L leaf class type
   */
  template<class T, class L=xiso::leaf<T> >
  class all : public all_statics<L>, 
	      public attributes<L, T>,
	      public memberdef<L, T> {
  public:
    typedef T value_type;
    
    virtual ~all(){}
    
    static member_type* register_membertype(const member_type &mtype) {
      std::pair<member_map::iterator, bool> res =
    	L::member_map_.insert(member_map::value_type(mtype.get_name(), mtype));
      if (!res.second)
	throw tagged_error("element", mtype.get_name().qualified(), "declared twice.",
			   __FILE__, __LINE__);
      return &res.first->second;
    }
    
    static void initialize() {
      if (!system_type_registry().add(L()))
      	return;
      L::member_map_.clear();
      L::attribute_types_.clear();
      L l; l.model(); // VC6 does not accept L().model();
      check_emptiable(L::member_map_);
    }

    static void uninitialize() {
      L::member_map_.clear();
      L::attribute_types_.clear();
    }

    static void construct(void *e) {
      new (e) T();
      all_construct(e, L::dispatcher_);
    }
    static void copy_construct(void *e, const void *src) {
      new (e) T(*static_cast<const T*>(src));
    }
    static size_t class_size() { return sizeof(T); }
    static void destruct(void *elm) { static_cast<T*>(elm)->~T(); }

    static bool equals(const void *lhs, const void *rhs) {
      return all_equals(lhs, rhs, L::dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &L::dispatcher_; }
    static default_op* create_default_op() { return 0; }

    /**
     * @brief define occurrence of @ref aka_all itselt.
     * @param minOccurs minOccurs ( 0 or 1 )
     * @param maxOccurs maxOccurs (always should be 1)
     */
    static void occurrence(int minOccurs, int maxOccurs) {
      aka::occurrence occ(minOccurs, maxOccurs);
      if (!is_all_occurrence(occ))
	throw tagged_error("xs:all", L::get_xmltype(), "wrong occurrence.", 
			   __FILE__, __LINE__);
      L::occ_ = occ;
    }
  };

} // namespace aka2

#endif
