#include "platform.h"
#include "../exception.h"

#include <iostream>


#if defined(_MSC_VER) && _MSC_VER < 1300

std::istream &operator >>(std::istream &istm, _int64 &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64d", &value) != 1)
    throw aka2::error("Failed to parse LONGLONG", __FILE__, __LINE__);
  return istm;
}

std::istream &operator >>(std::istream &istm, unsigned _int64 &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64u", &value) != 1)
    throw aka2::error("Failed to parse LONGLONG", __FILE__, __LINE__);
  return istm;
}

#endif /* defined(_MSC_VER) && _MSC_VER < 1300 */


// unsigned int aka2::readsome(std::istream &istm, char * toFill, const unsigned int maxToRead) {
//   return istm.readsome(reinterpret_cast<char*>(toFill), maxToRead);
// }

unsigned int aka2::readsome(std::istream &istm, char * toFill, const unsigned int maxToRead) {
  unsigned int index = 0;
  for (;index < maxToRead; ++index) {
    istm.get(*reinterpret_cast<char*>(toFill));
    if (istm.fail())
      break;
    ++toFill;
  }
  return index;
}


unsigned int aka2::readsome(std::istream &istm, std::string &toFill, 
          const unsigned int maxToRead) {
  unsigned int index = 0;
  for (;index < maxToRead; ++index) {
    char ch;
    istm.get(ch);
    if (istm.fail())
      break;
    toFill += ch;
  }
  return index;
}
