#include "string_funcs.h"

std::string aka2::trim(const std::string &str) {
  if (str.empty())
    return str;
  std::string::size_type begin_pos = str.find_first_not_of(' ');
  std::string::size_type end_pos = str.find_last_not_of(' ');
  return str.substr(begin_pos, end_pos - begin_pos + 1);
}

std::string aka2::trim_left(const std::string &str) {
  std::string::size_type begin_pos = str.find_first_not_of(' ');
  if (begin_pos == std::string::npos)
    return str;
  else
    return str.substr(begin_pos);
}

std::string aka2::quote(const std::string &str) {
  return "\"" + str + "\"";
}

std::string aka2::tag(const std::string &str) {
  return "<" + str + ">";
}
