#include "all_test.h"

#include <akaxiso2/akaxiso2.h>
#include <iostream>
#include <stdlib.h>

void serialize() {

  params root;
  root.one_ = "one";
  root.two_ = "two";
  root.three_.reset(new std::string("three"));
  //root.three_.reset();

  aka::xml_serializer ser;
  ser.serialize(root, "params", std::cout);

}

void deserialize() {
  
  aka::document doc;
  try {
    doc = aka::deserialize(std::cin);
  }
  catch ( const std::exception &e) {
    std::cerr << e.what() << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Deserialize error detected." << std::endl;
    exit(1);
  }

  
  // Check root tagname to confirm the root class.
  if (!aka::document_of(doc, "params")) {
    std::cerr << "Unknown document(" << doc.get_name() << ")." << std::endl;
    exit(1);
  }

  // Get the root node.
  params *root = aka::root_cast<params>(doc);
  std::cout << "Params:" << std::endl
            << "one   : " << root->one_ << std::endl
            << "two   : " << root->two_ << std::endl
            << "three : ";
  if (root->three_.get() == 0)
    std::cout << "(null)" << std::endl;
  else
    std::cout << *root->three_ << std::endl;

}


void usage() {
  std::cout << "project [-s|-d|-h]" << std::endl
            << "  -s : serialize." << std::endl
            << "  -d : deserialize.    " << std::endl
            << "  -h : show this usage." << std::endl;
}


int main(int argc, const char* argv[]) {

  aka::initialize();

  aka::doctype("params", xiso::leaf<params>());

  if (argc != 2) {
    usage();
    return 1;
  }

  std::string arg = argv[1];

  if (arg == "-s")
    serialize();
  else if (arg == "-d")
    deserialize();
  else {
    usage();
    return 1;
  }

  aka::uninitialize();
  return 0;
}
