#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>

#include <iostream>

struct string_operator : aka::property_operator {
  virtual void reset_for_new_document(void *e) const {
    std::string *str = static_cast<std::string*>(e);
    *str = "";
  }
};


struct root {
  std::string value_;
};

struct value_leaf : aka::simpletype<std::string, value_leaf> {
  static void read_text(void *e, aka::isstream &istm, 
			const aka::preconditions &pcd) {
    std::string &read_value = pcd.get_property<std::string>("value_leaf");
    read_value = istm.rdbuf()->str();
    *static_cast<std::string*>(e) = read_value;
  }
};


struct root_leaf : aka::sequence<root, root_leaf> {
  void model() {
    member("value", &root::value_, value_leaf());
  }
};


int main() {
  aka::initialize();
  aka::doctype("custom", root_leaf());

  root rt;
  rt.value_ = "test";

  std::ostringstream ostm;
  aka::xml_serializer ser;
  ser.serialize(rt, "custom", ostm);
  std::cout << ostm.str();


  aka::xml_deserializer deser;
  aka::preconditions pcd;
  std::string saved_value;
  pcd.add_property("value_leaf", saved_value, new string_operator());
  
  deser.set_preconditions(pcd);
  deser.deserialize(ostm.str());

  std::cout << "Saved value : " << saved_value << std::endl;

}
