/* -*- c++ -*- */
#ifndef AKAXISO_SCHEMA_SCHEMA_XISO_H__
#define AKAXISO_SCHEMA_SCHEMA_XISO_H__

#include <akaxiso2/builtin/schema_builtin_xiso.h>
#include <osixaka2/schemadatatypes.h>
#include <osixaka2/schemastructure.h>

namespace xs {

  /**
   *
   * Common base classes from Schema Structures
   *
   */
  
  struct allNNILeaf : aka::simpletype<allNNI, allNNILeaf> {
    static void read_text(void *elm, aka2::isstream &istm, 
			  const aka::preconditions &pcd);
    static void write_text(const void *elm, std::ostream &ostm,
			  const aka::preconditions &pcd);
    static bool equals(const void *lhs, const void *rhs) {
      return *static_cast<const allNNI*>(lhs) == *static_cast<const allNNI*>(rhs);
    }
  };

  struct appinfoLeaf : aka::sequence<appinfo, appinfoLeaf> { void model(); };

  struct documentationLeaf : aka::sequence<documentation, documentationLeaf> { void model(); };

  struct openAttrsLeaf : aka::sequence<openAttrs, openAttrsLeaf> {
    void model();
  };

  struct annotationContentsLeaf 
    : aka::sequential_choice<choice, annotationContentsLeaf> {
    void model();
  };

  struct annotationLeaf : aka::sequence<annotation, annotationLeaf> {
    void model();
  };

  struct annotatedLeaf : aka::sequence<annotated, annotatedLeaf> {
    void model();
  };


  /**
   *
   *  Schema data types.
   *
   */

  /**
   * Facet
   */

  struct facetLeaf : public aka::sequence<facet, facetLeaf> {
    void model();
  };
  
  struct noFixedFacetLeaf : public aka::sequence<noFixedFacet, noFixedFacetLeaf> {
    void model();
  };

  struct numFacetLeaf : public aka::sequence<numFacet, numFacetLeaf> {
    void model();
  };

  struct totalDigitsLeaf : public aka::sequence<totalDigits, totalDigitsLeaf> {
    void model();
  };

  struct whiteSpaceLeaf : aka::sequence<whiteSpace, whiteSpaceLeaf> {
    void model();
  };

  struct facetsLeaf : aka::sequential_choice<facets, facetsLeaf> {
    void model();
  };


  /**
   * simpleType definition-related one.
   */

  /** simpleTypeLeaf ..... abstract one.  It is not used directly. */
//   struct simpleTypeLeaf : aka::sequence<simpleType, simpleTypeLeaf> {
//     void model();
//   };
  
  /** simpleTypeLeaf ..... abstract one.  It is not used directly. */
  struct topLevelSimpleTypeLeaf : aka::sequence<topLevelSimpleType, topLevelSimpleTypeLeaf> {
    void model();
  };

  struct localSimpleTypeLeaf 
    : aka::sequence<localSimpleType, localSimpleTypeLeaf> {
    void model();
  };

  typedef aka::sequential_array<localSimpleTypes, localSimpleTypeLeaf> localSimpleTypesLeaf; 
  
  struct simpleRestrictionModelLeaf
    : aka::sequence<simpleRestrictionModel, simpleRestrictionModelLeaf> {
    void model();
  };
  
  struct listLeaf : aka::sequence<list, listLeaf> {
    void model();
  };

  struct unionLeaf : aka::sequence<_union, unionLeaf> {
    void model();
  };

  struct restrictionLeaf : aka::sequence<restriction, restrictionLeaf> {
    void model();
  };

  struct simpleDerivationLeaf : 
    aka::sequential_choice<simpleDerivation, simpleDerivationLeaf> {
    void model();
  };
  

  /**
   *
   *  Schema Structures.
   *
   */

  struct typeDefParticleLeaf : aka::sequential_choice<typeDefParticle, typeDefParticleLeaf> {
    void model();
  };

  struct occursLeaf : aka::sequence<occurs, occursLeaf> {
    void model();
  };

  struct nestedParticleLeaf : aka::sequential_choice<nestedParticle, nestedParticleLeaf> {
    void model();
  };

  struct particleLeaf : public aka::sequential_choice<particle, particleLeaf> {
    void model();
  };

  struct defRefLeaf : aka::sequence<defRef, defRefLeaf> {
    void model();
  };

  struct attributeLeaf : aka::sequence<attribute, attributeLeaf> {
    void model();
  };

  struct attributeChoiceLeaf : aka::sequential_choice<attributeChoice, attributeChoiceLeaf> {
    void model();
  };

  struct attrDeclsLeaf : aka::sequence<attrDecls, attrDeclsLeaf> {
    void model();
  };

  struct restrictionContentLeaf
    : aka::sequential_choice<restrictionContent, restrictionContentLeaf> {
    void model();
  };

  struct restrictionTypeLeaf : aka::sequence<restrictionType, restrictionTypeLeaf> {
    void model();
  };

  struct simpleRestrictionTypeLeaf
    : aka::sequence<simpleRestrictionType, simpleRestrictionTypeLeaf> {
    void model();
  };

  struct topLevelAttributeLeaf : aka::sequence<topLevelAttribute, topLevelAttributeLeaf> {
    void model();
  };

  struct extensionTypeLeaf : aka::sequence<extensionType, extensionTypeLeaf> {
    void model();
  };

  struct simpleExtensionTypeLeaf : aka::sequence<simpleExtensionType, simpleExtensionTypeLeaf> {
    void model();
  };

  struct contentDefLeaf : aka::sequence<contentDef, contentDefLeaf> {
    void model();
  };

  struct complexTypeModelLeaf : aka::sequential_choice<complexTypeModel, complexTypeModelLeaf> {
    void model();
  };

//  struct attributeGroupLeaf : aka::sequence<attributeGroup, attributeGroupLeaf> {
//    void model();
//  };

  struct attributeGroupRefLeaf : aka::sequence<attributeGroupRef, attributeGroupRefLeaf> {
    void model();
  };

//   struct complexTypeLeaf : public aka::sequence<complexType, complexTypeLeaf> {
//     void model();
//   };

  struct topLevelComplexTypeLeaf 
    : aka::sequence<topLevelComplexType, topLevelComplexTypeLeaf> {
    void model();
  };

  struct localComplexTypeLeaf : public aka::sequence<localComplexType, localComplexTypeLeaf> {
    void model();
  };

  struct complexRestrictionTypeLeaf : aka::sequence<complexRestrictionType, 
				      complexRestrictionTypeLeaf> {
    void model();
  };

  struct complexContentContentsLeaf 
    : aka::sequential_choice<complexContentContents, complexContentContentsLeaf> {
    void model();
  };
  
  struct complexContentLeaf : aka::sequence<complexContent, complexContentLeaf> {
    void model();
  };

  struct groupLeaf : public aka::sequence<group, groupLeaf> {
    void model();
  };

  struct realGroupParticleLeaf 
    : aka::sequential_choice<realGroupParticle, realGroupParticleLeaf> {
    void model();
  };

  struct realGroupLeaf : public aka::sequence<realGroup, realGroupLeaf> {
    void model();
  };

  struct groupRefLeaf : aka::sequence<groupRef, groupRefLeaf> {
    void model();
  };

  struct selectorLeaf : aka::sequence<selector, selectorLeaf> {
    void model();
  };

  struct fieldLeaf : aka::sequence<field, fieldLeaf> {
    void model();
  };

  typedef aka::sequential_array<fields, fieldLeaf> fieldsLeaf;

  struct keybaseLeaf : aka::sequence<keybase, keybaseLeaf> {
    void model();
  };

  struct keyrefLeaf : aka::sequence<keyref, keyrefLeaf> {
    void model();
  };

  struct identityConstraintLeaf 
    : aka::sequential_choice<identityConstraint, identityConstraintLeaf> {
    void model();
  };

  struct typeChoiceLeaf : aka::sequential_choice<typeChoice, typeChoiceLeaf> {
    void model();
  };

//   struct elementLeaf : aka::sequence<element, elementLeaf> {
//     void model();
//   };

  struct localElementLeaf : aka::sequence<localElement, localElementLeaf> {
    void model();
  };

  struct topLevelElementLeaf : aka::sequence<topLevelElement, topLevelElementLeaf> {
    void model();
  };

  struct allModelElementLeaf : aka::sequence<allModelElement, allModelElementLeaf> {
    void model();
  };

  struct explicitGroupLeaf : aka::sequence<explicitGroup, explicitGroupLeaf> {
    void model();
  };

  struct simpleExplicitGroupLeaf : aka::sequence<simpleExplicitGroup, simpleExplicitGroupLeaf> {
    void model();
  };
  
  typedef aka::sequential_array<allModelElements, allModelElementLeaf> allModelElementsLeaf;

  struct allModelLeaf : aka::sequence<allModel, allModelLeaf> {
    void model();
  };

  struct allLeaf : aka::sequence<all, allLeaf> {
    void model();
  };

  struct namedGroupLeaf : aka::sequence<namedGroup, namedGroupLeaf> {
    void model();
  };

  struct redefinableLeaf : aka::sequential_choice<redefinable, redefinableLeaf> {
    void model();
  };

  struct wildcardLeaf : aka::sequence<wildcard, wildcardLeaf> {
    void model();
  };

  struct anyLeaf : aka::sequence<any, anyLeaf> {
    void model();
  };

  struct simpleContentChoiceLeaf 
    : aka::sequential_choice<simpleContentChoice, simpleContentChoiceLeaf> {
    void model();
  };

  struct simpleContentLeaf : aka::sequence<simpleContent, simpleContentLeaf> {
    void model();
  };

  struct anyTypeLeaf : aka::sequence<anyType, anyTypeLeaf> {
    void model();
  };

  struct notationLeaf : aka::sequence<notation, notationLeaf> {
    void model();
  };

  struct namedAttributeGroupLeaf : aka::sequence<namedAttributeGroup, namedAttributeGroupLeaf> {
    void model();
  };

  struct includeLeaf : aka::sequence<_include, includeLeaf> {
    void model();
  };

  struct redefineContentsLeaf : aka::sequential_choice<redefineContents, redefineContentsLeaf> {
    void model();
  };

  struct redefineLeaf : aka::sequence<redefine, redefineLeaf> {
    void model();
  };

  struct importLeaf : aka::sequence<import, importLeaf> {
    void model();
  };

  struct directivesLeaf : aka::sequential_choice<directives, directivesLeaf> {
    void model();
  };

  struct schemaTopLeaf : aka::sequential_choice<schemaTop, schemaTopLeaf> {
    void model();
  };

  typedef aka::sequential_array<annotations, annotationLeaf> annotationsLeaf;

  struct annotatedSchemaTopLeaf : aka::sequence<annotatedSchemaTop, annotatedSchemaTopLeaf> {
    void model();
  };

  typedef aka::sequential_array<annotatedSchemaTops, annotatedSchemaTopLeaf> annotatedSchemaTopsLeaf;

  struct schemaLeaf : aka::sequence<schema, schemaLeaf> {
    void model();
  };

  void instantiate_xiso();
}

#endif
