/* -*- c++ -*- */
#ifndef XMLSchema_h__
#define XMLSchema_h__

#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>

#include "xml.h"



namespace xs {

  /** simpleType definitions */

  typedef long allNNI;

  typedef ::xs::allNNI all_maxOccurs;

  typedef long all_minOccurs;

  typedef ::std::string attribute_use;

  typedef ::std::string blockSet;

  typedef ::std::string derivationControl;

  typedef ::std::string derivationSet;

  typedef ::std::string field_xpath;

  typedef ::std::string formChoice;

  typedef ::std::string fullDerivationSet;

  typedef ::std::string namespaceList;

  typedef ::xs::allNNI narrowMaxMin_maxOccurs;

  typedef long narrowMaxMin_minOccurs;

  typedef ::std::string _public;

  typedef ::xs::derivationControl reducedDerivationControl;

  typedef ::std::string selector_xpath;

  typedef ::std::string simpleDerivationSet;

  typedef ::xs::derivationControl typeDerivationControl;

  typedef ::std::string union_memberTypes;

  typedef ::std::string whiteSpace_value;

  typedef ::std::string wildcard_processContents;

  /** complexType definitions */

  struct appinfo {
    /** members */
    ::aka::any_array any_;
    /** attributes */
    ::std::string source_;
    aka::wc_attributes attributes_;
  };

  struct documentation {
    /** members */
    ::aka::any_array any_;
    /** attributes */
    ::std::string source_;
    ::std::string xml_lang_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> annotation_choice;
  struct annotation {
    /** members */
    ::xs::annotation_choice c0_;
    /** attributes */
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  struct annotated {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  struct any {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::xs::namespaceList namespace_;
    ::xs::wildcard_processContents processContents_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct anyType {
    /** members */
    ::aka::any_array any_;
    /** attributes */
    aka::wc_attributes attributes_;
  };

  struct attributeGroupRef {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::aka::qname ref_;
    aka::wc_attributes attributes_;
  };

  struct facet {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  struct totalDigits {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  struct numFacet {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  struct noFixedFacet {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string value_;
    aka::wc_attributes attributes_;
  };

  struct whiteSpace {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  struct pattern {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string value_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> facets;
  struct field {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::xs::field_xpath xpath_;
    aka::wc_attributes attributes_;
  };

  struct groupRef {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::aka::qname ref_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct selector {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::xs::selector_xpath xpath_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::field> field_array;

  struct keybase {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::selector selector_;
    ::xs::field_array field_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    aka::wc_attributes attributes_;
  };

  struct keyref {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::selector selector_;
    ::xs::field_array field_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname refer_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> identityConstraint;
  struct import {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string namespace_;
    ::std::string schemaLocation_;
    aka::wc_attributes attributes_;
  };

  struct include {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string schemaLocation_;
    aka::wc_attributes attributes_;
  };

  struct notation {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::xs::_public public_;
    ::std::string system_;
    aka::wc_attributes attributes_;
  };

  struct openAttrs {
    /** attributes */
    aka::wc_attributes attributes_;
  };

  struct wildcard {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::std::string id_;
    ::xs::namespaceList namespace_;
    ::xs::wildcard_processContents processContents_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> attrDecls_c0;
  struct attrDecls {
    /** members */
    ::xs::attrDecls_c0 c0_;
    aka::deep_ptr< ::xs::wildcard> anyAttribute_;
  };

  struct attributeGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    aka::wc_attributes attributes_;
  };

  struct namedAttributeGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    aka::wc_attributes attributes_;
  };

  struct simpleExtensionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::aka::qname base_;
    aka::wc_attributes attributes_;
  };

  /** forwareded declaration for ptrmember value class. */
  struct localSimpleType;
  struct attribute {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    ::aka::qname type_;
    ::xs::attribute_use use_;
    ::std::string default_;
    ::std::string fixed_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> complexContent_choice;
  struct complexContent {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexContent_choice c0_;
    /** attributes */
    ::std::string id_;
    bool mixed_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> typeDefParticle;
  struct complexRestrictionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::typeDefParticle typeDefParticle_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::aka::qname base_;
    aka::wc_attributes attributes_;
  };

  struct extensionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::typeDefParticle typeDefParticle_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::aka::qname base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> complexTypeModel;
  struct complexType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexTypeModel complexTypeModel_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    bool mixed_;
    bool abstract_;
    ::xs::derivationSet final_;
    ::xs::derivationSet block_;
    aka::wc_attributes attributes_;
  };

  struct complexTypeModel_s0 {
    /** members */
    ::xs::typeDefParticle typeDefParticle_;
    ::xs::attrDecls attrDecls_;
  };

  struct localComplexType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexTypeModel complexTypeModel_;
    /** attributes */
    ::std::string id_;
    bool mixed_;
    aka::wc_attributes attributes_;
  };

  struct topLevelComplexType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexTypeModel complexTypeModel_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    bool mixed_;
    bool abstract_;
    ::xs::derivationSet final_;
    ::xs::derivationSet block_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> element_sequence_c0;
  struct element {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::element_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    ::aka::qname type_;
    ::aka::qname substitutionGroup_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    bool abstract_;
    ::xs::derivationSet final_;
    ::xs::blockSet block_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> nestedParticle;
  struct explicitGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::nestedParticle nestedParticle_;
    /** attributes */
    ::std::string id_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct simpleExplicitGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::nestedParticle nestedParticle_;
    /** attributes */
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  /** forwareded declaration for ptrmember value class. */
  struct localSimpleType;
  struct list {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    /** attributes */
    ::std::string id_;
    ::aka::qname itemType_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> localElement_sequence_c0;
  struct localElement {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::localElement_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    ::aka::qname type_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    ::xs::blockSet block_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> simpleDerivation;
  struct localSimpleType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleDerivation simpleDerivation_;
    /** attributes */
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> narrowMaxMin_sequence_c0;
  struct narrowMaxMin {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::narrowMaxMin_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    ::aka::qname type_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    ::xs::blockSet block_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::narrowMaxMin> narrowMaxMin_array;

  struct allModel {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::narrowMaxMin_array element_;
  };

  struct all {
    /** members */
    ::xs::allModel allModel_;
    /** attributes */
    ::std::string id_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> particle;
  struct group_particle {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::particle particle_;
  };

  typedef std::list< ::xs::group_particle> group_particle_array;

  struct group {
    /** members */
    ::xs::group_particle_array group_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct namedGroup_sequence_c0_all {
    /** members */
    ::xs::allModel allModel_;
    /** attributes */
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> namedGroup_sequence_c0;
  struct namedGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::namedGroup_sequence_c0 c0_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> realGroup_sequence_c0;
  struct realGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::realGroup_sequence_c0 c0_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname ref_;
    long minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct topLevelSimpleType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleDerivation simpleDerivation_;
    /** attributes */
    ::std::string id_;
    ::xs::simpleDerivationSet final_;
    ::std::string name_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> redefinable;
  typedef std::list<aka::item> redefine_choice;
  struct redefine {
    /** members */
    ::xs::redefine_choice c0_;
    /** attributes */
    ::std::string schemaLocation_;
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  struct simpleRestrictionModel {
    /** members */
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    ::xs::facets facets_;
  };

  struct restriction {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleRestrictionModel simpleRestrictionModel_;
    /** attributes */
    ::std::string id_;
    ::aka::qname base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> restrictionType_sequence_c0;
  struct restrictionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::restrictionType_sequence_c0 c0_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::aka::qname base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> schema_sequence_c0;
  typedef std::list<aka::item> topLevelElement_sequence_c0;
  struct topLevelElement {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::topLevelElement_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname type_;
    ::aka::qname substitutionGroup_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    bool abstract_;
    ::xs::derivationSet final_;
    ::xs::blockSet block_;
    aka::wc_attributes attributes_;
  };

  struct topLevelAttribute {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    /** attributes */
    ::std::string id_;
    ::std::string name_;
    ::aka::qname type_;
    ::std::string default_;
    ::std::string fixed_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> schemaTop;
  typedef std::list< ::xs::annotation> annotation_array;

  struct schema_sequence_s0 {
    /** members */
    ::xs::schemaTop schemaTop_;
    ::xs::annotation_array annotation_;
  };

  typedef std::list< ::xs::schema_sequence_s0> schema_sequence_s0_holder;

  struct schema {
    /** members */
    ::xs::schema_sequence_c0 c0_;
    ::xs::schema_sequence_s0_holder array0_;
    /** attributes */
    ::std::string targetNamespace_;
    ::std::string version_;
    ::xs::fullDerivationSet finalDefault_;
    ::xs::blockSet blockDefault_;
    ::xs::formChoice attributeFormDefault_;
    ::xs::formChoice elementFormDefault_;
    ::std::string id_;
    ::std::string xml_lang_;
    aka::wc_attributes attributes_;
  };

  struct simpleRestrictionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::simpleRestrictionModel> simpleRestrictionModel_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::std::string id_;
    ::aka::qname base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> simpleContent_choice;
  struct simpleContent {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleContent_choice c0_;
    /** attributes */
    ::std::string id_;
    aka::wc_attributes attributes_;
  };

  struct simpleType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleDerivation simpleDerivation_;
    /** attributes */
    ::std::string id_;
    ::xs::simpleDerivationSet final_;
    ::std::string name_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::localSimpleType> localSimpleType_array;

  struct _union {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::localSimpleType_array simpleType_;
    /** attributes */
    ::std::string id_;
    ::xs::union_memberTypes memberTypes_;
    aka::wc_attributes attributes_;
  };


}

#endif // #ifndef XMLSchema_h__
