#include "classdefs.h"
#include "name_resolver.h"
#include "exception.h"

#include <assert.h>


using namespace osx;

bool attribute_defs::exists(const aka::qname &name) const {
  for (attribute_types::const_iterator it = attributes_.begin();
       it != attributes_.end(); ++it) {
    if (it->name_ == name)
      return true;
  }
  return false;
}

void attribute_defs::erase(const aka::qname &name) {
  for (attribute_types::iterator it = attributes_.begin();
       it != attributes_.end(); ++it) {
    if (it->name_ == name) {
      attributes_.erase(it);
      return;
    }
  }
  assert(!"Must not reach here.");
}

attribute_type &attribute_defs::get(const aka::qname &name) {
  for (attribute_types::iterator it = attributes_.begin();
       it != attributes_.end(); ++it) {
    if (it->name_ == name) {
      return *it;
    }
  }
  assert(!"Must not reach here.");
  return *static_cast<attribute_type*>(0);
}


class_def* class_def::derive(const aka::qname &name) const {
  class_def *def = new class_def(*this);
  def->name_ = name;
  return def;
}


void element_types::check_dup_names() const {
  qname_set names;
  for (element_types::const_iterator it = begin();
       it != end(); ++it) {
    if (names.find(it->name_) != names.end())
      throw fatal_error();
    names.insert(it->name_);
  }
}

void attribute_defs::check_dup_names() const {
  qname_set names;
  for (attribute_types::const_iterator it = attributes_.begin();
       it != attributes_.end(); ++it) {
    if (names.find(it->name_) != names.end())
      throw fatal_error();
    names.insert(it->name_);
  }
}
