/* -*- c++ -*- */
#ifndef OSIXAKA2_NAME_RESOLVER_H__
#define OSIXAKA2_NAME_RESOLVER_H__

#include <akaxiso2/framework/qname.h>
#include <map>

namespace osx {

  class name_resolver {
    typedef std::map<aka::qname, aka::qname, aka::qname_less> pairs;
    pairs pairs_;
  public:
    bool exists(const aka::qname &name) const;
    void add(const aka::qname &name, const aka::qname& t);
    void add(const aka::qname &name);
    void erase(const aka::qname &name);
    void replace(const aka::qname &name, const aka::qname &newname);
    const aka::qname& resolve(const aka::qname &name) const;

    typedef pairs::iterator iterator;
    iterator begin() { return pairs_.begin(); }
    iterator end() { return pairs_.end(); }

    void clear() {
      pairs_.clear();
    }
  };
}

#endif
